#include "Blast/Graphic/DirectX9/MeshGridDX9.h"

#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/VertexStreamType.h"

#include "Blast/String/StringHelper.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshGridDX9::MeshGridDX9()
	: mPrimitiveCount(-1)
{
}

/// fXgN^
MeshGridDX9::~MeshGridDX9()
{
}


/// 쐬
void MeshGridDX9::Create(float size, float interval)
{
	std::vector<Vector3> vertices;
	std::vector<unsigned> colors;


	// Og̏c쐬
	vertices.push_back( Vector3(0, 0, 0) );
	vertices.push_back( Vector3(0, 0, size) );
	vertices.push_back( Vector3(size, 0, 0) );
	vertices.push_back( Vector3(size, 0, size) );

	// Og̉쐬
	vertices.push_back( Vector3(0, 0, 0) );
	vertices.push_back( Vector3(size, 0, 0) );
	vertices.push_back( Vector3(0, 0, size) );
	vertices.push_back( Vector3(size, 0, size) );


	// ̏c쐬
	const int kLineCount = static_cast<int>(size / interval);
	for (int i = 0; i < kLineCount; ++i)
	{
		Vector3 p0(interval * i, 0, 0);
		Vector3 p1(p0.mX, 0, size);

		vertices.push_back(p0);
		vertices.push_back(p1);
	}

	// ̉쐬
	for (int i = 0; i < kLineCount; ++i)
	{
		Vector3 p0(0, 0, interval * i);
		Vector3 p1(size, 0, p0.mZ);

		vertices.push_back(p0);
		vertices.push_back(p1);
	}

	// Obh̒S[h[ɑ
	const float kOffset = -size * 0.5f;
	for (unsigned i = 0; i < vertices.size(); ++i)
	{
		Vector3& rPos = vertices.at(i);
		rPos.mX += kOffset;
		rPos.mZ += kOffset;
	}

	
	// F̍쐬
	Color color = Color(ColorCode::ToCode(ColorCode::eCOLOR_WHITE));
	for (unsigned i = 0; i < vertices.size(); ++i)
	{
		color.mAlpha = 0.5f;
		colors.push_back(color.GetARGB());
	}


	// _obt@쐬
	SP<VertexBufferDX9> pPositionBuffer(NEW VertexBufferDX9());
	pPositionBuffer->SetVertices(&vertices.front(), vertices.size(), sizeof(Vector3) * vertices.size());
	mPVertexBuffers[eVB_POSITION] = pPositionBuffer;

	SP<VertexBufferDX9> pColorBuffer(NEW VertexBufferDX9());
	pColorBuffer->SetVertices(&colors.front(), colors.size(), sizeof(unsigned) * colors.size());
	mPVertexBuffers[eVB_COLOR] = pColorBuffer;

	// _`쐬
	VertexElementFactoryDX9 vef;
	const D3DVERTEXELEMENT9 elements[] =
	{
		vef.CreateElement(VertexElementType::eELEMENT_POSITION),
		vef.CreateElement(VertexElementType::eELEMENT_COLOR),
		vef.CreateElement(VertexElementType::eELEMENT_END),
	};
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	mPVertexDeclaration->CreateDeclaration(elements);

	// CfbNX쐬
	int kVertexCount = vertices.size();
	SP<int> pIndices(NEW int[kVertexCount], true);
	for (int i = 0; i < kVertexCount; ++i)
	{
		pIndices[i] = i;
	}
	mPIndexBuffer.SetPointer(NEW IndexBufferDX9());
	mPIndexBuffer->SetIndices(pIndices.GetSource(), kVertexCount);	


	// v~eBu2_ňȂ̂ŁA_2
	mPrimitiveCount = vertices.size() / 2;
}


/// `
void MeshGridDX9::Render()
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	// o[ebNX̃Xg[ݒ
	SP<VertexBufferDX9> pPositionBuffer = mPVertexBuffers[eVB_POSITION];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, mPVertexBuffers[eVB_POSITION]->GetBuffer(), 0, mPVertexBuffers[eVB_POSITION]->GetStride());

	SP<VertexBufferDX9> pColorBuffer = mPVertexBuffers[eVB_COLOR];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_COLOR, mPVertexBuffers[eVB_COLOR]->GetBuffer(), 0, mPVertexBuffers[eVB_COLOR]->GetStride());

	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());

	// CfbNXobt@ݒ
	pDevice->SetIndices(mPIndexBuffer->GetBuffer());

	// _擾
	const int kVertexCount = mPVertexBuffers[eVB_POSITION]->GetVertexCount();

	// `
	HRESULT hr = pDevice->DrawIndexedPrimitive(
		D3DPT_LINELIST,
		0,
		0,
		kVertexCount,
		0,
		mPrimitiveCount
		);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("`Ɏs܂B"));
}