#include "Blast/Graphic/DirectX9/MeshFbxStaticDX9.h"

#include "Blast/IO/File.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Graphic/MaterialFbx.h"
#include "Blast/Storage/Directory.h"

using namespace std;
using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::String;
using namespace Blast::IO;
using namespace Blast::Math;
using namespace Blast::Storage;
using namespace fbxsdk_2012_2;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
#if _DEBUG
	#define DUMP_MESH_FBX 0

	/// _v|S̍ő吔
	#define MAX_POLYGON_DUMP_COUNT 300
#endif // _DEBUG

	/// EWnDirectX̍Wnւ̕ϊɂ\ʂtɂȂہAONOFFőΉł܂B
	/// |SƂ̃CfbNXtɂB
	#define INVERT_INDEX

	/// fO\tgɂV̌t̏ꍇɁAONOFFőΉł܂B
	/// UVV𔽓]
	#define FLIP_UV_Y

	/// Op`|S̒_
	#define TRIANGLE_VERTEX_COUNT 3


	// ʒu񖈂float^̐4
	const int VERTEX_STRIDE = 4;

	// @񖈂float^̐3
	const int NORMAL_STRIDE = 3;

	// UV񖈂float^̐2
	const int UV_STRIDE = 2;

	// {[CfbNX̏񖈂int^̐4
	const int BONE_INDEX_STRIDE = 4;

	// {[EFCg̏񖈂float^̐4
	const int BONE_WEIGHT_STRIDE = 4;

} // namespace


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshFbxStaticDX9::MeshFbxStaticDX9() :
mPFbxNode(NULL),
mPFbxMesh(NULL),
mIsHasNormal(false),
mIsHasUV(false),
mIsHasSkin(false),
mIsAllByControlPoint(false)
{
}

/// fXgN^
MeshFbxStaticDX9::~MeshFbxStaticDX9()
{
}


/// 
void MeshFbxStaticDX9::Initialize(KFbxNode* pFbxNode, KFbxMesh* pFbxMesh)
{
	mPFbxNode = pFbxNode;
	mPFbxMesh = pFbxMesh;

	// m[hȂreturn
    if (!pFbxMesh->GetNode())
	{
        return;
	}


	// e}eApolygonJEg
    const int kPolygonCount = pFbxMesh->GetPolygonCount();
	PFL(_T("|S=%d"), kPolygonCount);

    KFbxLayerElementArrayTemplate<int>* pMaterialIndices = NULL;
    KFbxGeometryElement::EMappingMode eMaterialMappingMode = KFbxGeometryElement::eNONE;
    if (pFbxMesh->GetElementMaterial())
    {
        pMaterialIndices = &pFbxMesh->GetElementMaterial()->GetIndexArray();
        eMaterialMappingMode = pFbxMesh->GetElementMaterial()->GetMappingMode();
        if (pMaterialIndices && eMaterialMappingMode == KFbxGeometryElement::eBY_POLYGON)
        {
            K_ASSERT(pMaterialIndices->GetCount() == kPolygonCount);
            if (pMaterialIndices->GetCount() == kPolygonCount)
            {
				// e}eAfaceJEg
                for (int polygonIndex = 0; polygonIndex < kPolygonCount; ++polygonIndex)
                {
                    const int kMaterialIndex = pMaterialIndices->GetAt(polygonIndex);
                    if (mSubMeshes.GetCount() < kMaterialIndex + 1)
                    {
                        mSubMeshes.Resize(kMaterialIndex + 1);
                    }
                    if (mSubMeshes[kMaterialIndex] == NULL)
                    {
                        mSubMeshes[kMaterialIndex] = new SSubMesh();
                    }
					mSubMeshes[kMaterialIndex]->mTriangleCount += 1;
                }

				// ItZbgL^(_̐)
                const int kMaterialCount = mSubMeshes.GetCount();
                int offset = 0;
                for (int index = 0; index < kMaterialCount; ++index)
                {
					mSubMeshes[index]->mIndexOffset = offset;
                    offset += mSubMeshes[index]->mTriangleCount * 3;

                    // This will be used as counter in the following procedures, reset to zero
                    mSubMeshes[index]->mTriangleCount = 0;
                }
                K_ASSERT(offset == kPolygonCount * 3);
            }
        }
    }

    // All faces will use the same material.
	// SẴ|S}eAŎgpĂ
    if (mSubMeshes.GetCount() == 0)
    {
        mSubMeshes.Resize(1);
        mSubMeshes[0] = new SSubMesh();
    }

    // Congregate all the data of a mesh to be cached in VBOs.
    // If normal or UV is by polygon vertex, record all vertex attributes by polygon vertex.
	// meshɏW܂ĂSăLbVB
    mIsHasNormal = (0 < pFbxMesh->GetElementNormalCount());
    mIsHasUV = (0 < pFbxMesh->GetElementUVCount());
	mIsHasSkin = (0 < pFbxMesh->GetDeformerCount());
    KFbxGeometryElement::EMappingMode eNormalMappingMode = KFbxGeometryElement::eNONE;
    KFbxGeometryElement::EMappingMode eUVMappingMode = KFbxGeometryElement::eNONE;
    if (mIsHasNormal)
    {
		// MEMO:̃CfbNX0̓Tv̂̂܂܂̒lłB
        eNormalMappingMode = pFbxMesh->GetElementNormal(0)->GetMappingMode();
        if (eNormalMappingMode == KFbxGeometryElement::eNONE)
        {
            mIsHasNormal = false;
        }
        if (mIsHasNormal && eNormalMappingMode != KFbxGeometryElement::eBY_CONTROL_POINT)
        {
            mIsAllByControlPoint = false;
        }
    }
    if (mIsHasUV)
    {
		// MEMO:̃CfbNX0̓Tv̂̂܂܂̒lłB
        eUVMappingMode = pFbxMesh->GetElementUV(0)->GetMappingMode();
        if (eUVMappingMode == KFbxGeometryElement::eNONE)
        {
            mIsHasUV = false;
        }
        if (mIsHasUV && eUVMappingMode != KFbxGeometryElement::eBY_CONTROL_POINT)
        {
            mIsAllByControlPoint = false;
        }
    }


    // Allocate the array memory, by control point or by polygon vertex.
	// z̃m(_A|S̒_)
    int polygonVertexCount = pFbxMesh->GetControlPointsCount();
    if (!mIsAllByControlPoint)
    {
        polygonVertexCount = kPolygonCount * TRIANGLE_VERTEX_COUNT;
    }
	PFL(_T("_=%d"), polygonVertexCount);

	// _
	SP<float> pVertices(NEW float[polygonVertexCount * VERTEX_STRIDE], true);

	// @
	SP<float> pNormals;
    if (mIsHasNormal)
    {
        pNormals.SetPointer(NEW float[polygonVertexCount * NORMAL_STRIDE], true);
		PFL(_T("@=%d(_Ɠ)"), polygonVertexCount);
    }

	// UV
    SP<float> pUVs;
    KStringList uvNameStrs;
    pFbxMesh->GetUVSetNames(uvNameStrs);
    const CHAR* uvName = NULL;
    if (mIsHasUV && uvNameStrs.GetCount())
    {
		pUVs.SetPointer(NEW float[polygonVertexCount * UV_STRIDE], true);
		PFL(_T("UV=%d(_Ɠ)"), polygonVertexCount);
        uvName = uvNameStrs[0];
    }

	// {[CfbNXƃ{[EFCg
	SP<BYTE> pBIndices;
	SP<float> pBWeights;
	if (mIsHasSkin)
	{
		// {[CfbNXz̍쐬
		pBIndices.SetPointer(NEW BYTE[polygonVertexCount * BONE_INDEX_STRIDE], true);
#if _DEBUG
		for (int i = 0; i < polygonVertexCount * BONE_INDEX_STRIDE; ++i)
		{
			pBIndices[i] = -1;
		}
#else
		ZeroMemory(pBIndices.GetSource(), sizeof(BYTE) * polygonVertexCount * BONE_INDEX_STRIDE);
#endif
		PFL(_T("{[CfbNX=%d(_Ɠ)"), polygonVertexCount);

		// {[EFCgz̍쐬
		pBWeights.SetPointer(NEW float[polygonVertexCount * BONE_WEIGHT_STRIDE], true);
		ZeroMemory(pBWeights.GetSource(), sizeof(float) * polygonVertexCount * BONE_WEIGHT_STRIDE);
		PFL(_T("{[EFCg=%d(_Ɠ)"), polygonVertexCount);
	}

	// CfbNX
    SP<int> pIndices(NEW int[kPolygonCount * TRIANGLE_VERTEX_COUNT], true);


    // Populate the array with vertex attribute, if by control point.
	// _ȂA_̏zɈړ
    const KFbxVector4* pControlPoints = pFbxMesh->GetControlPoints();
    KFbxVector4 currentVertex;
    KFbxVector4 currentNormal;
    KFbxVector2 currentUV;

    if (mIsAllByControlPoint)
    {
        const KFbxGeometryElementNormal* pNormalElement = NULL;
        const KFbxGeometryElementUV* pUVElement = NULL;
		const KFbxSkin* pSkinDeformer = NULL;
        if (mIsHasNormal)
        {
            pNormalElement = pFbxMesh->GetElementNormal(0);
        }
        if (mIsHasUV)
        {
            pUVElement = pFbxMesh->GetElementUV(0);
        }
		if (mIsHasSkin)
		{
			pSkinDeformer = KFbxCast<KFbxSkin>(pFbxMesh->GetDeformer(0));	// 擪̂݃T|[g
		}

        for (int index = 0; index < polygonVertexCount; ++index)
        {
            // Save the vertex position.
			// _̈ʒuێ
            currentVertex = pControlPoints[index];
            pVertices[index * VERTEX_STRIDE] = static_cast<float>(currentVertex[0]);
            pVertices[index * VERTEX_STRIDE + 1] = static_cast<float>(currentVertex[1]);
            pVertices[index * VERTEX_STRIDE + 2] = static_cast<float>(currentVertex[2]);
            pVertices[index * VERTEX_STRIDE + 3] = 1;

            // Save the normal.
			// @ێ
            if (mIsHasNormal)
            {
                int normalIndex = index;
                if (pNormalElement->GetReferenceMode() == KFbxLayerElement::eINDEX_TO_DIRECT)
                {
                    normalIndex = pNormalElement->GetIndexArray().GetAt(index);
                }
                currentNormal = pNormalElement->GetDirectArray().GetAt(normalIndex);
                pNormals[index * NORMAL_STRIDE] = static_cast<float>(currentNormal[0]);
                pNormals[index * NORMAL_STRIDE + 1] = static_cast<float>(currentNormal[1]);
                pNormals[index * NORMAL_STRIDE + 2] = static_cast<float>(currentNormal[2]);
            }

            // Save the UV.
			// UVێ
            if (mIsHasUV)
            {
                int uvIndex = index;
                if (pUVElement->GetReferenceMode() == KFbxLayerElement::eINDEX_TO_DIRECT)
                {
                    uvIndex = pUVElement->GetIndexArray().GetAt(index);
                }
                currentUV = pUVElement->GetDirectArray().GetAt(uvIndex);
                pUVs[index * UV_STRIDE] = static_cast<float>(currentUV[0]);
                pUVs[index * UV_STRIDE + 1] = static_cast<float>(currentUV[1]);
            }

			// TODO:{[̃CfbNXƃEFCg̏ێ
			if (mIsHasSkin)
			{
				HALT(_T("{[̃CfbNXƃEFCg̏ێ鏈łB"));
			}
        } // polygonVertexCount
    } // mIsAllByControlPoint


    int vertexCount = 0;
    for (int polygonIndex = 0; polygonIndex < kPolygonCount; ++polygonIndex)
    {
        // The material for current face.
		// ݂̃|S̃}eATo
        int kMaterialIndex = 0;
        if (pMaterialIndices && eMaterialMappingMode == KFbxGeometryElement::eBY_POLYGON)
        {
            kMaterialIndex = pMaterialIndices->GetAt(polygonIndex);
        }

        // Where should I save the vertex attribute index, according to the material
		// }eAɑΉ_̑ۑ
        const int kIndexOffset =
			mSubMeshes[kMaterialIndex]->mIndexOffset +
            mSubMeshes[kMaterialIndex]->mTriangleCount * 3;
        for (int verticesIndex = 0; verticesIndex < TRIANGLE_VERTEX_COUNT; ++verticesIndex)
        {
            const int kControlPointIndex = pFbxMesh->GetPolygonVertex(polygonIndex, verticesIndex);
#ifdef INVERT_INDEX	/// |SƂ̃CfbNXtɂ
			const int kIndexOffsetCull = kIndexOffset + (TRIANGLE_VERTEX_COUNT - 1) - verticesIndex;
#else
			const int kIndexOffsetCull = kIndexOffset + verticesIndex;
#endif // INVERT_INDEX

            if (mIsAllByControlPoint)
            {
                pIndices[kIndexOffsetCull] = static_cast<unsigned>(kControlPointIndex);
            }
            // Populate the array with vertex attribute, if by polygon vertex.
            else
            {
                pIndices[kIndexOffsetCull] = static_cast<unsigned>(vertexCount);

				// ʒu擾
                currentVertex = pControlPoints[kControlPointIndex];
                pVertices[vertexCount * VERTEX_STRIDE] = static_cast<float>(currentVertex[0]);
                pVertices[vertexCount * VERTEX_STRIDE + 1] = static_cast<float>(currentVertex[1]);
                pVertices[vertexCount * VERTEX_STRIDE + 2] = static_cast<float>(currentVertex[2]);
                pVertices[vertexCount * VERTEX_STRIDE + 3] = 1;

				// @擾
                if (mIsHasNormal)
                {
                    pFbxMesh->GetPolygonVertexNormal(polygonIndex, verticesIndex, currentNormal);
                    pNormals[vertexCount * NORMAL_STRIDE] = static_cast<float>(currentNormal[0]);
                    pNormals[vertexCount * NORMAL_STRIDE + 1] = static_cast<float>(currentNormal[1]);
                    pNormals[vertexCount * NORMAL_STRIDE + 2] = static_cast<float>(currentNormal[2]);
                }

				// UV擾
                if (mIsHasUV)
                {
                    pFbxMesh->GetPolygonVertexUV(polygonIndex, verticesIndex, uvName, currentUV);
                    pUVs[vertexCount * UV_STRIDE] = static_cast<float>(currentUV[0]);
#ifdef FLIP_UV_Y	// UVV𔽓]
                    pUVs[vertexCount * UV_STRIDE + 1] = static_cast<float>(1.0f - currentUV[1]);
#endif // FLIP_UV_Y
                }
				
				// {[֘Ȁێ
				if (mIsHasSkin)
				{
					const KFbxSkin* pSkinDeformer = NULL;
					pSkinDeformer = KFbxCast<KFbxSkin>(pFbxMesh->GetDeformer(0));	// 擪̂݃T|[g

					// RIGID݂̂T|[g
					ASSERT_PF(pSkinDeformer->GetSkinningType() == KFbxSkin::eRIGID, _T("RIGID݂̂T|[gĂ܂B"));
					if (pSkinDeformer->GetSkinningType() == KFbxSkin::eRIGID)
					{
						int applyCount = 0;

						// {[̃CfbNXƃEFCg̏ێ
						const int kClusterCount = pSkinDeformer->GetClusterCount();
						for (int clusterIndex = 0; clusterIndex < kClusterCount; ++clusterIndex)
						{
							const KFbxCluster* pCluster = pSkinDeformer->GetCluster(clusterIndex);
							// if (!pCluster->GetLink()) { continue; } KvǂȂ̂łƂ肠CO
							int kVertexIndexCount = pCluster->GetControlPointIndicesCount();
							for (int j = 0; j < kVertexIndexCount; ++j)
							{
								const int kCPIndex = pCluster->GetControlPointIndices()[j];
								if (kControlPointIndex == kCPIndex)
								{
									ASSERT_PF(0 <= clusterIndex && clusterIndex <= MAX_BONE_MATRICES, _T("{[CfbNXBYTE^ŕ\͈͂I[o[Ă܂B\nclusterIndex=%d, j=%d"), clusterIndex, j);
									pBIndices[vertexCount * BONE_INDEX_STRIDE + applyCount] = static_cast<BYTE>(clusterIndex);

									// if (kIndex >= kVertexCount) { continue; } KvǂȂ̂łƂ肠CO

									const double kWeight = pCluster->GetControlPointWeights()[j];
									pBWeights[vertexCount * BONE_WEIGHT_STRIDE + applyCount] = static_cast<float>(kWeight);

									++applyCount;

									break;
								}
							} // kVertexIndexCount

							// ݒ\ȃ{[𒴉߂Aȍ~̃{[͏Ȃ
							if (BONE_INDEX_STRIDE <= applyCount)
							{
								WARNING(NULL, _T("1̒_ɐݒ\ȃ{[񂪃I[o[Ă܂B\nkvertexCount=%d\nControlPointIndex=%d\nclusterIndex[%d]=%s\napplyCount=%d  ȍ~̏̓XLbv܂B"),
									vertexCount,
									kControlPointIndex,
									clusterIndex, StringHelper::ToWideChar(pCluster->GetInitialName()).c_str(),
									applyCount + 1);

								break;
							}
						} // kClusterCount
					}
				} // Bone
            }
            ++vertexCount;
        }
        mSubMeshes[kMaterialIndex]->mTriangleCount += 1;
    }


	/// obt@쐬
	mPVertexBuffers[eVERTEXBUFFER_POSITION].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(pVertices.GetSource(), polygonVertexCount, polygonVertexCount * VERTEX_STRIDE * sizeof(float));
#if 0	//< _vp
	// |S萔ȉȂ_v܂
	if (kPolygonCount <= 100)
	{
		for (int i = 0; i < polygonVertexCount; ++i)
		{
			PFL(_T("_[%d]=%f, %f, %f"),
				i,
				pVertices[i * VERTEX_STRIDE + 0],
				pVertices[i * VERTEX_STRIDE + 1],
				pVertices[i * VERTEX_STRIDE + 2]
				);
		}
	}
#endif // _vp

	// @̃obt@쐬
    if (mIsHasNormal)
    {
		mPVertexBuffers[eVERTEXBUFFER_NORMAL].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_NORMAL]->SetVertices(pNormals.GetSource(), polygonVertexCount, polygonVertexCount * NORMAL_STRIDE * sizeof(float));
#if 0	//< _vp
		// |S萔ȉȂ_v܂
		if (kPolygonCount <= 100)
		{
			for (int i = 0; i < polygonVertexCount; ++i)
			{
				PFL(_T("@[%d]=%f, %f, %f"),
					i,
					pNormals[i * NORMAL_STRIDE + 0],
					pNormals[i * NORMAL_STRIDE + 1],
					pNormals[i * NORMAL_STRIDE + 2]
					);
			}
		}
#endif // _vp
    }
    
	// UṼobt@쐬
    if (mIsHasUV)
    {
		mPVertexBuffers[eVERTEXBUFFER_UV].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(pUVs.GetSource(), polygonVertexCount, polygonVertexCount * UV_STRIDE * sizeof(float));
#if 0	//< _vp
		// |S萔ȉȂ_v܂
		if (kPolygonCount <= 100)
		{
			for (int i = 0; i < polygonVertexCount; ++i)
			{
				PFL(_T("UV[%d]=%f, %f"),
					i,
					pUVs[i * UV_STRIDE + 0],
					pUVs[i * UV_STRIDE + 1]
					);
			}
		}
#endif // _vp
    }
    
	// {[̃CfbNXƃEFCg̃obt@쐬
	if (mIsHasSkin)
	{
		mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->SetVertices(pBIndices.GetSource(), polygonVertexCount, polygonVertexCount * BONE_INDEX_STRIDE * sizeof(BYTE));
#if 0	//< _vp
		// ő̃|S_v܂
		{
			int dumpCount = (kPolygonCount <= MAX_POLYGON_DUMP_COUNT ? kPolygonCount : MAX_POLYGON_DUMP_COUNT);
			for (int i = 0; i < dumpCount; ++i)
			{
				// 4Ɉ_v܂B
				if (i % 4) { continue; }

				PFL(_T("pBIndices[%d]=%d, %d, %d, %d"),
					i,
					pBIndices[i * BONE_INDEX_STRIDE],
					pBIndices[i * BONE_INDEX_STRIDE + 1],
					pBIndices[i * BONE_INDEX_STRIDE + 2],
					pBIndices[i * BONE_INDEX_STRIDE + 3]
					);
			}
		}
#endif // _vp

		mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->SetVertices(pBWeights.GetSource(), polygonVertexCount, polygonVertexCount * BONE_WEIGHT_STRIDE * sizeof(float));
#if 0	//< _vp
		// ő̃|S_v܂
		{
			int dumpCount = (kPolygonCount <= MAX_POLYGON_DUMP_COUNT ? kPolygonCount : MAX_POLYGON_DUMP_COUNT);
			for (int i = 0; i < dumpCount; ++i)
			{
				// 4Ɉ_v܂B
				if (i % 4) { continue; }

				PFL(_T("pBWeights[%d]=%f, %f, %f, %f"),
					i,
					pBWeights[i * BONE_WEIGHT_STRIDE],
					pBWeights[i * BONE_WEIGHT_STRIDE + 1],
					pBWeights[i * BONE_WEIGHT_STRIDE + 2],
					pBWeights[i * BONE_WEIGHT_STRIDE + 3]
					);
			}
		}
#endif // _vp
	}

	// CfbNX̃obt@쐬
	mPIndexBuffer.SetPointer(NEW IndexBufferDX9());
	mPIndexBuffer->SetIndices(pIndices.GetSource(), kPolygonCount * TRIANGLE_VERTEX_COUNT);
#if 0	//< _vp
	// |S萔ȉȂ_v܂
	if (kPolygonCount <= 100)
	{
		for (int i = 0; i < kPolygonCount; ++i)
		{
			PFL(_T("CfbNX=%d, %d, %d"),
				pIndices[i * TRIANGLE_VERTEX_COUNT + 0],
				pIndices[i * TRIANGLE_VERTEX_COUNT + 1],
				pIndices[i * TRIANGLE_VERTEX_COUNT + 2]
				);
		}
	}
#endif // _vp


	// _`쐬BXL̗LŒ`ςB
	VertexElementFactoryDX9 veFactory;
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	if (mIsHasSkin)
	{
		const D3DVERTEXELEMENT9 elements[] =
		{
			veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
			veFactory.CreateElement(VertexElementType::eELEMENT_UV),
			veFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
			veFactory.CreateElement(VertexElementType::eELEMENT_BONE_INDEX),
			veFactory.CreateElement(VertexElementType::eELEMENT_BONE_WEIGHT),
			veFactory.CreateElement(VertexElementType::eELEMENT_END),
		};
		mPVertexDeclaration->CreateDeclaration(elements);
	}
	else
	{
		const D3DVERTEXELEMENT9 elements[] =
		{
			veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
			veFactory.CreateElement(VertexElementType::eELEMENT_UV),
			veFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
			veFactory.CreateElement(VertexElementType::eELEMENT_END),
		};
		mPVertexDeclaration->CreateDeclaration(elements);
	}


    return;
}

void MeshFbxStaticDX9::BeginRender()
{
	// bVȂ
	ASSERT_PF(mPFbxMesh, _T("bV܂B"));
	if (!mPFbxMesh)
	{
		return;
	}


	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();
	
	// ʒuXg[ݒ
	HRESULT hr = pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetStride());
	ASSERT_PF(SUCCEEDED(hr), _T("ʒũXg[̐ݒɎs܂B"));

	// UVXg[ݒ
	if (mIsHasUV)
	{
		hr = pDevice->SetStreamSource(VertexStreamType::eSTREAM_UV, mPVertexBuffers[eVERTEXBUFFER_UV]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_UV]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("UṼXg[̐ݒɎs܂B"));
	}

	// @Xg[ݒ
	if (mIsHasNormal)
	{
		hr = pDevice->SetStreamSource(VertexStreamType::eSTREAM_NORMAL, mPVertexBuffers[eVERTEXBUFFER_NORMAL]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_NORMAL]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("@̃Xg[̐ݒɎs܂B"));
	}

	// {[̃Xg[ݒ
	if (mIsHasSkin)
	{
		hr = pDevice->SetStreamSource(VertexStreamType::eSTREAM_BONE_INDEX, mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("{[CfbNX̃Xg[̐ݒɎs܂B"));

		hr = pDevice->SetStreamSource(VertexStreamType::eSTREAM_BONE_WEIGHT, mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("{[EFCg̃Xg[̐ݒɎs܂B"));
	}

	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());

	// CfbNXobt@ݒ
	pDevice->SetIndices(mPIndexBuffer->GetBuffer());
}

/// `
void MeshFbxStaticDX9::Render(int materialIndex)
{
	// bVȂ
	ASSERT_PF(mPFbxMesh, _T("bV܂B"));
	if (!mPFbxMesh)
	{
		return;
	}


	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();

	// _擾
	const int kVertexCount = mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetVertexCount();

	// JnCfbNXZo
	const unsigned kStartIndex = mSubMeshes[materialIndex]->mIndexOffset;
	const unsigned kPrimitiveCount = mSubMeshes[materialIndex]->mTriangleCount;
	
	// `
	HRESULT hr = pDevice->DrawIndexedPrimitive(
		D3DPT_TRIANGLELIST,
		0,
		0,
		kVertexCount,
		kStartIndex,
		kPrimitiveCount
		);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("`Ɏs܂B"));
}


/// _̈ʒuXV
void MeshFbxStaticDX9::UpdateVertexPosition(const KFbxMesh* kPMesh, const KFbxVector4* kPVertices)
{
    float* pVertices = NULL;
    int vertexCount = 0;
    if (mIsAllByControlPoint)
    {
        vertexCount = kPMesh->GetControlPointsCount();
        pVertices = NEW float[vertexCount * VERTEX_STRIDE];
        for (int index = 0; index < vertexCount; ++index)
        {
            pVertices[index * VERTEX_STRIDE] = static_cast<float>(kPVertices[index][0]);
            pVertices[index * VERTEX_STRIDE + 1] = static_cast<float>(kPVertices[index][1]);
            pVertices[index * VERTEX_STRIDE + 2] = static_cast<float>(kPVertices[index][2]);
            pVertices[index * VERTEX_STRIDE + 3] = 1;
        }
    }
    else
    {
        const int kPolygonCount = kPMesh->GetPolygonCount();
        vertexCount = kPolygonCount * TRIANGLE_VERTEX_COUNT;
        pVertices = NEW float[vertexCount * VERTEX_STRIDE];

        int vertexCount = 0;
        for (int polygonCount = 0; polygonCount < kPolygonCount; ++polygonCount)
        {
            for (int lVerticeIndex = 0; lVerticeIndex < TRIANGLE_VERTEX_COUNT; ++lVerticeIndex)
            {
                const int kControlPointIndex = kPMesh->GetPolygonVertex(polygonCount, lVerticeIndex);
                pVertices[vertexCount * VERTEX_STRIDE] = static_cast<float>(kPVertices[kControlPointIndex][0]);
                pVertices[vertexCount * VERTEX_STRIDE + 1] = static_cast<float>(kPVertices[kControlPointIndex][1]);
                pVertices[vertexCount * VERTEX_STRIDE + 2] = static_cast<float>(kPVertices[kControlPointIndex][2]);
                pVertices[vertexCount * VERTEX_STRIDE + 3] = 1;
                ++vertexCount;
            }
        }
    }

    // Transfer into GPU.
    if (pVertices)
    {
		// HACK:obt@č쐬BׁB
		mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(pVertices, vertexCount, sizeof(float) * vertexCount * VERTEX_STRIDE);

        delete [] pVertices;
    }
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ċAǂݍ
void MeshFbxStaticDX9::LoadRecursive(const TCHAR* kPFullPath, KFbxNode* pNode)
{
	// MEMO:bV󂯎ĉ͂փVtgĂ̂Ŗ
#if UNUSED
	// Agr[g̐Ń[v
	const int kAttributeCount = pNode->GetNodeAttributeCount();
	for (int i = 0; i < kAttributeCount; ++i)
	{
		// Agr[g擾
		KFbxNodeAttribute* pAttribute = pNode->GetNodeAttributeByIndex(i);
		KFbxNodeAttribute::EAttributeType eType = pAttribute->GetAttributeType();

		// bVȂ
		if (eType == KFbxNodeAttribute::eMESH)
		{
			// LXg
			KFbxMesh* pMesh = static_cast<KFbxMesh*>(pAttribute);

			// bVǂݍ
			LoadMesh(kPFullPath, pMesh);

			break;
		}
	}


	// qm[h̐擾
	const int kChildCount = pNode->GetChildCount();

	// q̐ŃU[u
	mChildrenPtrs.clear();
	mChildrenPtrs.reserve(kChildCount);


	// qm[h̐Ń[v
	for (int i = 0; i < kChildCount; ++i)
	{
		// q쐬
		SP<MeshFbxStaticDX9> pChildMesh(NEW MeshFbxStaticDX9());


		// MEMO:͏璷ł傤B
		// MEMO:SdkManager͉ƍ̂œnĂ܂񂪂ǂł傤BX}[g|C^ɂǂł傤B
		// qɏn
		//pChildMesh->mPAnimation = this->mPAnimation;
		//pChildMesh->mPFbxSdkManager = this->mPFbxSdkManager;
		pChildMesh->mPFbxScene = this->mPFbxScene;


		// qm[h擾
		KFbxNode* pChild = pNode->GetChild(i);

		// qm[hōċA
		pChildMesh->LoadRecursive(kPFullPath, pChild);


		// ǉ
		mChildrenPtrs.push_back(pChildMesh);
	}
#endif // UNUSED
}

/// bVǂݍ
void MeshFbxStaticDX9::LoadMesh(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxMesh* pMesh)
{
	/// FbxbVێ
	mPFbxMesh = pMesh;


	// bVm[h擾
	KFbxNode* pMeshNode = pMesh->GetNode();

	// ASSERT:bV擾łȂȂ玀B
	ASSERT_PRINTF(pMesh, _T("bV擾ł܂łB"));

			
	// _擾
	const int kPositionCount = pMesh->GetControlPointsCount();
	PFL(_T("_W=%d"), kPositionCount);


	// UV擾
	const KFbxGeometryElementUV* kPElementUV = pMesh->GetElementUV();
	if (kPElementUV)
	{
		const int kUVCount = kPElementUV->GetDirectArray().GetCount();
		PFL(_T("UV=%d"), kUVCount);

		// UVCfbNX擾
		const int kUVIndexCount = kPElementUV->GetIndexArray().GetCount();
		PFL(_T("UVCfbNX̐=%d"), kUVIndexCount);
	}


	// @擾
	const KFbxGeometryElementNormal* kPElementNormal = pMesh->GetElementNormal();
	if (kPElementNormal)
	{
		const int kNormalCount = kPElementNormal->GetDirectArray().GetCount();
		PFL(_T("@̐=%d"), kNormalCount);

		// @CfbNX擾
		const int kNormalIndexCount = kPElementNormal->GetIndexArray().GetCount();
		PFL(_T("@CfbNX̐=%d"), kNormalIndexCount);
	}


	// |S擾
	const int kPolygonCount = pMesh->GetPolygonCount();
	PFL(_T("|S=%d"), kPolygonCount);

	// CfbNX擾
	const int kIndexCount = kPolygonCount * 3;
	PFL(_T("_WCfbNX=%d"), kIndexCount);

	// }eA̐擾
	const int kMaterialCount = pMeshNode->GetMaterialCount();
	PFL(_T("}eA̐=%d"), kMaterialCount);


	// _ʒuz擾
	const KFbxVector4* kPRefPositions = pMesh->GetControlPoints();

	// CfbNXz擾
	const int* kPRefIndices = pMesh->GetPolygonVertices();


	// }eAǂݍ
	LoadMaterial(kPFullPath, pMesh->GetNode());


	// MEMO:C[0ŌŒ肵Ă܂B
	// }eA擾
	const KFbxLayerElementMaterial* kPElementMaterial = pMesh->GetLayer(0)->GetMaterials();

	// }eACfbNXz擾
	const KFbxLayerElementArrayTemplate<int>& kRMaterialIndices = kPElementMaterial->GetIndexArray();

	// }eACfbNX̐擾
	const int kMaterialIndexCount = kRMaterialIndices.GetCount();
	PFL(_T("}eACfbNX=%d"), kMaterialIndexCount);


	// _ʒuz𓮓Im
	SP<VertexBufferDX9::SPosition> pSPositions(NEW VertexBufferDX9::SPosition[kIndexCount], true);
	ZeroMemory(pSPositions.GetSource(), sizeof(VertexBufferDX9::SPosition) * kIndexCount);

	// UVz𓮓Im
	SP<VertexBufferDX9::SUV> pSUVs(NEW VertexBufferDX9::SUV[kIndexCount], true);
	ZeroMemory(pSUVs.GetSource(), sizeof(VertexBufferDX9::SUV) * kIndexCount);

	// @z𓮓Im
	SP<VertexBufferDX9::SNormal> pSNormals(NEW VertexBufferDX9::SNormal[kIndexCount], true);
	ZeroMemory(pSNormals.GetSource(), sizeof(VertexBufferDX9::SNormal) * kIndexCount);


	// CfbNXz𓮓Im
	SP<int> pIndices(NEW int[kIndexCount], true);
	ZeroMemory(pIndices.GetSource(), sizeof(pIndices.GetSource()));


	// ʒuCfbNX
	int positionAssignIndex = 0;

	// UVCfbNX
	int uvAssignIndex = 0;

	// @CfbNX
	int normalAssignIndex = 0;


	// EZ-UpnY-Upnɕϊsp
	const Matrix kCoordinateConvert = MathHelper::CreateZUpRHToYUpLH();


	// }eA̐Ń[v
	for (int i = 0; i < kMaterialCount; ++i)
	{
		// CfbNXz
		ZeroMemory(pIndices.GetSource(), sizeof(int) * kIndexCount);

		// CfbNX
		int assignIndex = 0;


		// tFCX̐Ń[v
		for (int j = 0; j < kPolygonCount; ++j)
		{
			// MEMO:tFCX̐ƕKvz񐔂Ȃ̂ł傤B
			// }eACfbNX擾
			const int kMaterialIndex = kRMaterialIndices[j];

			// CfbNXvȂ
			if (i == kMaterialIndex)
			{
				// MEMO:̏ł͎Op`|SłKv܂B
				// |Sꖇɑ΂钸_Ń[v
				for (int k = 0; k < 3; ++k)
				{
					// CfbNX擾
					const int kIndex = kPRefIndices[j * 3 + k];


					// ʒu擾
					Vector3 pos(
						static_cast<float>(kPRefPositions[kIndex][0]),
						static_cast<float>(kPRefPositions[kIndex][1]),
						static_cast<float>(kPRefPositions[kIndex][2])
						);

					// nϊ
					pos.Multiply(kCoordinateConvert);


					// ʒu
					pSPositions[positionAssignIndex].m[0] = pos[0];
					pSPositions[positionAssignIndex].m[1] = pos[1];
					pSPositions[positionAssignIndex].m[2] = pos[2];


					
					// ʒuCfbNXZ
					++positionAssignIndex;
					

					// UVȂ
					if (kPElementUV)
					{
						const KFbxLayerElementArrayTemplate<KFbxVector2>& kRRefUVs = kPElementUV->GetDirectArray();
						const KFbxLayerElementArrayTemplate<int>& kRRefUVIndices = kPElementUV->GetIndexArray();

						// UVCfbNX擾
						const int kUVIndex = kRRefUVIndices[j * 3 + k];

						// MEMO:VW͋tɂ܂B
						// UV
						pSUVs[uvAssignIndex].mU = static_cast<float>(kRRefUVs[kUVIndex][0]);
						pSUVs[uvAssignIndex].mV = static_cast<float>(kRRefUVs[kUVIndex][1]);
						pSUVs[uvAssignIndex].mV = 1 - pSUVs[uvAssignIndex].mV;
						
						++uvAssignIndex;
					}


					//// @Ȃ
					//if (kPElementNormal)
					//{
					//	const KFbxLayerElementArrayTemplate<KFbxVector4>& kRRefNormals = kPElementNormal->GetDirectArray();
					//	const KFbxLayerElementArrayTemplate<int>& kRRefNormalIndices = kPElementNormal->GetIndexArray();

					//	// MEMO:fɂĂ͐mȃCfbNXKvł傤B
					//	// @CfbNX擾
					//	//int normalIndex = kRRefNormalIndices[i];
					//	const int KNormalIndex = j * 3 + k;

					//	// @擾
					//	Vector3 normal(
					//		static_cast<float>(kRRefNormals[KNormalIndex][0]),
					//		static_cast<float>(kRRefNormals[KNormalIndex][1]),
					//		static_cast<float>(kRRefNormals[KNormalIndex][2])
					//		);

					//	// nϊ
					//	normal.Multiply(kCoordinateConvert);

					//	// @
					//	pSNormals[normalAssignIndex].mX = normal.mX;
					//	pSNormals[normalAssignIndex].mY = normal.mY;
					//	pSNormals[normalAssignIndex].mZ = normal.mZ;


					//	++normalAssignIndex;
					//}


					// MEMO:JOɑΉ邽߁Atɂ܂B
					const int kInvK = (2 - k);

					// CfbNX
					pIndices[assignIndex] = j * 3 + kInvK;

					// CfbNXZ
					++assignIndex;
				}
			}
		}

#if _DEBUG && DUMP_MESH_FBX
		// CfbNXz\
		for (int i = 0; i < kIndexCount; i += 3)
		{
			const int index0 = kPRefIndices[i+0];
			const int index1 = kPRefIndices[i+1];
			const int index2 = kPRefIndices[i+2];
			PFL(_T("ϊCfbNX(%3d, %3d, %3d)"), index0, index1, index2);
		}
		PFL(_T("--------------------------------------------------"));
		for (int i = 0; i < assignIndex; i += 3)
		{
			const int index0 = pIndices[i+0];
			const int index1 = pIndices[i+1];
			const int index2 = pIndices[i+2];
			PFL(_T("ϊCfbNX(%3d, %3d, %3d)"), index0, index1, index2);
		}
#endif // _DEBUG

		// MEMO:bV󂯎ĉ͂փVtgĂ̂CO
		//// CfbNXobt@쐬
		//SP<IndexBufferDX9> pIndexBuffer(NEW IndexBufferDX9());
		//pIndexBuffer->SetIndices(pIndices.GetSource(), assignIndex);

		//mIndexBufferPtrs.push_back(pIndexBuffer);
	}


	// o[ebNXobt@쐬
	for (int i = 0; i < eVERTEXBUFFER_COUNT; ++i)
	{
		mPVertexBuffers[i].SetPointer(NEW VertexBufferDX9());
	}

	mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(pSPositions.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SPosition) * kIndexCount);
	mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(pSUVs.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SUV) * kIndexCount);


	// _`쐬
	VertexElementFactoryDX9 veFactory;
	const D3DVERTEXELEMENT9 elements[] =
	{
		veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
		veFactory.CreateElement(VertexElementType::eELEMENT_UV),
		veFactory.CreateElement(VertexElementType::eELEMENT_END),
	};

	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	mPVertexDeclaration->CreateDeclaration(elements);
}

/// }eAǂݍ
void MeshFbxStaticDX9::LoadMaterial(const TCHAR* kPFullPath, KFbxNode* pMeshNode)
{
	// MEMO:bV󂯎ĉ͂փVtgȂ̂Ŗ
#if UNUSED
	// }eA̐擾
	const int kMaterialCount = pMeshNode->GetMaterialCount();

	// }eA̐ێ
	mMaterialCount = kMaterialCount;


	// }eAz𓮓I쐬
	mPSMaterials.SetPointer(NEW SMaterial[kMaterialCount], true);


	// }eA̐Ń[v
	for (int i = 0; i < kMaterialCount; ++i)
	{
		// Q
		SMaterial& rSMaterial = mPSMaterials[i];


		// }eA擾
		const KFbxSurfaceMaterial* pMaterial = pMeshNode->GetMaterial(i);

		// NXID擾
		kFbxClassId id = pMaterial->GetClassId();

		// o[g}eAȂ
		if (id == KFbxSurfaceLambert::ClassId)
		{
			// LXg
			const KFbxSurfaceLambert* pLambert = static_cast<const KFbxSurfaceLambert*>(pMaterial);

			// MEMO:fBt[YArGgȂǂ̎擾܂B
			WARNING(false, _T("o[g}eAɑ΂鏈܂B"));
		}
		// tH}eAȂ
		else if (id == KFbxSurfacePhong::ClassId)
		{
			// LXg
			const KFbxSurfacePhong* pPhong = static_cast<const KFbxSurfacePhong*>(pMaterial);


			// }eA擾
			TCHAR materialName[Directory::mStKMaxPath];
			StringHelper::ToWideChar(materialName, Directory::mStKMaxPath, pPhong->GetName());

			rSMaterial.mNameStr = materialName;


			//// fBt[Y擾
			//for (int j = 0; j < 3; ++j)
			//{
			//	rSMaterial.mDiffuse[j] = static_cast<float>(pPhong->Diffuse.Get()[j]);
			//}

			//rSMaterial.mDiffuseFactor = static_cast<float>(pPhong->DiffuseFactor.Get());


			//// ArGg擾
			//for (int j = 0; j < 3; ++j)
			//{
			//	rSMaterial.mAmbient = static_cast<float>(pPhong->Ambient.Get()[j]);
			//}

			//rSMaterial.mAmbientFactor = static_cast<float>(pPhong->AmbientFactor.Get());


			//// XyL擾
			//for (int j = 0; j < 3; ++j)
			//{
			//	rSMaterial.mSpecular = static_cast<float>(pPhong->Specular.Get()[j]);
			//}

			//rSMaterial.mSpecularFactor = static_cast<float>(pPhong->SpecularFactor.Get());


			//// VClX擾
			//rSMaterial.mShininess = static_cast<float>(pPhong->Shininess.Get());


			//// fBt[YeNX`擾
			//KFbxProperty& rDiffuseProperty = pPhong->FindProperty(KFbxSurfaceMaterial::sDiffuse);
			//KFbxObject* pDiffuseObject = rDiffuseProperty.GetSrcObject(KFbxTexture::ClassId);

			//// fBt[YeNX`񂪂Ȃ
			//if (pDiffuseObject)
			//{
			//	// eNX`ɃLXg
			//	KFbxFileTexture* pDiffuseTexture = KFbxCast<KFbxFileTexture>(pDiffuseObject);


			//	// fBNg擾
			//	TCHAR absDirectory[Directory::mStKMaxPath];
			//	Directory::GetDirectoryPath(kPFullPath, absDirectory);

			//	PFL(_T("[fBNg]\n\t%s"), absDirectory);

			//	// MEMO:FBXt@CFBXRo[^[ŕϊƁA΃pX擾łȂȂĂ܂̂ł傤B
			//	// MEMO:3dsmaxł̓vWFNgtH_ōƂȂƃYĂ܂܂B
			//	// ΃eNX`pX擾
			//	const CHAR* pRelativeFilePath = pDiffuseTexture->GetRelativeFileName();
			//	TCHAR relTexturePath[Directory::mStKMaxPath];
			//	StringHelper::ToWideChar(relTexturePath, Directory::mStKMaxPath, pRelativeFilePath);

			//	PFL(_T("[΃eNX`pX]\n\t%s"), relTexturePath);

			//	// ΃eNX`pX쐬
			//	TCHAR absTexturePath[Directory::mStKMaxPath];
			//	memcpy(absTexturePath, absDirectory, sizeof(absDirectory));
			//	_tcscat_s(absTexturePath, relTexturePath);

			//	PFL(_T("[΃eNX`pX]\n\t%s"), absTexturePath);


			//	SP<FileTexture2DDX9> pTexture(NEW FileTexture2DDX9());
			//	bool isLoadSucceeded = pTexture->Load(absTexturePath);

			//	// WARNING:eNX`̓ǂݍ݂ɎsȂx
			//	WARNING(isLoadSucceeded, _T("eNX`̓ǂݍ݂Ɏs܂B\n\t%s\n\t%s"), kPFullPath, absTexturePath);


			//	// ێ
			//	rSMaterial.mPDiffuseTexture = pTexture;
			//}
		}
	}
#endif // UNUSED
}
