#include "Blast/Graphic/DirectX9/MeshFbxDX9.h"

#include "Blast/IO/File.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Storage/Directory.h"

using namespace std;
using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::String;
using namespace Blast::IO;
using namespace Blast::Math;
using namespace Blast::Storage;
using namespace fbxsdk_2012_2;

#define DUMP_MESH_FBX 0


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MeshFbxDX9::MeshFbxDX9() :
mPFbxSdkManager(NULL),
mMaterialCount(0),
mPFbxMesh(NULL)
{
	// o[ebNXobt@̎ނŃ[v
	for (int i = 0; i < eVERTEXBUFFER_COUNT; ++i)
	{
		// o[ebNXobt@쐬
		mPVertexBuffers[i].SetPointer(NEW VertexBufferDX9());
	}

	// _`쐬
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	
	// MEMO:bVׂł͂ȂƎv̂CO
	//// eNjbNݒ
	//mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME);
}

/// fXgN^
MeshFbxDX9::~MeshFbxDX9()
{
	// MEMO:}l[W[jΗǂ悤łB
	SAFE_DESTROY(mPFbxSdkManager);
}


/// ǂݍ
bool MeshFbxDX9::Load(const TCHAR* const kPFullPath)
{
	// ^C}[쐬
	Timer loadTimer;
	loadTimer.Start(_T("MeshFbxDX9::Load"));
	{
		// KFbxSdkManager쐬
		mPFbxSdkManager = KFbxSdkManager::Create();

		// KFbxIOSettings쐬Aݒ
		KFbxIOSettings* pFbxIOSettings = KFbxIOSettings::Create(mPFbxSdkManager, IOSROOT);
		mPFbxSdkManager->SetIOSettings(pFbxIOSettings);


		// C|[^[쐬
		KFbxImporter* pFbxImporter = KFbxImporter::Create(mPFbxSdkManager, "Importer");

		// Ηǂ̂܂ō쐬̃bv^Co
		loadTimer.OutputLapTime(_T("x΂悢"));

		// C|[^[̐tO
		bool isSuceededImporterInitialize = false;

		// t@CtH[}bg
		int fileFormat = -1;

#ifdef UNICODE
		// pXCHAR^ɕϊ
		CHAR fullPath[StringHelper::mStKDefaultBufferSize];
		StringHelper::ToMultiByteChar(fullPath, sizeof(fullPath), kPFullPath);

		// C|[^[
		isSuceededImporterInitialize = pFbxImporter->Initialize(fullPath, fileFormat, mPFbxSdkManager->GetIOSettings());
#else
		// C|[^[
		isSuceededImporterInitialize = pFbxImporter->Initialize(kPFullPath, fileFormat, pFbxIOSettings);
#endif // UNICODE

		// ASSERT:C|[^[̏ɎsȂ玀B
		ASSERT_PRINTF(isSuceededImporterInitialize, _T("KFbxImporteȑɎs܂B\nPath=%s\n%s"),
			kPFullPath,
			StringHelper::ToWideChar(pFbxImporter->GetLastErrorString()).c_str());

		// C|[^[̏ɐȂ
		if (isSuceededImporterInitialize)
		{
			// P[Vݒ
			StringHelper::SetLocaleJapan();


			// t@C̃o[W擾
			int mejorVersion = 0;
			int minorVersion = 0;
			int revisionVersion = 0;
			pFbxImporter->GetFileVersion(mejorVersion, minorVersion, revisionVersion);

			PFL(_T("t@Co[W:%d.%d.%d"), mejorVersion, minorVersion, revisionVersion);

			// V[̍쐬
			KFbxScene* pFbxScene = KFbxScene::Create(mPFbxSdkManager, "Scene");
	
			// ASSERT:V[̍쐬ɎsȂ玀
			ASSERT_PRINTF(pFbxScene, _T("KFbxScene̍쐬Ɏs܂B"));
			
			// ێ
			mPFbxScene = pFbxScene;

			// V[̍쐬ɐȂ
			if (pFbxScene)
			{
				// C|[gJnÕbv^Co
				loadTimer.OutputLapTime(_T("C|[gO"));

				// MEMO:ɏdłBƂƂłB
				// MEMO:f[^oCiƋقǍłB
				// C|[g
				bool isSucceededImporterImport = pFbxImporter->Import(pFbxScene);

				// ASSERT:C|[gɎsȂ玀B
				ASSERT_PRINTF(isSucceededImporterImport, _T("C|[gɎs܂B"));

				// C|[gJnÕbv^Co
				loadTimer.OutputLapTime(_T("C|[g"));


				// [gm[h擾
				KFbxNode* pRootNode = pFbxScene->GetRootNode();
				if (pRootNode)
				{
					// bVǂݍ
					LoadRecursive(kPFullPath, pRootNode);
				}
			}
		}
	}
	// ^C}[I
	loadTimer.End();

	// ^C}[̌ʂo
	loadTimer.OutputResult();


	return true;
}


/// XV
void MeshFbxDX9::Update(float delta)
{
}

/// `
void MeshFbxDX9::Render()
{
	// ̕`揈
	MeshDX9::Render();


	// bVȂ
	if (mPFbxMesh)
	{
		// foCX擾
		GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
		IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();
		

		// o[ebNẌʒuXg[ݒ
		SP<VertexBufferDX9> pPositionBuffer = mPVertexBuffers[eVERTEXBUFFER_POSITION];
		pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, pPositionBuffer->GetBuffer(), 0, pPositionBuffer->GetStride());

		// o[ebNXUVXg[ݒ
		SP<VertexBufferDX9> pUVBuffer = mPVertexBuffers[eVERTEXBUFFER_UV];
		pDevice->SetStreamSource(VertexStreamType::eSTREAM_UV, pUVBuffer->GetBuffer(), 0, pUVBuffer->GetStride());

		// o[ebNX̖@Xg[ݒ
		SP<VertexBufferDX9> pNormalBuffer = mPVertexBuffers[eVERTEXBUFFER_NORMAL];
		pDevice->SetStreamSource(VertexStreamType::eSTREAM_NORMAL, pNormalBuffer->GetBuffer(), 0, pNormalBuffer->GetStride());


		// MEMO:bVdł͂ȂĈCO
		//// XPgȂ
		//if (mPSkeleton)
		//{
		//	// o[ebNX̃{[CfbNXXg[ݒ
		//	SP<VertexBufferDX9> pBoneIndexBuffer = mPSkeleton->GetBoneIndexVertexBuffer();
		//	pDevice->SetStreamSource(VertexStreamType::eSTREAM_BONE_INDEX, pBoneIndexBuffer->GetBuffer(), 0, pBoneIndexBuffer->GetStride());

		//	// o[ebNX̃{[EFCgXg[ݒ
		//	SP<VertexBufferDX9> pBoneWeightBuffer = mPSkeleton->GetBoneWeightVertexBuffer();
		//	pDevice->SetStreamSource(VertexStreamType::eSTREAM_BONE_WEIGHT, pBoneWeightBuffer->GetBuffer(), 0, pBoneWeightBuffer->GetStride());
		//}
		//// XPgȂ
		//else
		//{
		//	// o[ebNX̃{[CfbNXXg[ݒ
		//	SP<VertexBufferDX9> pBoneIndexBuffer = mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX];
		//	pDevice->SetStreamSource(VertexStreamType::eSTREAM_BONE_INDEX, pBoneIndexBuffer->GetBuffer(), 0, pBoneIndexBuffer->GetStride());
		//	
		//	// o[ebNX̃{[EFCgXg[ݒ
		//	SP<VertexBufferDX9> pBoneWeightBuffer = mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT];
		//	pDevice->SetStreamSource(VertexStreamType::eSTREAM_BONE_WEIGHT, pBoneWeightBuffer->GetBuffer(), 0, pBoneWeightBuffer->GetStride());
		//}


		// _錾ݒ
		pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());


		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// [hs쐬
		//Matrix world = mWorld;

		// MEMO:XPgɈڍsǂł傤B
		//// Aj[V񂪂Ȃ
		//if (mPAnimation)
		//{
		//	/* L[t[Aj[Vp */

		//	// Aj[V݂̌̃^C擾
		//	const long long kCurrentTime = mPAnimation->GetCurrentTime();

		//	// ݂̃L[ł̃[hs擾
		//	const KFbxXMatrix& kRKeyMatrix = mPFbxMesh->GetNode()->EvaluateGlobalTransform(kCurrentTime);

		//	// ϊ
		//	Matrix keyMatrix;
		//	MathHelper::ToMatrix(kRKeyMatrix, &keyMatrix);


		//	// [hsXV
		//	world = keyMatrix * world;
		//}

		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// [hsݒ
		//mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &MathHelperDX::ToD3DXMATRIX(world));
		//

		//// WVPs쐬Aݒ
		//Matrix wvp;
		//wvp = world;
		//wvp *= mView;
		//wvp *= mProjection;
		//wvp *= mViewport;

		//mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &MathHelperDX::ToD3DXMATRIX(world));
		//mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &MathHelperDX::ToD3DXMATRIX(mView));
		//mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &MathHelperDX::ToD3DXMATRIX(mProjection));
		//mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEWPORT, &MathHelperDX::ToD3DXMATRIX(mViewport));
		//mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD_VIEW_PROJECTION, &MathHelperDX::ToD3DXMATRIX(wvp));


		//// VF[_[GtFNgɎ̈ʒuݒ
		//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_EYE_POSITION, mEyePosition.GetArray(), 3);


		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// sp
		//D3DXMATRIX boneMatrixArray[SkeletonFbx::mStKMaxBoneCount];
		//for (int i = 0; i < SkeletonFbx::mStKMaxBoneCount; ++i)
		//{
		//	D3DXMatrixIdentity(&boneMatrixArray[i]);
		//}

		// MEMO:VF[_[ڂł܂ňUĂ܂B
		//// XPgȂ
		//if (mPSkeleton)
		//{
		//	// _ELXg
		//	SP<SkeletonFbx> pSkeletonFbx;
		//	pSkeletonFbx.DownCast(mPSkeleton);

		//	// _ELXgoȂ
		//	if (pSkeletonFbx)
		//	{
		//		// {[̐Ń[v
		//		const int kBoneCount = mPSkeleton->GetBoneCount();
		//		for (int i = 0; i < kBoneCount; ++i)
		//		{
		//			// Q
		//			const SkeletonFbx::SBone& kRSBone = pSkeletonFbx->GetBone(i);
		//			const Matrix& kRBindPose = kRSBone.mBindPoseMatrix;


		//			// oCh|[Yts
		//			Matrix invBindPose;
		//			Matrix::Inverse(kRBindPose, &invBindPose);


		//			// Aj[V݂̌̃^C擾
		//			const long long kCurrentTime = mPAnimation->GetCurrentTime();

		//			// Jg|[Ys擾
		//			KFbxCluster* kPCluster = pSkeletonFbx->GetClusters()[i];
		//			KFbxXMatrix& kRCurrentPoseMatrix = kPCluster->GetLink()->EvaluateGlobalTransform(kCurrentTime);

		//			// ϊ
		//			Matrix currentPoseMatrixYUpLH;
		//			MathHelper::ToMatrix(kRCurrentPoseMatrix, &currentPoseMatrixYUpLH);

		//			currentPoseMatrixYUpLH *= MathHelper::CreateZUpRHToYUpLH();


		//			// XLjOpsZo
		//			Matrix skinningMatrix;
		//			skinningMatrix = invBindPose * currentPoseMatrixYUpLH;


		//			// szɐݒ
		//			D3DXMATRIX currentPoseMatrixDX;
		//			MathHelperDX::ToD3DXMATRIX(skinningMatrix, &currentPoseMatrixDX);

		//			boneMatrixArray[i] = currentPoseMatrixDX;
		//		}
		//	}
		//}

		//// VF[_[GtFNgɍszݒ
		//mPShaderEffect->SetMatrixArray(ShaderEffectDX9::eVARIABLE_CURRENT_POSE, boneMatrixArray, SkeletonFbx::mStKMaxBoneCount);


		// _擾
		const int kVertexCount = mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetVertexCount();


		// }eA̐Ń[v
		for (int i = 0; i < mMaterialCount; ++i)
		{
			// Q
			SMaterial& rSMaterial = mPSMaterials[i];


			// ArGgݒ
			const int kAmbientFactorCount = 4;
			const float kAmbient[kAmbientFactorCount] =
			{
				rSMaterial.mAmbient.mX,
				rSMaterial.mAmbient.mY,
				rSMaterial.mAmbient.mZ,
				rSMaterial.mAmbientFactor,
			};

			/// MEMO:bV̂ł͂ȂƎv̂CO
			//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, kAmbient, kAmbientFactorCount);

			//// fBt[Yݒ
			//const int kDiffuseFactorCount = 4;
			//const float kDiffuse[kDiffuseFactorCount] = 
			//{
			//	rSMaterial.mDiffuse.mX,
			//	rSMaterial.mDiffuse.mY,
			//	rSMaterial.mDiffuse.mZ,
			//	rSMaterial.mDiffuseFactor,
			//};

			//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_DIFFUSE, kDiffuse, kDiffuseFactorCount);


			//// XyLݒ
			//const int kSpecularFactorCount = 4;
			//const float kSpecular[kSpecularFactorCount] =
			//{
			//	rSMaterial.mSpecular.mX,
			//	rSMaterial.mSpecular.mY,
			//	rSMaterial.mSpecular.mZ,
			//	rSMaterial.mSpecularFactor,
			//};

			//mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_SPECULAR, kSpecular, kSpecularFactorCount);



			/// MEMO:bV̂ł͂ȂƎv̂CO
			//// fBt[YeNX`擾
			//SP<Blast::Graphic::Texture2DDX9> pDiffuseTexture;
			//pDiffuseTexture.DownCast(rSMaterial.mPDiffuseTexture);

			//// fBt[YeNX`Ȃ
			//if (pDiffuseTexture)
			//{
			//	// fBt[YeNX`ݒ
			//	mPShaderEffect->SetTexture(ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE, pDiffuseTexture->GetTexturePtrRef().GetInterface());
			//}


			// CfbNXobt@Q
			SP<IndexBufferDX9> pInexBuffer = mIndexBufferPtrs.at(i);

			// CfbNXobt@ݒ
			pDevice->SetIndices(pInexBuffer->GetBuffer());

			
			// v~eBu擾
			const int kPrimitiveCount = pInexBuffer->GetPrimitiveCount();


			/// MEMO:bV̂ł͂ȂƎv̂CO
			//// `Jn
			//unsigned passCount = -1;
			//mPShaderEffect->Begin(&passCount);
			//{
			//	// pX̐Ń[v
			//	for (unsigned j = 0 ; j < passCount; ++j)
			//	{
			//		// pXJn
			//		mPShaderEffect->BeginPass(j);
			//		{
			//			// `
			//			HRESULT hr = pDevice->DrawIndexedPrimitive(
			//				D3DPT_TRIANGLELIST,
			//				0,
			//				0,
			//				kVertexCount,
			//				0,
			//				kPrimitiveCount
			//				);

			//			// ASSERT:`ɎsȂ玀B
			//			ASSERT_PRINTF(SUCCEEDED(hr), _T("`Ɏs܂B"));
			//		}
			//		mPShaderEffect->EndPass();
			//	}
			//}
			//mPShaderEffect->End();
		}
	}

	// q̐Ń[v
	const int kChildCount = mChildrenPtrs.size();
	for (int i = 0; i < kChildCount; ++i)
	{
		/// MEMO:bV̂ł͂ȂƎv̂CO
		//// MEMO:MeshFbxDX9ꍇA[hs̏񂪎qɒʒBȂ̂łőB
		//// MEMO:q͌pMeshDX9łǂ̂ł傤B
		//mChildrenPtrs.at(i)->SetWorld(mWorld);

		mChildrenPtrs.at(i)->Render();
	}
}


/// r[sݒ
void MeshFbxDX9::SetView(const Matrix& kRView)
{
	///// MEMO:bV̂ł͂ȂƎv̂CO
	//mView = kRView;
	//
	//// q̐Ń[v
	//const int kChildCount = mChildrenPtrs.size();
	//for (int i = 0; i < kChildCount; ++i)
	//{
	//	mChildrenPtrs.at(i)->SetView(kRView);
	//}
}

/// ˉesݒ
void MeshFbxDX9::SetProjection(const Matrix& kRProjection)
{
			/// MEMO:bV̂ł͂ȂƎv̂CO
	//mProjection = kRProjection;
	//
	//// q̐Ń[v
	//const int kChildCount = mChildrenPtrs.size();
	//for (int i = 0; i < kChildCount; ++i)
	//{
	//	mChildrenPtrs.at(i)->SetProjection(kRProjection);
	//}
}


/// XPgݒ
void MeshFbxDX9::SetSkeleton(SP<ISkeleton> pSkeleton)
{
	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// ̃\bhĂ
	//MeshDX9::SetSkeleton(pSkeleton);


	//// q̐Ń[v
	//const int kChildCount = mChildrenPtrs.size();
	//for (int i = 0; i < kChildCount; ++i)
	//{
	//	mChildrenPtrs.at(i)->SetSkeleton(pSkeleton);
	//}
}

/// Aj[Vݒ
void MeshFbxDX9::SetAnimation(SP<IAnimation> pAnimation)
{
	/// MEMO:bV̂ł͂ȂƎv̂CO
	//// ̃\bhĂ
	//MeshDX9::SetAnimation(pAnimation);


	//// q̐Ń[v
	//const int kChildCount = mChildrenPtrs.size();
	//for (int i = 0; i < kChildCount; ++i)
	//{
	//	mChildrenPtrs.at(i)->SetAnimation(pAnimation);
	//}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ċAǂݍ
void MeshFbxDX9::LoadRecursive(const TCHAR* kPFullPath, KFbxNode* pNode)
{
	// Agr[g̐Ń[v
	const int kAttributeCount = pNode->GetNodeAttributeCount();
	for (int i = 0; i < kAttributeCount; ++i)
	{
		// Agr[g擾
		KFbxNodeAttribute* pAttribute = pNode->GetNodeAttributeByIndex(i);
		KFbxNodeAttribute::EAttributeType eType = pAttribute->GetAttributeType();

		// bVȂ
		if (eType == KFbxNodeAttribute::eMESH)
		{
			// LXg
			KFbxMesh* pMesh = static_cast<KFbxMesh*>(pAttribute);

			// bVǂݍ
			LoadMesh(kPFullPath, pMesh);

			break;
		}
	}


	// qm[h̐擾
	const int kChildCount = pNode->GetChildCount();

	// q̐ŃU[u
	mChildrenPtrs.clear();
	mChildrenPtrs.reserve(kChildCount);


	// qm[h̐Ń[v
	for (int i = 0; i < kChildCount; ++i)
	{
		// q쐬
		SP<MeshFbxDX9> pChildMesh(NEW MeshFbxDX9());


		// MEMO:͏璷ł傤B
		// MEMO:SdkManager͉ƍ̂œnĂ܂񂪂ǂł傤BX}[g|C^ɂǂł傤B
		// qɏn
		//pChildMesh->mPAnimation = this->mPAnimation;
		//pChildMesh->mPFbxSdkManager = this->mPFbxSdkManager;
		pChildMesh->mPFbxScene = this->mPFbxScene;


		// qm[h擾
		KFbxNode* pChild = pNode->GetChild(i);

		// qm[hōċA
		pChildMesh->LoadRecursive(kPFullPath, pChild);


		// ǉ
		mChildrenPtrs.push_back(pChildMesh);
	}
}

/// bVǂݍ
void MeshFbxDX9::LoadMesh(const TCHAR* kPFullPath, fbxsdk_2012_2::KFbxMesh* pMesh)
{
	/// FbxbVێ
	mPFbxMesh = pMesh;


	// bVm[h擾
	KFbxNode* pMeshNode = pMesh->GetNode();

	// ASSERT:bV擾łȂȂ玀B
	ASSERT_PRINTF(pMesh, _T("bV擾ł܂łB"));

			
	// _擾
	const int kPositionCount = pMesh->GetControlPointsCount();
	PFL(_T("_W=%d"), kPositionCount);


	// UV擾
	const KFbxGeometryElementUV* kPElementUV = pMesh->GetElementUV();
	if (kPElementUV)
	{
		const int kUVCount = kPElementUV->GetDirectArray().GetCount();
		PFL(_T("UV=%d"), kUVCount);

		// UVCfbNX擾
		const int kUVIndexCount = kPElementUV->GetIndexArray().GetCount();
		PFL(_T("UVCfbNX̐=%d"), kUVIndexCount);
	}


	// @擾
	const KFbxGeometryElementNormal* kPElementNormal = pMesh->GetElementNormal();
	if (kPElementNormal)
	{
		const int kNormalCount = kPElementNormal->GetDirectArray().GetCount();
		PFL(_T("@̐=%d"), kNormalCount);

		// @CfbNX擾
		const int kNormalIndexCount = kPElementNormal->GetIndexArray().GetCount();
		PFL(_T("@CfbNX̐=%d"), kNormalIndexCount);
	}


	// |S擾
	const int kPolygonCount = pMesh->GetPolygonCount();
	PFL(_T("|S=%d"), kPolygonCount);

	// CfbNX擾
	const int kIndexCount = kPolygonCount * 3;
	PFL(_T("_WCfbNX=%d"), kIndexCount);

	// }eA̐擾
	const int kMaterialCount = pMeshNode->GetMaterialCount();
	PFL(_T("}eA̐=%d"), kMaterialCount);


	// _ʒuz擾
	const KFbxVector4* kPRefPositions = pMesh->GetControlPoints();

	// CfbNXz擾
	const int* kPRefIndices = pMesh->GetPolygonVertices();


	// }eAǂݍ
	LoadMaterial(kPFullPath, pMesh->GetNode());


	// MEMO:C[0ŌŒ肵Ă܂B
	// }eA擾
	const KFbxLayerElementMaterial* kPElementMaterial = pMesh->GetLayer(0)->GetMaterials();

	// }eACfbNXz擾
	const KFbxLayerElementArrayTemplate<int>& kRMaterialIndices = kPElementMaterial->GetIndexArray();

	// }eACfbNX̐擾
	const int kMaterialIndexCount = kRMaterialIndices.GetCount();
	PFL(_T("}eACfbNX=%d"), kMaterialIndexCount);


	// _ʒuz𓮓Im
	SP<VertexBufferDX9::SPosition> pSPositions(NEW VertexBufferDX9::SPosition[kIndexCount], true);
	ZeroMemory(pSPositions.GetSource(), sizeof(VertexBufferDX9::SPosition) * kIndexCount);

	// UVz𓮓Im
	SP<VertexBufferDX9::SUV> pSUVs(NEW VertexBufferDX9::SUV[kIndexCount], true);
	ZeroMemory(pSUVs.GetSource(), sizeof(VertexBufferDX9::SUV) * kIndexCount);

	// @z𓮓Im
	SP<VertexBufferDX9::SNormal> pSNormals(NEW VertexBufferDX9::SNormal[kIndexCount], true);
	ZeroMemory(pSNormals.GetSource(), sizeof(VertexBufferDX9::SNormal) * kIndexCount);


	// CfbNXz𓮓Im
	SP<int> pIndices(NEW int[kIndexCount], true);
	ZeroMemory(pIndices.GetSource(), sizeof(pIndices.GetSource()));


	// ʒuCfbNX
	int positionAssignIndex = 0;

	// UVCfbNX
	int uvAssignIndex = 0;

	// @CfbNX
	int normalAssignIndex = 0;


	// EZ-UpnY-Upnɕϊsp
	const Matrix kCoordinateConvert = MathHelper::CreateZUpRHToYUpLH();


	// }eA̐Ń[v
	for (int i = 0; i < kMaterialCount; ++i)
	{
		// CfbNXz
		ZeroMemory(pIndices.GetSource(), sizeof(int) * kIndexCount);

		// CfbNX
		int assignIndex = 0;


		// tFCX̐Ń[v
		for (int j = 0; j < kPolygonCount; ++j)
		{
			// MEMO:tFCX̐ƕKvz񐔂Ȃ̂ł傤B
			// }eACfbNX擾
			const int kMaterialIndex = kRMaterialIndices[j];

			// CfbNXvȂ
			if (i == kMaterialIndex)
			{
				// MEMO:̏ł͎Op`|SłKv܂B
				// |Sꖇɑ΂钸_Ń[v
				for (int k = 0; k < 3; ++k)
				{
					// CfbNX擾
					const int kIndex = kPRefIndices[j * 3 + k];


					// ʒu擾
					Vector3 pos(
						static_cast<float>(kPRefPositions[kIndex][0]),
						static_cast<float>(kPRefPositions[kIndex][1]),
						static_cast<float>(kPRefPositions[kIndex][2])
						);

					// nϊ
					pos.Multiply(kCoordinateConvert);


					// ʒu
					pSPositions[positionAssignIndex].m[0] = pos[0];
					pSPositions[positionAssignIndex].m[1] = pos[1];
					pSPositions[positionAssignIndex].m[2] = pos[2];


					
					// ʒuCfbNXZ
					++positionAssignIndex;
					

					// UVȂ
					if (kPElementUV)
					{
						const KFbxLayerElementArrayTemplate<KFbxVector2>& kRRefUVs = kPElementUV->GetDirectArray();
						const KFbxLayerElementArrayTemplate<int>& kRRefUVIndices = kPElementUV->GetIndexArray();

						// UVCfbNX擾
						const int kUVIndex = kRRefUVIndices[j * 3 + k];

						// MEMO:VW͋tɂ܂B
						// UV
						pSUVs[uvAssignIndex].mU = static_cast<float>(kRRefUVs[kUVIndex][0]);
						pSUVs[uvAssignIndex].mV = static_cast<float>(kRRefUVs[kUVIndex][1]);
						pSUVs[uvAssignIndex].mV = 1 - pSUVs[uvAssignIndex].mV;
						
						++uvAssignIndex;
					}


					// @Ȃ
					if (kPElementNormal)
					{
						const KFbxLayerElementArrayTemplate<KFbxVector4>& kRRefNormals = kPElementNormal->GetDirectArray();
						const KFbxLayerElementArrayTemplate<int>& kRRefNormalIndices = kPElementNormal->GetIndexArray();

						// MEMO:fɂĂ͐mȃCfbNXKvł傤B
						// @CfbNX擾
						//int normalIndex = kRRefNormalIndices[i];
						const int KNormalIndex = j * 3 + k;

						// @擾
						Vector3 normal(
							static_cast<float>(kRRefNormals[KNormalIndex][0]),
							static_cast<float>(kRRefNormals[KNormalIndex][1]),
							static_cast<float>(kRRefNormals[KNormalIndex][2])
							);

						// nϊ
						normal.Multiply(kCoordinateConvert);

						// @
						pSNormals[normalAssignIndex].mX = normal.mX;
						pSNormals[normalAssignIndex].mY = normal.mY;
						pSNormals[normalAssignIndex].mZ = normal.mZ;


						++normalAssignIndex;
					}


					// MEMO:JOɑΉ邽߁Atɂ܂B
					const int kInvK = (2 - k);

					// CfbNX
					pIndices[assignIndex] = j * 3 + kInvK;

					// CfbNXZ
					++assignIndex;
				}
			}
		}

#if _DEBUG && DUMP_MESH_FBX
		// CfbNXz\
		for (int i = 0; i < kIndexCount; i += 3)
		{
			const int index0 = kPRefIndices[i+0];
			const int index1 = kPRefIndices[i+1];
			const int index2 = kPRefIndices[i+2];
			PFL(_T("ϊCfbNX(%3d, %3d, %3d)"), index0, index1, index2);
		}
		PFL(_T("--------------------------------------------------"));
		for (int i = 0; i < assignIndex; i += 3)
		{
			const int index0 = pIndices[i+0];
			const int index1 = pIndices[i+1];
			const int index2 = pIndices[i+2];
			PFL(_T("ϊCfbNX(%3d, %3d, %3d)"), index0, index1, index2);
		}
#endif // _DEBUG
		

		// CfbNXobt@쐬
		SP<IndexBufferDX9> pIndexBuffer(NEW IndexBufferDX9());
		pIndexBuffer->SetIndices(pIndices.GetSource(), assignIndex);

		mIndexBufferPtrs.push_back(pIndexBuffer);
	}


	// ʒũo[ebNXobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(pSPositions.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SPosition) * kIndexCount);

	// UṼo[ebNXobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(pSUVs.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SUV) * kIndexCount);

	// @̃o[ebNXobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_NORMAL]->SetVertices(pSNormals.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SNormal) * kIndexCount);

	// MEMO:͏lłB{ɕKvȎ̓XPgႢ܂B
	// {[CfbNXƃ{[EFCg쐬
	SP<VertexBufferDX9::SBoneIndex> pSBoneIndices(NEW VertexBufferDX9::SBoneIndex[kIndexCount], true);
	SP<VertexBufferDX9::SBoneWeight> pSBoneWeights(NEW VertexBufferDX9::SBoneWeight[kIndexCount], true);
	for (int i = 0; i < kIndexCount; ++i)
	{
		for (int j = 0; j < VertexBufferDX9::mStKMaxInfluenceBoneCount; ++j)
		{
			pSBoneIndices[i].mIndices[j] = 0;
			pSBoneWeights[i].mWeights[j] = 1;
		}
	}
	mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->SetVertices(pSBoneIndices.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SBoneIndex) * kIndexCount);
	mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->SetVertices(pSBoneWeights.GetSource(), kIndexCount, sizeof(VertexBufferDX9::SBoneWeight) * kIndexCount);


	// _`쐬
	VertexElementFactoryDX9 veFactory;
	const D3DVERTEXELEMENT9 elements[] =
	{
		veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
		veFactory.CreateElement(VertexElementType::eELEMENT_UV),
		veFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
		veFactory.CreateElement(VertexElementType::eELEMENT_BONE_INDEX),
		veFactory.CreateElement(VertexElementType::eELEMENT_BONE_WEIGHT),

		veFactory.CreateElement(VertexElementType::eELEMENT_END),
	};

	mPVertexDeclaration->CreateDeclaration(elements);
}

/// }eAǂݍ
void MeshFbxDX9::LoadMaterial(const TCHAR* kPFullPath, KFbxNode* pMeshNode)
{
	// }eA̐擾
	const int kMaterialCount = pMeshNode->GetMaterialCount();

	// }eA̐ێ
	mMaterialCount = kMaterialCount;


	// }eAz𓮓I쐬
	mPSMaterials.SetPointer(NEW SMaterial[kMaterialCount], true);


	// }eA̐Ń[v
	for (int i = 0; i < kMaterialCount; ++i)
	{
		// Q
		SMaterial& rSMaterial = mPSMaterials[i];


		// }eA擾
		const KFbxSurfaceMaterial* pMaterial = pMeshNode->GetMaterial(i);

		// NXID擾
		kFbxClassId id = pMaterial->GetClassId();

		// o[g}eAȂ
		if (id == KFbxSurfaceLambert::ClassId)
		{
			// LXg
			const KFbxSurfaceLambert* pLambert = static_cast<const KFbxSurfaceLambert*>(pMaterial);

			// MEMO:fBt[YArGgȂǂ̎擾܂B
			WARNING(false, _T("o[g}eAɑ΂鏈܂B"));
		}
		// tH}eAȂ
		else if (id == KFbxSurfacePhong::ClassId)
		{
			// LXg
			const KFbxSurfacePhong* pPhong = static_cast<const KFbxSurfacePhong*>(pMaterial);


			// }eA擾
			TCHAR materialName[Directory::mStKMaxPath];
			StringHelper::ToWideChar(materialName, Directory::mStKMaxPath, pPhong->GetName());

			rSMaterial.mNameStr = materialName;


			// fBt[Y擾
			for (int j = 0; j < 3; ++j)
			{
				rSMaterial.mDiffuse[j] = static_cast<float>(pPhong->Diffuse.Get()[j]);
			}

			rSMaterial.mDiffuseFactor = static_cast<float>(pPhong->DiffuseFactor.Get());


			// ArGg擾
			for (int j = 0; j < 3; ++j)
			{
				rSMaterial.mAmbient = static_cast<float>(pPhong->Ambient.Get()[j]);
			}

			rSMaterial.mAmbientFactor = static_cast<float>(pPhong->AmbientFactor.Get());


			// XyL擾
			for (int j = 0; j < 3; ++j)
			{
				rSMaterial.mSpecular = static_cast<float>(pPhong->Specular.Get()[j]);
			}

			rSMaterial.mSpecularFactor = static_cast<float>(pPhong->SpecularFactor.Get());


			// VClX擾
			rSMaterial.mShininess = static_cast<float>(pPhong->Shininess.Get());


			// fBt[YeNX`擾
			KFbxProperty& rDiffuseProperty = pPhong->FindProperty(KFbxSurfaceMaterial::sDiffuse);
			KFbxObject* pDiffuseObject = rDiffuseProperty.GetSrcObject(KFbxTexture::ClassId);

			// fBt[YeNX`񂪂Ȃ
			if (pDiffuseObject)
			{
				// eNX`ɃLXg
				KFbxFileTexture* pDiffuseTexture = KFbxCast<KFbxFileTexture>(pDiffuseObject);


				// fBNg擾
				TCHAR absDirectory[Directory::mStKMaxPath];
				Directory::GetDirectoryPath(kPFullPath, absDirectory);

				PFL(_T("[fBNg]\n\t%s"), absDirectory);

				// MEMO:FBXt@CFBXRo[^[ŕϊƁA΃pX擾łȂȂĂ܂̂ł傤B
				// MEMO:3dsmaxł̓vWFNgtH_ōƂȂƃYĂ܂܂B
				// ΃eNX`pX擾
				const CHAR* pRelativeFilePath = pDiffuseTexture->GetRelativeFileName();
				TCHAR relTexturePath[Directory::mStKMaxPath];
				StringHelper::ToWideChar(relTexturePath, Directory::mStKMaxPath, pRelativeFilePath);

				PFL(_T("[΃eNX`pX]\n\t%s"), relTexturePath);

				// ΃eNX`pX쐬
				TCHAR absTexturePath[Directory::mStKMaxPath];
				memcpy(absTexturePath, absDirectory, sizeof(absDirectory));
				_tcscat_s(absTexturePath, relTexturePath);

				PFL(_T("[΃eNX`pX]\n\t%s"), absTexturePath);


				SP<FileTexture2DDX9> pTexture(NEW FileTexture2DDX9());
				bool isLoadSucceeded = pTexture->Load(absTexturePath);

				// WARNING:eNX`̓ǂݍ݂ɎsȂx
				WARNING(isLoadSucceeded, _T("eNX`̓ǂݍ݂Ɏs܂B\n\t%s\n\t%s"), kPFullPath, absTexturePath);


				// ێ
				rSMaterial.mPDiffuseTexture = pTexture;
			}
		}
	}
}
