#include "Blast/Base/MenuEntryStrings.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MenuEntryStrings::MenuEntryStrings() :
mSelectedIndex(-1),
mRelativePositionX(150)
{
}

/// fXgN^
MenuEntryStrings::~MenuEntryStrings()
{
}


/// ͏
void MenuEntryStrings::HandleInput(float delta)
{
	// ̓͏
	MenuEntry::HandleInput(delta);
	

	// IĂȂ
	if (mIsSelected)
	{
		InputManager* pIM = InputManager::GetInstance();
		IKeyboard* pKB = pIM->GetKeyboard();
		const float kInterval = 0.05f;
		const float kDelay = 0.5f;

		// EL[őI
		if (pKB->IsDelayRapidDown(Keys::eKEY_RIGHT, kInterval, kDelay))
		{
			++mSelectedIndex;
		}
		else if (pKB->IsDelayRapidDown(Keys::eKEY_LEFT, kInterval, kDelay))
		{
			--mSelectedIndex;
		}

		// ͈͊O
		if (mStrings.empty())
		{
			mSelectedIndex = -1;
		}
		else
		{
			const int kClampMax = static_cast<int>(mStrings.size()) - 1;
			mSelectedIndex = MathHelper::Clamp(mSelectedIndex, 0, kClampMax);
		}
	}
}

/// `揈
void MenuEntryStrings::Render()
{
	// ̕`揈
	MenuEntry::Render();


	// IĂ镶擾
	const TCHAR* kPSelectedString = GetSelectedString();

	// IĂ镶񂪗LȂ
	if (kPSelectedString)
	{
		// Ε`ʒuZo
		Vector3 pos = mPosition;
		pos.mX += mRelativePositionX;

		// ʒuݒ
		mPTextRenderer->SetPosition(pos);


		// eLXgݒ
		mPTextRenderer->SetText(kPSelectedString);


		// `
		mPTextRenderer->Render();
	}
}


/// ǉ
void MenuEntryStrings::AddString(const TCHAR* kPString)
{
	// ǉ
	mStrings.push_back(kPString);

	// ICfbNX-1Ȃ
	if (mSelectedIndex == -1)
	{
		mSelectedIndex = 0;
	}
}

/// O
void MenuEntryStrings::RemoveString(const TCHAR* kPString)
{
	// Q̐Ń[v
	std::vector<tstring>::iterator it;
	for (it = mStrings.begin(); it != mStrings.end(); ++it)
	{
		// Q
		const tstring& kRString = (*it);

		// 񂪈vȂ
		if (kPString == kRString)
		{
			// O
			mStrings.erase(it);

			// Oreturn
			return;
		}
	}

	// Q̐0Ȃ
	if (mStrings.size() == 0)
	{
		mSelectedIndex = -1;
	}
}

/// O
void MenuEntryStrings::RemoveString(int index)
{
	// CfbNX͈͓Ȃ
	if (0 <= index &&
		index < static_cast<int>(mStrings.size()))
	{
		// CfbNẌʒu܂ŃCe[^[is
		std::vector<tstring>::iterator it = mStrings.begin();
		std::advance(it, index);

		// O
		mStrings.erase(it);
	}
	
	// Q̐0Ȃ
	if (mStrings.size() == 0)
	{
		mSelectedIndex = -1;
	}
}

/// ICfbNX擾
int MenuEntryStrings::GetSelectedIndex() const
{
	return mSelectedIndex;
}

/// 擾
const TCHAR* MenuEntryStrings::GetStringPtr(int index) const
{
	// CfbNX͈͓Ȃ
	if (0 <= index &&
		index < static_cast<int>(mStrings.size()))
	{
		return mStrings.at(index).c_str();
	}
	// CfbNX͈͊OȂ
	else
	{
		return NULL;
	}
}

/// IĂ镶擾
const TCHAR* MenuEntryStrings::GetSelectedString() const
{
	return GetStringPtr(mSelectedIndex);
}
