#include "Blast/Base/MenuEntryListScroll.h"

#include "Blast/Base/IMenuEntry.h"
#include "Blast/Base/ISelectable.h"
#include "Blast/Base/ISelectableMenuEntry.h"
#include "Blast/Graphic/DirectX9/FontDX9.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

	/* vpeB */

	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	MenuEntryListScroll::SProperty::SProperty()
	{
		// 
		Initialize();
	}

	/// 
	void MenuEntryListScroll::SProperty::Initialize()
	{
		mNameStr = _T("<>");

		mSelectedIndex = -1;
		mIsLoop = true;

		mPosition.mX = 20;
		mPosition.mY = 20;
		mPosition.mZ = 0;

		mLineSpacing = mStKLineSpacingDefault;

		mListNameColor = ColorCode::ToCode(ColorCode::eCOLOR_ORANGE);

		mVisibleEntryCount = 50;
		mVisibleEntryStartIndex = 0;

		mIsRenderGroupName = true;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MenuEntryListScroll::MenuEntryListScroll()
{
	// MEMO:tHgǗNXႤ`̕ǂł傤B
	// tHg쐬
	SP<FontDX9> pFont(NEW FontDX9());
	pFont->CreateFontData(FontDX9::stKPFontName, 12);

	// eLXg_[쐬
	mPTextRenderer.SetPointer(NEW TextRendererColorTag(pFont));


	// vpeB
	mSProperty.Initialize();
}

/// fXgN^
MenuEntryListScroll::~MenuEntryListScroll()
{
}


/// 
void MenuEntryListScroll::HandleInput(float delta)
{
	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// C^[o
	const float kInterval = 0.05f;

	// fBC
	const float kDelay = 0.5f; 

	// L[ꂽ
	if (pKB->IsDelayRapidDown(Keys::eKEY_UP, kInterval, kDelay))
	{
		// IĂCfbNXfNg
		--mSProperty.mSelectedIndex;

		// IĂCfbNX0Ȃ
		if (mSProperty.mSelectedIndex < 0)
		{
			// [vȂ
			if (mSProperty.mIsLoop)
			{
				mSProperty.mSelectedIndex = mEntries.size() - 1;
			}
			// [vȂȂ
			else
			{
				mSProperty.mSelectedIndex = 0;
			}
		}
	}
	// L[ꂽ
	else if (pKB->IsDelayRapidDown(Keys::eKEY_DOWN, kInterval, kDelay))
	{
		// IĂCfbNXCNg
		++mSProperty.mSelectedIndex;

		// IĂCfbNXGg[ȏȂ
		int size = mEntries.size();
		if (size <= mSProperty.mSelectedIndex)
		{
			// [vȂ
			if (mSProperty.mIsLoop)
			{
				mSProperty.mSelectedIndex = 0;
			}
			// [vȂȂ
			else
			{
				mSProperty.mSelectedIndex = mEntries.size() - 1;
			}
		}
	}


	// ݂̃CfbNX\鍀ڂĂȂA\̊JnCfbNX炷
	if (mSProperty.mSelectedIndex < mSProperty.mVisibleEntryStartIndex)
	{
		mSProperty.mVisibleEntryStartIndex = mSProperty.mSelectedIndex;
	}

	// ݂̃CfbNX\鍀ڂĂȂA\̊JnCfbNX炷
	const int kLastVisibleEntryIndex = mSProperty.mVisibleEntryStartIndex + (mSProperty.mVisibleEntryCount - 1);
	if (kLastVisibleEntryIndex < mSProperty.mSelectedIndex)
	{
		const int kIndex = mSProperty.mSelectedIndex - (mSProperty.mVisibleEntryCount - 1);
		mSProperty.mVisibleEntryStartIndex = kIndex;
	}


	// Xg̊evf̓͏s
	for (unsigned i = 0; i < mEntries.size(); ++i)
	{
		mEntries.at(i)->HandleInput(delta);
	}
}

/// XV
void MenuEntryListScroll::Update(float delta)
{
	// Xg̗vfŃ[v
	for (unsigned i = 0; i < mEntries.size(); ++i)
	{
		// Gg[Q
		SP<IMenuEntry> pEntry = mEntries.at(i);


		// ISelectableɃLXg
		SP<ISelectable> pSelectable;
		bool isSuccess = pSelectable.DownCast(pEntry);

		// LXgɐȂ
		if (isSuccess)
		{
			// [vJE^IĂCfbNXƈvȂ
			if (i == mSProperty.mSelectedIndex)
			{
				pSelectable->SetIsSelected(true);
			}
			else
			{
				pSelectable->SetIsSelected(false);
			}
		}


		// XV
		mEntries.at(i)->Update(delta);
	}
}

/// `
void MenuEntryListScroll::Render()
{
	// ʒuW
	float posX = mSProperty.mPosition.mX;
	float posY = mSProperty.mPosition.mY;


	// j[`
	if (mSProperty.mIsRenderGroupName)
	{
		Vector3 position(posX, posY, 0);
		mPTextRenderer->SetPosition(position);
		mPTextRenderer->SetBasicColor(mSProperty.mListNameColor);
		mPTextRenderer->SetText(mSProperty.mNameStr.c_str());

		mPTextRenderer->Render();
		

		// \O̍ڂꍇ́Äׂɖ\
		const int kEntryCount = mEntries.size();
		if (mSProperty.mVisibleEntryCount < kEntryCount)
		{
			const Vector2 kSmooth(-10, 0);
			const Vector3 kPos(posX + kSmooth.mX, posY + kSmooth.mY, 0.0f);

			mPTextRenderer->SetPosition(kPos);
			mPTextRenderer->SetText(_T("\n"));
			mPTextRenderer->Render();
		}

		// YWʒu炷
		posY += mPTextRenderer->GetFont()->GetPointSize();
	}


	// xɕ\鍀ڐŃ[v
	for (int i = 0; i < mSProperty.mVisibleEntryCount; ++i)
	{
		// Gg[Q
		const int kEntryCount = mEntries.size();
		const int kEntryIndex = i + mSProperty.mVisibleEntryStartIndex;
		if (kEntryIndex < 0)
		{
			break;
		}
		if (kEntryCount <= kEntryIndex)
		{
			continue;
		}
		
		SP<IMenuEntry> pEntry = mEntries.at(kEntryIndex);


		// 2ڈȍ~̍ڂ͈ʒu炷
		if (i != 0)
		{
			posY += pEntry->GetHeight();
			posY += mSProperty.mLineSpacing;
		}

		// Gg[̕\ʒuݒ
		pEntry->SetPositionX(posX);
		pEntry->SetPositionY(posY);

		// Gg[`
		pEntry->Render();
	}
}


/// Gg[ǉ
void MenuEntryListScroll::AddMenuEntry(SP<IMenuEntry> pEntry)
{
	// Gg[ǉ
	mEntries.push_back(pEntry);

	// Gg[ɃtHgݒ
	pEntry->SetFont(mPTextRenderer->GetFont());


	// IĂCfbNX0Ȃ
	if (mSProperty.mSelectedIndex < 0)
	{
		mSProperty.mSelectedIndex = 0;
	}
}

/// Gg[O
void MenuEntryListScroll::RemoveMenuEntry(SP<IMenuEntry> pME)
{
	std::vector< SP<IMenuEntry> >::iterator it;
	for (it = mEntries.begin(); it != mEntries.end(); ++it)
	{
		if (pME == (*it))
		{
			mEntries.erase(it);
		}
	}
}


/// Gg[擾
SP<IMenuEntry> MenuEntryListScroll::GetMenuEntry(const TCHAR* kPName) const
{
	// Gg[̐Ń[v
	for (unsigned i = 0; i < mEntries.size(); ++i)
	{
		// Gg[擾
		const TCHAR* kPEntryName = mEntries.at(i)->GetName();

		// Gg[vȂ
		if (_tcscmp(kPName, kPEntryName) == 0)
		{
			return mEntries.at(i);
		}
	}

	// ȂȂ
	SP<IMenuEntry> pME;

	return pME;
}

/// I𒆂̃Gg[擾
SP<IMenuEntry> MenuEntryListScroll::GetSelectedMenuEntry() const
{
	// Gg[̐0Ȃ
	if (mEntries.empty())
	{
		return SP<IMenuEntry>();
	}

	// Gg[擾
	SP<IMenuEntry> pSelectedEntry = mEntries.at(mSProperty.mSelectedIndex);

	return pSelectedEntry;
}


/// Gg[̐擾
int MenuEntryListScroll::GetEntryCount() const
{
	return mEntries.size();
}


/// O擾
const TCHAR* const MenuEntryListScroll::GetName() const
{
	return mSProperty.mNameStr.c_str();
}

/// Oݒ
void MenuEntryListScroll::SetName(const TCHAR* const kPName)
{
	mSProperty.mNameStr = kPName;
}


/// IĂCfbNX擾
int MenuEntryListScroll::GetSelectedIndex() const
{
	return mSProperty.mSelectedIndex;
}

/// IĂCfbNXݒ
void MenuEntryListScroll::SetSelectedIndex(int index)
{
	mSProperty.mSelectedIndex = index;
}


/// ʒu擾
const Vector3& MenuEntryListScroll::GetPosition() const
{
	return mSProperty.mPosition;
}

/// ʒuݒ
void MenuEntryListScroll::SetPosition(const Vector3& kRPosition)
{
	mSProperty.mPosition = kRPosition;
}


/// O̐F擾
const Color& MenuEntryListScroll::GetNameColor() const
{
	return mSProperty.mListNameColor;
}

/// O̐Fݒ
void MenuEntryListScroll::SetNameColor(const Color& kRColor)
{
	mSProperty.mListNameColor = kRColor;
}


/// Jݒ
void MenuEntryListScroll::SetCamera(const SP<ICamera> pCamera)
{
	mPTextRenderer->SetCamera(pCamera);
}


/// I[v邩擾
bool MenuEntryListScroll::IsLoop() const
{
	return mSProperty.mIsLoop;
}

/// I[v邩ݒ
void MenuEntryListScroll::SetIsLoop(bool b)
{
	mSProperty.mIsLoop = b;
}


//====================================================================================================
// Transfer
//----------------------------------------------------------------------------------------------------

/// tHgݒ
void MenuEntryListScroll::SetFont(SP<IFont> pFont)
{
	mPTextRenderer->SetFont(pFont);
}

