#include "Blast/Base/MenuEntryListMatrix.h"

#include "Blast/Base/IMenuEntry.h"
#include "Blast/Base/ISelectable.h"
#include "Blast/Base/ISelectableMenuEntry.h"
#include "Blast/Graphic/DirectX9/FontDX9.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MenuEntryListMatrix::MenuEntryListMatrix() :
mNameStr(_T("")),
mNameColor(ColorCode::ToCode(ColorCode::eCOLOR_ORANGE)),
mEntries(),
mLineSpacing(0),
mSelectedIndex(0),
mPosition(10),
mPTextRenderer(),
mFoldingEntryCount(30)
{
	// MEMO:tHgǗNXႤ`̕ǂł傤B
	// tHg쐬
	SP<FontDX9> pFont(NEW FontDX9());
	pFont->CreateFontData(FontDX9::stKPFontName, 12);

	// eLXg_[쐬
	mPTextRenderer.SetPointer(NEW TextRendererColorTag(pFont));
}

/// fXgN^
MenuEntryListMatrix::~MenuEntryListMatrix()
{
}


/// 
void MenuEntryListMatrix::HandleInput(float delta)
{
	// L[{[h擾
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// C^[o
	const float kInterval = 0.05f;

	// fBC
	const float kDelay = 0.5f; 


	// L[ꂽ
	if (pKB->IsDelayRapidDown(Keys::eKEY_UP, kInterval, kDelay))
	{
		// ύXÕO[ṽCfbNX擾
		const int kPreGroupIndex = mSelectedIndex / mFoldingEntryCount;

		// IĂCfbNXfNg
		--mSelectedIndex;

		// ύX̃O[ṽCfbNX擾
		const int kCurGroupIndex = mSelectedIndex / mFoldingEntryCount;


		// IĂCfbNX0A
		// O[vׂȂA
		// O[v̍Ōɐݒ肷
		if (mSelectedIndex < 0 ||
			(kPreGroupIndex != kCurGroupIndex))
		{
			// O[v̍Ōɐݒ
			mSelectedIndex = kPreGroupIndex * mFoldingEntryCount;
			mSelectedIndex += mFoldingEntryCount - 1;

			// Gg[̍ő吔𒴉߂ȂAő吔ɐݒ肷
			const int kEntryCount = mEntries.size();
			if (kEntryCount <= mSelectedIndex)
			{
				mSelectedIndex = kEntryCount - 1;
			}
		}
	}
	// L[ꂽ
	else if (pKB->IsDelayRapidDown(Keys::eKEY_DOWN, kInterval, kDelay))
	{
		// ύXÕO[ṽCfbNX擾
		const int kPreGroupIndex = mSelectedIndex / mFoldingEntryCount;

		// IĂCfbNXCNg
		++mSelectedIndex;

		// ύX̃O[ṽCfbNX擾
		const int kCurGroupIndex = mSelectedIndex / mFoldingEntryCount;


		// O[vׂA
		// IĂCfbNXGg[ȏȂA
		// O[v̓Ɉړ
		const int kEntryCount = mEntries.size();
		bool isHead = (kPreGroupIndex != kCurGroupIndex);
		isHead |= (kEntryCount <= mSelectedIndex);
		if (isHead)
		{
			mSelectedIndex = kPreGroupIndex * mFoldingEntryCount;
		}
	}
	// L[ꂽ
	else if (pKB->IsDelayRapidDown(Keys::eKEY_RIGHT, kInterval, kDelay))
	{
		// IĂCfbNX܂Ԃ̃Gg[ŉZ
		mSelectedIndex += mFoldingEntryCount;

		// CfbNXGg[̐𒴉߂
		const int kEntryCount = mEntries.size();
		if (kEntryCount <= mSelectedIndex)
		{
			const int kCurrentColumn = mSelectedIndex / mFoldingEntryCount;
			if (mFoldingEntryCount * kCurrentColumn < kEntryCount &&
				kEntryCount < mFoldingEntryCount * (kCurrentColumn + 1))
			{
				mSelectedIndex = kEntryCount - 1;
			}
			else
			{
				mSelectedIndex -= mFoldingEntryCount * kCurrentColumn;
			}
		}
	}
	// L[ꂽ
	else if (pKB->IsDelayRapidDown(Keys::eKEY_LEFT, kInterval, kDelay))
	{
		// IĂCfbNX܂Ԃ̃Gg[ŉZ
		mSelectedIndex -= mFoldingEntryCount;

		// CfbNX}CiXȂ
		if (mSelectedIndex < 0)
		{
			const int kEntryCount = mEntries.size();
			const int kTotalColumnCount = kEntryCount / mFoldingEntryCount;
			mSelectedIndex += mFoldingEntryCount * (kTotalColumnCount + 1);

			// Gg[𒴂ĂȂAŌ̗vfI
			if (kEntryCount <= mSelectedIndex)
			{
				mSelectedIndex = kEntryCount - 1;
			}			
		}
	}


	// Xg̊evf̓͏s
	for (unsigned i = 0; i < mEntries.size(); ++i)
	{
		mEntries.at(i)->HandleInput(delta);
	}
}

/// XV
void MenuEntryListMatrix::Update(float delta)
{
	// Xg̗vfŃ[v
	for (unsigned i = 0; i < mEntries.size(); ++i)
	{
		// Gg[Q
		SP<IMenuEntry> pEntry = mEntries.at(i);

		// ISelectableɃLXg
		SP<ISelectable> pSelectable;
		if (pSelectable.DownCast(pEntry))
		{
			// [vJE^IĂCfbNXƈvȂ
			if (i == mSelectedIndex)
			{
				pSelectable->SetIsSelected(true);
			}
			else
			{
				pSelectable->SetIsSelected(false);
			}
		}


		// XV
		mEntries.at(i)->Update(delta);
	}
}

/// `
void MenuEntryListMatrix::Render()
{
	// ʒuW
	float posX = mPosition.mX;
	float posY = mPosition.mY;


	// j[`
	Vector3 position(posX, posY, 0);
	mPTextRenderer->SetPosition(position);
	mPTextRenderer->SetBasicColor(mNameColor);
	mPTextRenderer->SetText(mNameStr.c_str());

	mPTextRenderer->Render();


	// YWʒu炷
	posY += mPTextRenderer->GetFont()->GetPointSize();
	posY += mLineSpacing;


	// Gg[̕`Jnʒu
	const Vector3 kEntryStartPosition(posX, posY, 0);

	// xɕ\鍀ڐŃ[v
	const int kEntryCount = mEntries.size();
	for (int i = 0; i < kEntryCount; ++i)
	{
		// Gg[Q
		SP<IMenuEntry> pEntry = mEntries.at(i);
		if (!pEntry)
		{
			continue;
		}

		// Gg[̕\ʒuݒ
		Vector3 pos = kEntryStartPosition;
		pos.mX += 150 * (i / mFoldingEntryCount);
		pos.mY += pEntry->GetHeight() * (i % mFoldingEntryCount);

		pEntry->SetPositionX(pos.mX);
		pEntry->SetPositionY(pos.mY);

		// Gg[`
		pEntry->Render();
	}
}


/// Gg[ǉ
void MenuEntryListMatrix::AddMenuEntry(SP<IMenuEntry> pEntry)
{
	// Gg[ǉ
	mEntries.push_back(pEntry);

	// Gg[ɃtHgݒ
	pEntry->SetFont(mPTextRenderer->GetFont());


	// IĂCfbNX0Ȃ
	if (mSelectedIndex < 0)
	{
		mSelectedIndex = 0;
	}
}

/// Gg[O
void MenuEntryListMatrix::RemoveMenuEntry(SP<Blast::Base::IMenuEntry>)
{
	HALT(_T("łB"));
}


/// Gg[擾
SP<IMenuEntry> MenuEntryListMatrix::GetMenuEntry(const TCHAR* const kPName) const
{
	// Gg[̐Ń[v
	for (unsigned i = 0; i < mEntries.size(); ++i)
	{
		// Gg[擾
		const TCHAR* kPEntryName = mEntries.at(i)->GetName();

		// Gg[vȂ
		if (_tcscmp(kPName, kPEntryName) == 0)
		{
			return mEntries.at(i);
		}
	}


	// HALT:ȂȂ玀
	HALT(_T("Gg[擾ł܂łB\nO=%s"), kPName);


	// ȂȂ
	SP<IMenuEntry> pME;

	return pME;
}

/// I𒆂̃Gg[擾
SP<IMenuEntry> MenuEntryListMatrix::GetSelectedMenuEntry() const
{
	// Gg[̐0Ȃ
	if (mEntries.empty())
	{
		return SP<IMenuEntry>();
	}

	// Gg[擾
	SP<IMenuEntry> pSelectedEntry = mEntries.at(mSelectedIndex);

	return pSelectedEntry;
}


/// Gg[̐擾
int MenuEntryListMatrix::GetEntryCount() const
{
	return mEntries.size();
}


/// O擾
const TCHAR* const MenuEntryListMatrix::GetName() const
{
	return mNameStr.c_str();
}

/// Oݒ
void MenuEntryListMatrix::SetName(const TCHAR* const kPName)
{
	mNameStr = kPName;
}


/// IĂCfbNX擾
int MenuEntryListMatrix::GetSelectedIndex() const
{
	return mSelectedIndex;
}

/// IĂCfbNXݒ
void MenuEntryListMatrix::SetSelectedIndex(int index)
{
	mSelectedIndex = index;
}


/// ʒu擾
const Vector3& MenuEntryListMatrix::GetPosition() const
{
	return mPosition;
}

/// ʒuݒ
void MenuEntryListMatrix::SetPosition(const Vector3& kRPos)
{
	mPosition = kRPos;
}


/// O̐F擾
const Color& MenuEntryListMatrix::GetNameColor() const
{
	return mNameColor;
}

/// O̐Fݒ
void MenuEntryListMatrix::SetNameColor(const Color& kRColor)
{
	mNameColor = kRColor;
}


/// Jݒ
void MenuEntryListMatrix::SetCamera(const SP<ICamera> pCamera)
{
	mPTextRenderer->SetCamera(pCamera);
}


/// ܂ԂGg̐ݒ
void MenuEntryListMatrix::SetFoldingEntryCount(int count)
{
	mFoldingEntryCount = count;
}


//====================================================================================================
// Transfar
//----------------------------------------------------------------------------------------------------

/// tHgݒ
void MenuEntryListMatrix::SetFont(SP<IFont> pFont)
{
	mPTextRenderer->SetFont(pFont);
}