#include "Blast/Memory/MemoryInfoMap.h"

#include "Blast/Memory/MemoryInfo.h"

using namespace Blast::Memory;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// Ĩ}bsOo
void MemoryInfoMap::DebugOutput()
{
	PFL(_T(""));
	PFL(_T("---------- Ĩ}bsOo ----------"));

	// 񂪈Ȃ
	if (mMemoryInfoMap.empty())
	{
		PFL(_T("͂܂B"));
	}
	// 񂪂Ȃ
	else
	{
		PFL(_T(""));

		// ̐Ń[v
		MemoryInfoMapType::iterator it;
		for (it = mMemoryInfoMap.begin(); it != mMemoryInfoMap.end(); ++it)
		{
			// 擾
			const MemoryInfo& kPMemoryInfo = (*it).second;
			const MemoryInfo::SProperty& kRSProperty = kPMemoryInfo.GetPropertyRef();

			void* pMemoryAddress = kRSProperty.mPMemoryAddress;
			const int& kRMemorySize = kRSProperty.mMemorySize;
			const tstring& kRFileNameStr = kRSProperty.mFileNameStr;
			const int& kRLineNumber = kRSProperty.mLineNumber;
			const bool& kRIsArray = kRSProperty.mIsArray;

			// o
			PFL(_T("%s(%d)"), kRFileNameStr.c_str(), kRLineNumber);
			PFL(_T("AhX:0x%08x"), pMemoryAddress);
			PFL(_T("TCY  :%d bytes"), kRMemorySize);
			PFL(_T("z񂩂ǂ  :%s"), (kRIsArray ? _T("True") : _T("False")));
			PFL(_T(""));
		}
	}
	PFL(_T("-------------------- o͊ --------------------"));
	PFL(_T(""));
}


//====================================================================================================
// PrivateStatic
//----------------------------------------------------------------------------------------------------

/// Ĩ}bv
MemoryInfoMap::MemoryInfoMapType MemoryInfoMap::mMemoryInfoMap;


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MemoryInfoMap::MemoryInfoMap()
{
}

/// fXgN^
MemoryInfoMap::~MemoryInfoMap()
{
}

/// AhX擾
MemoryInfo* MemoryInfoMap::GetMemoryInfoPtr(void* pMemoryAddress)
{
	// }bv擾
	MemoryInfoMapType::iterator it;
	it = mMemoryInfoMap.find(pMemoryAddress);

	// ASSERT:񂪖Ȃ玀
	ASSERT(it != mMemoryInfoMap.end());

	return &(*it).second;
}

/// I}
void MemoryInfoMap::InsertMemoryInfo(const MemoryInfo& kRMemoryInfo)
{
	// 擾
	const MemoryInfo::SProperty& rSProperty = kRMemoryInfo.GetPropertyRef();

	// MEMO:Ƃ͎v܂Aی͂Ɨǂł傤B
	// ASSERT:ɃL[݂Ȃ玀
	ASSERT(!IsExist(rSProperty.mPMemoryAddress));

	// }bvɑ}
	MemoryInfoMapType::value_type pair(rSProperty.mPMemoryAddress, kRMemoryInfo);
	mMemoryInfoMap.insert(pair);
}

/// IOBAhXw肷B
void MemoryInfoMap::RemoveMemoryInfo(void* pMemoryAddress)
{
	// 񂪖Ȃ
	if (!IsExist(pMemoryAddress))
	{
		return;
	}

	// }bv擾
	MemoryInfoMapType::iterator it;
	it = mMemoryInfoMap.find(pMemoryAddress);

	// }bv珜O
	mMemoryInfoMap.erase(it);
}

/// Ƀ}bvɒǉĂL[Ɠl擾
bool MemoryInfoMap::IsExist(void* pMemoryAddress)
{
	// L[
	MemoryInfoMapType::iterator it;
	it = mMemoryInfoMap.find(pMemoryAddress);

	// ɑ݂L[Ȃ
	if (it != mMemoryInfoMap.end())
	{
		return true;
	}
	else
	{
		return false;
	}
}

/// AhXz񂩂ǂ擾
bool MemoryInfoMap::IsArray(void* pMemoryAddress)
{
	// 񂪖Ȃ
	if (!IsExist(pMemoryAddress))
	{
		return false;
	}

	// }bv擾
	MemoryInfo* pMemoryInfo = GetMemoryInfoPtr(pMemoryAddress);

	return pMemoryInfo->GetPropertyRef().mIsArray;
}