#include "Blast/Math/Matrix.h"

#include "Blast/Math/Vector2.h"
#include "Blast/Math/Vector3.h"

using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// Pʉ
void Matrix::Identity(Matrix* pM)
{
	// s̐Ń[v
	for (int i = 0; i < mStKRowCount; ++i)
	{
		// ̐Ń[v
		for (int j = 0; j < mStKColumnCount; ++j)
		{
			// sƗ̃CfbNXȂ
			if (i == j)
			{
				pM->m[i][j] = 1;
			}
			// sƗ̃CfbNXႤȂ
			else
			{
				pM->m[i][j] = 0;
			}
		}
	}
}


/// MEMO:
/// x 0 0 0
/// 0 y 0 0
/// 0 0 z 0
/// 0 0 0 1
/// gks쐬
Matrix Matrix::CreateScale(float x, float y, float z, Matrix* pOut)
{
	// o͕ϐp	
	Matrix out;
	Identity(&out);

	// lݒ
	out.m11 = x;
	out.m22 = y;
	out.m33 = z;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}

/// gks쐬
Matrix Matrix::CreateScale(const Vector3& kRV, Matrix* pOut)
{
	return CreateScale(kRV.mX, kRV.mY, kRV.mZ, pOut);
}


/// MEMO:łB
/// 1    0    0   0
/// 0   cos  sin  0
/// 0  -sin  cos  0
/// 0    0    0   1
/// X]s쐬
Matrix Matrix::CreateRotationX(float radian, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);


	// sincos̒l擾
	float s, c;
	GetSinAndCos(&s, &c, radian);

	// lݒ
	out.m22 = c;
	out.m23 = s;
	out.m32 = -s;
	out.m33 = c;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}


/// MEMO:łB
///  cos  0  -sin  0
///   0   1    0   0
///  sin  0   cos  0
///   0   0    0   1
/// Y]s쐬
Matrix Matrix::CreateRotationY(float radian, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);


	// sincos̒l擾
	float s, c;
	GetSinAndCos(&s, &c, radian);

	// lݒ
	out.m11 = c;
	out.m13 = -s;
	out.m31 = s;
	out.m33 = c;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}

/// MEMO:
/// cos  sin  0  0
/// -sin cos  0  0
///  0    0   1  0
///  0    0   0  1
/// Z]s쐬
Matrix Matrix::CreateRotationZ(float radian, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);


	// sincos̒l擾
	float s, c;
	GetSinAndCos(&s, &c, radian);

	// lݒ
	out.m11 = c;
	out.m12 = s;
	out.m21 = -s;
	out.m22 = c;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}

/// ]s쐬
Matrix Matrix::CreateRotationZXY(float radianX, float radianY, float radianZ, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);

	// e]s쐬
	Matrix matX, matY, matZ;
	matX.CreateRotationX(radianX);
	matY.CreateRotationY(radianY);
	matZ.CreateRotationZ(radianZ);

	// MEMO:]̏ԂZAXAYłB
	out *= matZ;
	out *= matX;
	out *= matY;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}

/// ]s쐬
Matrix Matrix::CreateRotationZXY(const Vector3& kRValue, Matrix* pOut)
{
	return CreateRotationZXY(kRValue.mX, kRValue.mY, kRValue.mZ, pOut);
}

/// Cӎ]s쐬
Matrix Matrix::CreateRotationAxis(const Vector3& kRAxis, float rad, Matrix* pOut)
{
	Matrix out;
	Identity(&out);

	// DirectXAPI𗘗p܂
	D3DXVECTOR3 v;
	memcpy(&v, &kRAxis, sizeof(kRAxis));

	D3DXMATRIX m;
	D3DXMatrixRotationAxis(&m, &v, rad);

	memcpy(&out, &m, sizeof(m));

	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}


/// UV̉]s쐬
Matrix Matrix::CreateRotationUV(float radian, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);

	// sincos̒l擾
	float s = 0;
	float c = 0;
	GetSinAndCos(&s, &c, radian);

	// l
	out.m11 = c;
	out.m12 = s;
	out.m21 = -s;
	out.m22 = c;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}

	
/// MEMO:WnłB
/// 1 0 0 0
/// 0 1 0 0
/// 0 0 1 0
/// x y z 1
/// ړs쐬
Matrix Matrix::CreateTranslate(float x, float y, float z, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);

	// lݒ
	out.m41 = x;
	out.m42 = y;
	out.m43 = z;


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}

/// ړs쐬
Matrix Matrix::CreateTranslate(const Vector3& kRV, Matrix* pOut)
{
	return CreateTranslate(kRV.mX, kRV.mY, kRV.mZ, pOut);
}


/// s]u
Matrix Matrix::Transpose(const Matrix& kRM, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);


	// s̐Ń[v
	for (int i = 0; i < mStKRowCount; ++i)
	{
		// ̐Ń[v
		for (int j = 0; j < mStKColumnCount; ++j)
		{
			// MEMO:sƗւׁACfbNX݂łB
			out.m[i][j] = kRM.m[j][i];
		}
	}


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}


/// ts
Matrix Matrix::Inverse(const Matrix& kRM, Matrix* pOut)
{
	// o͕ϐp
	Matrix out;
	Identity(&out);


	// MEMO:ts̊ȒPŊmȋߕ܂ŁADirectXɗ܂B
	D3DXMATRIX matDX;
	MathHelperDX::ToD3DXMATRIX(kRM, &matDX);
	D3DXMatrixInverse(&matDX, NULL, &matDX);

	MathHelperDX::ToMatrix(matDX, &out);


	// |C^LȂ
	if (pOut)
	{
		*pOut = out;
	}

	return out;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Matrix::Matrix()
{
	// Pʉs
	Identity();
}

/// fXgN^
Matrix::~Matrix()
{
}


/// Pʉ
void Matrix::Identity()
{
	Identity(this);
}


/// gks쐬
void Matrix::CreateScale(float x, float y, float z)
{
	CreateScale(x, y, z, this);
}

/// gks쐬
void Matrix::CreateScale(const Vector3& kRV)
{
	CreateScale(kRV.mX, kRV.mY, kRV.mZ);
}

/// MEMO:
/// sx  0  0  0
///  0 sy  0  0
///  0  0  1  0
///  0  0  0  1
/// UV̊gks쐬
void Matrix::CreateScaleUV(float sx, float sy)
{
	// Pʉ
	Identity();

	// lݒ
	m11 = sx;
	m22 = sy;
}

/// UV̊gks쐬
void Matrix::CreateScaleUV(const Vector2& kRScale)
{
	CreateScaleUV(kRScale.mX, kRScale.mY);
}


/// X]s쐬
void Matrix::CreateRotationX(float radian)
{
	CreateRotationX(radian, this);
}

/// Y]s쐬
void Matrix::CreateRotationY(float radian)
{
	CreateRotationY(radian, this);
}

/// Z]s쐬
void Matrix::CreateRotationZ(float radian)
{
	CreateRotationZ(radian, this);
}

/// ]s쐬
void Matrix::CreateRotationZXY(float radianX, float radianY, float radianZ)
{
	CreateRotationZXY(radianX, radianY, radianZ, this);
}

/// ]s쐬
void Matrix::CreateRotationZXY(const Vector3& kRV)
{
	CreateRotationZXY(kRV.mX, kRV.mY, kRV.mZ);
}

/// Cӎ]s쐬
void Matrix::CreateRotationAxis(const Vector3& kRAxis, float radian)
{
	CreateRotationAxis(kRAxis, radian, this);
}


/// MEMO:
///  cos  sin  0  0
/// -sin  cos  0  0
///   0    0   1  0
///   0    0   0  1
/// UV̉]s쐬
void Matrix::CreateRotationUV(float radian)
{
	CreateRotationUV(radian, this);
}


/// X]s
void Matrix::RotateX(float radian)
{
	// X]s쐬
	Matrix rotMatX;
	rotMatX.CreateRotationX(radian);

	// ]
	(*this) *= rotMatX;
}

/// Y]s
void Matrix::RotateY(float radian)
{
	// Y]s쐬
	Matrix rotMatY;
	rotMatY.CreateRotationY(radian);

	// ]
	(*this) *= rotMatY;
}

/// Z]s
void Matrix::RotateZ(float radian)
{
	// Z]s쐬
	Matrix rotMatZ;
	rotMatZ.CreateRotationZ(radian);

	// ]
	(*this) *= rotMatZ;
}


/// MEMO:WnłB
/// 1 0 0 0
/// 0 1 0 0
/// 0 0 1 0
/// x y z 1
/// ړs쐬
void Matrix::CreateTranslate(float x, float y, float z)
{
	CreateTranslate(x, y, z, this);
}

/// ړs쐬
void Matrix::CreateTranslate(const Vector3& kRV)
{
	CreateTranslate(kRV.mX, kRV.mY, kRV.mZ);
}

/// MEMO:
/// 1 0 0 0
/// 0 1 0 0
/// x y 1 0
/// 0 0 0 1
/// UV̈ړs쐬
void Matrix::CreateTranslateUV(float x, float y)
{
	// Pʉ
	Identity();

	// lݒ
	m31 = x;
	m32 = y;
}

/// UV̈ړs쐬
void Matrix::CreateTranslateUV(const Vector2& kRV2)
{
	CreateTranslateUV(kRV2.mX, kRV2.mY);
}


/// ړs
void Matrix::Translate(float x, float y, float z)
{
	// ړs쐬
	Matrix transMat;
	transMat.CreateTranslate(x, y, z);

	// ړ
	(*this) *= transMat;
}

/// ړs
void Matrix::Translate(const Vector3& kRV)
{
	CreateTranslate(kRV.mX, kRV.mY, kRV.mZ);
}

/// s]u
void Matrix::Transpose()
{
	Transpose(*this, this);
}

/// ts
void Matrix::Inverse()
{
	Inverse(*this, this);
}


/// Wñr[s쐬
void Matrix::CreateViewLH(const Vector3& eyePosition, const Vector3& targetPosition, const Vector3& upUnit)
{
	/// Pʉ
	Identity();

	Vector3 zAxis = Vector3::Normalize(targetPosition - eyePosition);
	Vector3 xAxis = Vector3::Normalize(Vector3::Cross(upUnit, zAxis));
	Vector3 yAxis = Vector3::Cross(zAxis, xAxis);

	const float k11 = xAxis.mX;
	const float k12 = yAxis.mX;
	const float k13 = zAxis.mX;
	const float k21 = xAxis.mY;
	const float k22 = yAxis.mY;
	const float k23 = zAxis.mY;
	const float k31 = xAxis.mZ;
	const float k32 = yAxis.mZ;
	const float k33 = zAxis.mZ;
	const float k41 = -Vector3::Dot(xAxis, eyePosition);
	const float k42 = -Vector3::Dot(yAxis, eyePosition);
	const float k43 = -Vector3::Dot(zAxis, eyePosition);
	
	m11 = k11;
	m12 = k12;
	m13 = k13;
	m21 = k21;
	m22 = k22;
	m23 = k23;
	m31 = k31;
	m32 = k32;
	m33 = k33;
	m41 = k41;
	m42 = k42;
	m43 = k43;
}


/// w    0    0              0
/// 0    h    0              0
/// 0    0    zf/(zf-zn)     1
/// 0    0    -zn*zf/(zf-zn)  0

/// ˉes쐬
void Matrix::CreateParsepectiveFovLH(float fovy, float aspectRatio, float zNear, float zFar)
{
	// MEMO:cot(fovy * 0.5)
	// pY[Zo
	double s = 1 / tan(static_cast<double>(fovy) * 0.5f);
	float sf = static_cast<float>(s);

	// lݒ
	const float k11 = sf / aspectRatio;
	const float k22 = sf;
	const float k33 = zFar / (zFar - zNear);
	const float k34 = 1;
	const float k43 = -zNear * k33;
	const float k44 = 0;

	Identity();
	m11 = k11;
	m22 = k22;
	m33 = k33;
	m34 = k34;
	m43 = k43;
	m44 = k44;
}

/// MEMO:
/// 2/w  0    0           0
/// 0    2/h  0           0
/// 0    0    1/(zf-zn)   0
/// 0    0    zn/(zn-zf)  1
/// ˉes쐬
void Matrix::CreateOrthoGraphicLH(float width, float height, float zNear, float zFar)
{
	// Pʉ
	Identity();

	// l
	const float k11 = 2.0f / width;
	const float k22 = 2.0f / height;
	const float k33 = 1.0f / (zFar - zNear);
	const float k43 = zNear / (zNear - zFar);

	m11 = k11;
	m22 = k22;
	m33 = k33;
	m43 = k43;
}

/// MEMO:
/// 2/(r-l)      0            0           0
/// 0            2/(t-b)      0           0
/// 0            0            1/(zf-zn)   0
/// (l+r)/(l-r)  (t+b)/(b-t)  zn/(zn-zf)  1
/// WñJX^}CYˉes쐬
void Matrix::CreateOrthoGraphicOffCenterLH(float l, float r, float b, float t, float zn, float zf)
{
	// Pʉ
	Identity();

	// lp
	const float k11 = 2 / (r - l);
	const float k22 = 2 / (t - b);
	const float k33 = 1 / (zf - zn);
	const float k41 = (l + r) / (l - r);
	const float k42 = (t + b) / (b - t);
	const float k43 = zn / (zn - zf);

	// l
	m11 = k11;
	m22 = k22;
	m33 = k33;
	m41 = k41;
	m42 = k42;
	m43 = k43;
}


/// MEMO:
/// w/2   0   0  0
/// 0   -h/2  0  0
/// 0     0   1  0
/// w/2  h/2  0  1
/// r[|[gϊs쐬
void Matrix::CreateViewport(float width, float height)
{
	// Pʉ
	Identity();

	// lp
	const float kHalfWidth = width * 0.5f;
	const float kHalfHeight = height * 0.5f;

	// l
	m11 = kHalfWidth;
	m22 = -kHalfHeight;
	m41 = kHalfWidth;
	m42 = kHalfHeight;
}


//====================================================================================================
// Overload
//----------------------------------------------------------------------------------------------------

/// *ɂs񉉎Z\
Matrix Matrix::operator* (const Matrix& kRM) const
{
	Matrix mat;
	mat.Identity();

	// 񐔂Ń[v
	for (int i = 0; i < mStKColumnCount; ++i)
	{
		// sŃ[v
		for (int j = 0; j < mStKRowCount; ++j)
		{
			mat.m[i][j] = CalculateMultiplyRowColumn(kRM, i, j);
		}
	}

	return mat;
}

/// *=
void Matrix::operator*= (const Matrix& kRM)
{
	(*this) = (*this) * kRM;
}


/// /ɂ鏜Z\
Matrix Matrix::operator/ (float value) const
{
	Matrix copy = (*this);

	// Svf𑖍
	for (int i = 0; i < mStKRowCount; ++i)
	{
		for (int j = 0; j < mStKColumnCount; ++j)
		{
			// Z
			copy.m[i][j] /= value;
		}
	}

	return copy;
}

/// /~ɂ鏜Z\
void Matrix::operator/= (float value)
{
	// Svf𑖍
	for (int i = 0; i < mStKRowCount; ++i)
	{
		for (int j = 0; j < mStKColumnCount; ++j)
		{
			// MEMO:̒l𒼐ڏ܂B
			// Z
			m[i][j] /= value;
		}
	}
}


#if _DEBUG

//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// \
void Matrix::DebugRender(int x, int y) const
{
	// s
	const int kRowSpacing = 10;

	// 
	const int kColumnSpacing = 70;
	
	// sŃ[v
	for (int i = 0; i < mStKRowCount; ++i)
	{
		// 񐔂Ń[v
		for (int j = 0; j < mStKColumnCount; ++j)
		{
			// ʒuZo
			int posX = x + kColumnSpacing * j;
			int posY = y + kRowSpacing * i;

			// l擾
			const float kValue = m[i][j];

			// \
			DP(posX, posY, 0xffffffff, _T("% f"), kValue);
		}
	}
}

#endif // _DEBUG


//====================================================================================================
// PrivateStatic
//----------------------------------------------------------------------------------------------------

/// sincos̒l擾
void Matrix::GetSinAndCos(float* pOutSin, float* pOutCos, float radian)
{
	// MEMO:xdoubleŎZoAfloatɃLXg܂B

	// sin̒l擾
	double s = sin(radian);
	float sf = static_cast<float>(s);
	*pOutSin = sf;

	// cos̒l擾
	double c = cos(radian);
	float cf = static_cast<float>(c);
	*pOutCos = cf;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// sƈ̏ZvZ
float Matrix::CalculateMultiplyRowColumn(const Matrix& kRMatrix, int rowNumber, int columnNumber) const
{
	float outValue = 0;

	// vZ񐔂̐Ń[v
	const int kCount = 4;
	for (int i = 0; i < kCount; ++i)
	{
		outValue += m[rowNumber][i] * kRMatrix.m[i][columnNumber];
	}

	return outValue;
}