#include "Blast/Graphic/MaterialFbx.h"

#include "Blast/String/StringHelper.h"

using namespace fbxsdk_2012_2;
using namespace Blast::Graphic;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	// Get specific property value and connected texture if any.
	// Value = Property value * Factor property value (if no factor property, multiply by 1).
	/// w肵vpeB̒l擾܂BΉĂeNX`΂擾܂B
	/// ĺAvf̒lZlɂȂ܂Bvf̒lꍇ1ŏẐŉe͂܂B
	fbxDouble3 GetMaterialProperty(
		const KFbxSurfaceMaterial* pMaterial,
		const char* pPropertyName,
		const char* pFactorPropertyName,
		tstring* pTextureName)
	{
		fbxDouble3 lResult(0, 0, 0);

		// vpeB擾
		const KFbxProperty kProperty = pMaterial->FindProperty(pPropertyName);
		const KFbxProperty kFactorProperty = pMaterial->FindProperty(pFactorPropertyName);
		if (kProperty.IsValid() && kFactorProperty.IsValid())
		{
			lResult = KFbxGet<fbxDouble3>(kProperty);
			double lFactor = KFbxGet<double>(kFactorProperty);
			if (lFactor != 1)
			{
				lResult[0] *= lFactor;
				lResult[1] *= lFactor;
				lResult[2] *= lFactor;
			}
		}

		// eNX`Ȃ擾
		if (kProperty.IsValid())
		{
			const int kTextureCount = kProperty.GetSrcObjectCount(KFbxFileTexture::ClassId);
			if (0 < kTextureCount)
			{
				const KFbxFileTexture* kPTexture = kProperty.GetSrcObject(FBX_TYPE(KFbxFileTexture), 0);
				if (kPTexture)
				{
					// FBX擾l̂܂܂ŕێB
					*pTextureName = StringHelper::ToWideChar(kPTexture->GetRelativeFileName());
				}
			}
		}

		return lResult;
	}
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MaterialFbx::MaterialFbx()
{
}

/// fXgN^
MaterialFbx::~MaterialFbx()
{
}


/// 
void MaterialFbx::Initialize(const KFbxSurfaceMaterial* pMaterial)
{
	// G~bVȕLbV
    const fbxDouble3 kEmissive = GetMaterialProperty(
		pMaterial,
        KFbxSurfaceMaterial::sEmissive,
		KFbxSurfaceMaterial::sEmissiveFactor,
		&mEmissive.mTextureNameStr);
	for (int i = 0; i < Color::mStKColorFactorNoAlphaCount; ++i)
	{
		mEmissive.mColor[i] = static_cast<float>(kEmissive[i]);
	}

	// ArGg̏LbV
    const fbxDouble3 kAmbient = GetMaterialProperty(
		pMaterial,
        KFbxSurfaceMaterial::sAmbient,
		KFbxSurfaceMaterial::sAmbientFactor,
		&mAmbient.mTextureNameStr);
	for (int i = 0; i < Color::mStKColorFactorNoAlphaCount; ++i)
	{
		mAmbient.mColor[i] = static_cast<float>(kAmbient[i]);
	}

	// fBt[Y̏LbV
    const fbxDouble3 kDiffuse = GetMaterialProperty(
		pMaterial,
        KFbxSurfaceMaterial::sDiffuse,
		KFbxSurfaceMaterial::sDiffuseFactor,
		&mDiffuse.mTextureNameStr);
	for (int i = 0; i < Color::mStKColorFactorNoAlphaCount; ++i)
	{
		mDiffuse.mColor[i] = static_cast<float>(kDiffuse[i]);
	}

	// XyL
    const fbxDouble3 kSpecular = GetMaterialProperty(
		pMaterial,
        KFbxSurfaceMaterial::sSpecular,
		KFbxSurfaceMaterial::sSpecularFactor,
		&mSpecular.mTextureNameStr);
	for (int i = 0; i < Color::mStKColorFactorNoAlphaCount; ++i)
	{
		mSpecular.mColor[i] = static_cast<float>(kSpecular[i]);
	}

	// VClX̏LbV
    KFbxProperty shininessProperty = pMaterial->FindProperty(KFbxSurfaceMaterial::sShininess);
    if (shininessProperty.IsValid())
    {
        double shininess = 0;
        shininess = shininessProperty.Get(&shininess);
        mShinness = static_cast<float>(shininess);
    }
}

