#include "Blast/Graphic/DirectX9/Line3DDX9.h"

#include "Blast/Base/DirectX9/GraphicsDeviceDX9.h"
#include "Blast/Graphic/VertexElementType.h"
#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

	/* vpeB */

	/// RXgN^
	Line3DDX9::SLine3DDX9Property::SLine3DDX9Property()
	{
		// 
		Initialize();
	}

	/// 
	void Line3DDX9::SLine3DDX9Property::Initialize()
	{
		// F
		mColor = 0xffffffff;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Line3DDX9::Line3DDX9()
{
	// _obt@쐬
	mPVertexBuffer.SetPointer(NEW VertexBufferDX9());


	// _`쐬
	VertexElementFactoryDX9 vertexElementFactory;
	D3DVERTEXELEMENT9 elements[] =
	{
		vertexElementFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
		vertexElementFactory.CreateElement(VertexElementType::eELEMENT_END),
	};

	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	mPVertexDeclaration->CreateDeclaration(elements);


	// VF[_[GtFNgǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShaderEffect = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_LINE_3D));

	mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_CONSTANT);
}

/// fXgN^
Line3DDX9::~Line3DDX9()
{
}


/// XV
void Line3DDX9::Update(float delta)
{
}

/// `
void Line3DDX9::Render(Vector3* pPoints, int count)
{
	// ASSERT:_̐2ȏłȂƎ
	ASSERT_PRINTF(2 <= count, _T("_̐2ȏłKv܂B"));

	// _̐2ȏłȂȂ
	if (count < 2)
	{
		return;
	}


	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	// o[ebNXobt@ɒ_f[^ݒ
	mPVertexBuffer->SetVertices(pPoints, count, sizeof(Vector3) * count);

	// o[ebNXXg[ݒ
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, mPVertexBuffer->GetBuffer(), 0, mPVertexBuffer->GetStride());

	
	// VF[_[ϐɃ[hϊsݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &MathHelperDX::ToD3DXMATRIX(mWorldMatrix));

	// VF[_[ϐɃr[sݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetViewMatrixRef()));

	// VF[_[ϐɎˉesݒ
	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &MathHelperDX::ToD3DXMATRIX(mPCamera->GetProjectionMatrixRef()));


	// VF[_[ϐɐFݒ
	mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, mSProperty.mColor.GetArray(), mSProperty.mColor.mStKColorFactorCount);


	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());


	// VF[_[eNjbNݒ
	mPShaderEffect->SetTechnique(ShaderEffectDX9::eTECHNIQUE_CONSTANT);


	// `Jn
	unsigned passCount = 0;
	mPShaderEffect->Begin(&passCount, 0);
	{
		// pX̐Ń[v
		for (unsigned i = 0; i < passCount; ++i)
		{
			// `pXJn
			mPShaderEffect->BeginPass(i);
			{
				// MEMO:_̐2ȏł邱ƂK{łB
				// `
				HRESULT hr = pDevice->DrawPrimitive(
					D3DPT_LINESTRIP,
					0,
					count - 1
					);
			}
			mPShaderEffect->EndPass();
		}
	}
	mPShaderEffect->End();
}


/// Jݒ
void Line3DDX9::SetCamera(SP<ICamera> pCamera)
{
	mPCamera = pCamera;
}