#include "Blast/Input/InputManager.h"

#include "Blast/Input/IMouse.h"
#include "Blast/Input/IKeyboard.h"
#include "Blast/Input/IJoystick.h"

using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
InputManager::InputManager()
{
	Initialize();
}

/// fXgN^
InputManager::~InputManager()
{
	Release();
}

/// XV
void InputManager::Update(float delta)
{
	// }EXLȂ
	if (mPMouse)
	{
		mPMouse->Update(delta);
	}

	// L[{[hLȂ
	if (mPKeyboard)
	{
		mPKeyboard->Update(delta);
	}

	// WCXeBbNLȂ
	if (mPJoystick)
	{
		mPJoystick->Update(delta);
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// 
void InputManager::Initialize()
{
	mPMouse = NULL;
	mPKeyboard = NULL;
	mPJoystick = NULL;
}

/// ͏SNX
void InputManager::Release()
{
	SAFE_DELETE(mPMouse);
	SAFE_DELETE(mPKeyboard);
	SAFE_DELETE(mPJoystick);
}