#include "Blast/Utility/Halt.h"

#include <stdio.h>
#include <windows.h>
#include <tchar.h>
#include <CRTDBG.h>

using namespace Blast::Utility;



//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// tH[}bg
const TCHAR* Halt::mStKPFormat =
	_T("\n")
	_T("----------------------------------------------------------------------------------------------------\n")
	_T("[HALT]\n")
	_T("%s(%d)\n")
	_T("%s\n")
	_T("----------------------------------------------------------------------------------------------------\n")
	_T("\n")
	;

/// halts
void Halt::Execute(const TCHAR* kPFullPath, int line, const TCHAR* kPFormat, ...)
{
	// ψztH[}bgwqɉĕϊ
	TCHAR pszBuffer[mStKStringsBufferSize];
	ZeroMemory(pszBuffer, mStKStringsBufferSize);

	va_list	argp;

	va_start(argp, kPFormat);
	_vstprintf_s(pszBuffer, kPFormat, argp);
	va_end(argp);

	// o͕ɕϊ
	TCHAR text[mStKStringsBufferSize];
	ZeroMemory(text, mStKStringsBufferSize);

	_stprintf_s(text, mStKPFormat, kPFullPath, line, pszBuffer);

	// o
	OutputDebugString(text);

	/*	MEMO:
	*	\`ႤƂƁAIɂĂ͋IA邢͑sȂ̂AssertƂ܂ςȂƂA
	*	Ƃ肠uI̗]nAssertv̂悤Ȏg邽߁A|[g̕\̓RgAEgĂ܂B
	*/

	//	// |[g\
//#if _UNICODE
//	_CrtDbgReportW(_CRT_WARN, _T(__FILE__), __LINE__, _T("BlastLibrary"), text);
//#else
//	_CrtDbgReport(_CRT_ERROR, __FILE__, __LINE__, _T("BlastLibrary"), kPFormat,text);
//#endif
	
	// Iɏꎞ~܂
	_CrtDbgBreak();

	// S~
	exit(EXIT_FAILURE);
}