#include "Blast/Graphic/DirectX9/GridDX9.h"

using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
GridDX9::GridDX9()
	: mPMesh(NEW MeshGridDX9())
	, mPShader(NEW ShaderEffectDX9())
{
	// pVF[_[Ȃ̂ŊO킸ɎōĂ܂
	mPShader->Load(ShaderEffectDX9::eSHADEREFFECT_GRID_3D);
}

/// fXgN^
GridDX9::~GridDX9()
{
}

/// 쐬
void GridDX9::Create(float size, float interval)
{
	// bV쐬
	mPMesh->Create(size, interval);
}

/// XV
void GridDX9::Update(float delta)
{
}

/// `
void GridDX9::Render()
{
	// bV`
	ASSERT_PF(mPMesh, _T("bVǂݍ܂Ă܂B"));
	if (!mPMesh)
	{
		return;
	}

	// J͐ݒ肳ĂKv
	ASSERT_PF(mPCamera, _T("Jݒ肳Ă܂"));
	if (!mPCamera)
	{
		return;
	}
	
	// r[sݒ
	mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &mPCamera->GetViewMatrixRef());

	// ˉesݒ
	mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &mPCamera->GetProjectionMatrixRef());

	// `Jn
	unsigned passCount = 0;
	mPShader->Begin(&passCount);
	{
		for (int i = 0; i < static_cast<int>(passCount); ++i)
		{
			mPShader->BeginPass(i);
			{
				mPMesh->Render();
			}
			mPShader->EndPass();
		}
	}
	mPShader->End();
}