#include "Blast/Graphic/DirectX9/Grid2DDX9.h"

#include "Blast/Graphic/DirectX9/Line2DDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------


	/* vpeB */


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	Grid2DDX9::SProperty::SProperty()
	{
		// 
		Initialize();
	}

	/// 
	void Grid2DDX9::SProperty::Initialize()
	{
		mColumnCount = 2;
		mRowCount = 2;
		mColor = 0xaaffffff;

		mIsCenterVisible = true;
		mCenterColor = 0xaaffff00;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Grid2DDX9::Grid2DDX9()
{
	// 
	Initialize();
}

/// fXgN^
Grid2DDX9::~Grid2DDX9()
{
}

/// 
void Grid2DDX9::Initialize()
{
	// vpeB
	mSProperty.Initialize();
}

/// `
void Grid2DDX9::Render()
{
	// MEMO:ǂŐݒ肵̂擾łƃx^[ł傤
	// NCAgTCY擾
	const int kCliantWidth = 1024;
	const int kCliantHeight = 768;

	// 1񕪂̕Zo
	float oneWidth = kCliantWidth / static_cast<float>(mSProperty.mColumnCount);

	// 1s̕Zo
	float oneHeight = kCliantHeight / static_cast<float>(mSProperty.mRowCount);


	// A`GCAX𖳌
	mLine2D.GetLine2DDX9PropertyRef().mIsAntialias = false;

	// ݒ
	mLine2D.GetLine2DDX9PropertyRef().mWidth = 1;

	// Fݒ
	mLine2D.GetLine2DDX9PropertyRef().mColor = mSProperty.mColor;

	// ̐0ȏȂ
	if (0 < mSProperty.mColumnCount)
	{
		// MEMO:A؎Z̈-1܂B
		// ̐Ń[v
		for (int i = 0; i < mSProperty.mColumnCount - 1; ++i)
		{
			// XẄʒu
			float x = oneWidth * (i + 1);

			// YW̏[Ɖ[̈ʒu
			const float kTop = 0;
			const float kBottom = kCliantHeight;


			// _p
			const int kPointCount = 2;
			Vector2 points[kPointCount] =
			{
				Vector2(x, kTop),
				Vector2(x, kBottom),
			};

			// `
			mLine2D.Render(points, kPointCount);
		}
	}

	// s̐0ȏȂ
	if (0 < mSProperty.mRowCount)
	{
		// MEMO:A؎Z̈-1܂B
		// s̐Ń[v
		for (int i = 0; i < mSProperty.mRowCount - 1; ++i)
		{
			// XW̍[ƉE[̈ʒu
			const float kLeft = 0;
			const float kRight = kCliantWidth;

			// YẄʒu
			float y = oneHeight * (i + 1);


			// _p
			const int kPointCount = 2;
			Vector2 points[kPointCount] =
			{
				Vector2(kLeft, y),
				Vector2(kRight, y),
			};

			// `
			mLine2D.Render(points, kPointCount);
		}
	}
	

	// S\`
	RenderXCenter();
}


/// sݒ
void Grid2DDX9::SetRowCount(unsigned count)
{
	mSProperty.mRowCount = count;
}

/// 񐔂ݒ
void Grid2DDX9::SetColumnCount(unsigned count)
{
	mSProperty.mColumnCount = count;
}

/// Fݒ
void Grid2DDX9::SetColor(const Color& kRColor)
{
	mSProperty.mColor = kRColor;
}

/// S\邩ǂݒ
void Grid2DDX9::SetIsCenterVisible(bool isVisible)
{
	mSProperty.mIsCenterVisible = isVisible;
}

/// S̐Fݒ
void Grid2DDX9::SetCenterColor(const Color& kRColor)
{
	mSProperty.mCenterColor = kRColor;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// S`
void Grid2DDX9::RenderXCenter()
{
	// S\ȂȂ
	if (!mSProperty.mIsCenterVisible)
	{
		return;
	}


	// MEMO:ǂŐݒ肵̂擾łƃx^[ł傤
	// NCAgTCY擾
	const float kCliantWidth = 1024.0f;
	const float kCliantHeight = 768.0f;

	// ̐
	const int kLineCount = 2;

	// U
	Vector2 verticalPoints[] =
	{
		Vector2(kCliantWidth, 0),
		Vector2(0, kCliantHeight),
	};

	// tU
	Vector2 horizonPoints[] =
	{
		Vector2(0, 0),
		Vector2(kCliantWidth, kCliantHeight),
	};


	// MEMO:΂߂ɐ̂ŗLYłB
	// A`GCAXL
	mLine2D.GetLine2DDX9PropertyRef().mIsAntialias = true;

	// ݒ
	mLine2D.GetLine2DDX9PropertyRef().mWidth = 0.5f;

	// Fݒ
	mLine2D.GetLine2DDX9PropertyRef().mColor = mSProperty.mCenterColor;

	// `
	mLine2D.Render(horizonPoints, kLineCount);

	// `
	mLine2D.Render(verticalPoints, kLineCount);

}