#include "Blast/Base/GameComponentContainer.h"

#include "Blast/Base/GameComponent.h"
#include "Blast/Base/RenderableGameComponent.h"

using namespace Blast::Base;


//====================================================================================================
// Predicate
//----------------------------------------------------------------------------------------------------

/// XVԏ̃vfBP[g
bool GameComponentContainer::AscendingUpdateOrder::operator() (const SP<IUpdatable>& kRA, const SP<IUpdatable>& kRB) const
{
	return (kRA->GetUpdateOrder() < kRB->GetUpdateOrder());
};

/// `揇ԏ̃vfBP[g
bool GameComponentContainer::AscendingRenderOrder::operator() (const SP<IRenderable>& kRA, const SP<IRenderable>& kRB) const
{
	return (kRA->GetRenderOrder() < kRB->GetRenderOrder());
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
GameComponentContainer::GameComponentContainer()
{
}

/// fXgN^
GameComponentContainer::~GameComponentContainer()
{
}

/// XV
void GameComponentContainer::Update(float delta)
{
	// XVXg̗vfŃ[v
	UpdatableList::iterator it;
	for (it = mUpdatableList.begin(); it != mUpdatableList.end(); ++it)
	{
		// XVȂ
		if ((*it)->IsEnable())
		{
			// MEMO:p̃\bhĂ΂܂B
			(*it)->Update(delta);
		}
	}
}

/// `
void GameComponentContainer::Render()
{
	// `惊Xg̗vfŃ[v
	RenderableList::iterator it;
	for (it = mRenderableList.begin(); it != mRenderableList.end(); ++it)
	{
		// `悷Ȃ
		if ((*it)->IsVisible())
		{
			// `
			(*it)->Render();
		}
	}
}


/// Q[R|[lgǉ
void GameComponentContainer::Add(SP<IGameComponent> pGameComponent)
{
	Add(pGameComponent, SP<GameComponentContainer>(NULL));
}

/// Q[R|[lgǉ
void GameComponentContainer::Add(SP<IGameComponent> pGameComponent, SP<GameComponentContainer> pContainer)
{
	// 
	pGameComponent->Initialize();


	// GameComponentɃLXg
	SP<GameComponent> pGC;
	pGC.DownCast(pGameComponent);
	if (pGC)
	{
		// Reiݒ
		pGC->SetContainer(pContainer);


		// XVXgɒǉ
		mUpdatableList.push_back(pGC);

		// XVXgXV
		UpdateUpdatableList();
	}

	// RenderableGameComponentɃLXg
	SP<RenderableGameComponent> pRGC;
	pRGC.DownCast(pGameComponent);
	if (pRGC)
	{
		// `惊Xgɒǉ
		mRenderableList.push_back(pRGC);

		// `惊XgXV
		UpdateRenderableList();
	}
}

/// Q[R|[lgO
void GameComponentContainer::Remove(SP<IGameComponent> pGameComponent)
{
	// GameComponentɃLXg
	SP<GameComponent> pGC;
	pGC.DownCast(pGameComponent);
	if (pGC)
	{
		// O
		mUpdatableList.remove(pGC);
	}

	// RenderableGameComponentɃLXg
	SP<RenderableGameComponent> pRGC;
	pRGC.DownCast(pGameComponent);
	if (pRGC)
	{
		// O
		mRenderableList.remove(pRGC);
	}
}

/// Q[R|[lgNA
void GameComponentContainer::Clear()
{
	mUpdatableList.clear();
	mRenderableList.clear();
}


/// XVXgXV
void GameComponentContainer::UpdateUpdatableList()
{
	// XV̏Ń\[g
	mUpdatableList.sort(AscendingUpdateOrder());
}

/// `惊XgXV
void GameComponentContainer::UpdateRenderableList()
{
	// `揇̏Ń\[g
	mRenderableList.sort(AscendingRenderOrder());
}