#include "Blast/Base/FrameParSecondFixation.h"

#include "Blast/Base/DebugManager.h"

using namespace Blast::Base;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/*  */

	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	FrameParSecondFixation::SProperty::SProperty()
	{
		Initialize();
	}

	/// 
	void FrameParSecondFixation::SProperty::Initialize()
	{
		mFramerate = 0;
		mMillSPF = 0;
		mCurrentCounter = 0;
		mWaitMillTime = 0;
		mLastCounter = 0;
		mFrequency = 0;
		mIsAllowedFrame = false;

		// g
		InitializeFrequency();
	}

	/// XV
	void FrameParSecondFixation::SProperty::Update()
	{
		/// ݂̃JE^擾
		mCurrentCounter = GetCurrentCounter();
		
		// Ԃ擾
		double millDif = GetMillDifferenceTimeFromLast();

		// ڕWԂ𒴂Ȃ
		if (mWaitMillTime <= millDif)
		{
			// \ȃt[ǂ̃tO𗧂Ă
			mIsAllowedFrame = true;

			// ̖ڕWԂݒ
			SetWaitTime();
		}
		// ڕWԂ𒴂ĂȂȂ
		else
		{
			// \ȃt[ǂ̃tO~낷
			mIsAllowedFrame = false;
		}
	}

#ifdef _DEBUG

	/// p[^[`
	void FrameParSecondFixation::SProperty::DebugRender(int x, int y)
	{
		int posX = 0;
		int posY = 0;
		int lineIndex = 0;
		int lineSpacing = 13;

		// FPS
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("Framerate:%d"), mFramerate);
		
		// SPF
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("SPF:%lf[ms]"), mMillSPF);

		// ݂̃JE^
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("݂̃JE^:%llu"), mCurrentCounter);
		
		// ŌɍXṼJE^
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("ŌɍXṼJE^:%llu"), mLastCounter);

		// Ot[Ƃ̍
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("Ot[Ƃ̍:%llu"), mCurrentCounter - mLastCounter);

		// ҋ@
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("ҋ@:%lf[ms]"), mWaitMillTime);

		// NbNg
		posY = y + lineSpacing * lineIndex++;
		DP(posX, posY, 0xffffffff, _T("NbNg:%llu"), mFrequency);
	}

#endif // _DEBUG

	//====================================================================================================
	// PrivateOperation
	//----------------------------------------------------------------------------------------------------

	// g
	void FrameParSecondFixation::SProperty::InitializeFrequency()
	{
		// g擾
		LARGE_INTEGER sLI;
		BOOL isEnable = QueryPerformanceFrequency(&sLI);

		// ێ
		mFrequency = static_cast<u64>(sLI.QuadPart);
	}

	/// ݂̃JE^擾
	u64 FrameParSecondFixation::SProperty::GetCurrentCounter() const
	{
		// ݂̃ptH[}XJE^擾
		LARGE_INTEGER sLI;
		BOOL isEnable = QueryPerformanceCounter(&sLI);

		return static_cast<u64>(sLI.QuadPart);
	}

	/// Ԃ擾
	double FrameParSecondFixation::SProperty::GetMillDifferenceTimeFromLast()
	{
		// Zo
		u64 sub = mCurrentCounter - mLastCounter;

		// ~bxɏグׂ1000{
		sub *= 1000;

		// ~bɕϊ
		double dFrequency = static_cast<double>(mFrequency);
		double millDif = sub / dFrequency;

		return millDif;
	}

	/// ̑ҋ@Ԃݒ
	void FrameParSecondFixation::SProperty::SetWaitTime()
	{
		// Ԃ擾
		double millDif = GetMillDifferenceTimeFromLast();

		// ҋ@ԂZo
		mWaitMillTime = mMillSPF - (millDif - mWaitMillTime);

		// ҋ@Ԃ0Ȃ0ɃNv
		if (mWaitMillTime < 0)
		{
			mWaitMillTime = 0;
		}

		// ݂̎ԂŌɍXVԂɐݒ
		mLastCounter = mCurrentCounter;
	}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FrameParSecondFixation::FrameParSecondFixation() :
mSProperty()
{
	// FPSݒ
	SetFPS(mStKInitialFPS);
}

/// fXgN^
FrameParSecondFixation::~FrameParSecondFixation()
{
}

/// XV
void FrameParSecondFixation::Update()
{
	/// vpeBXV
	mSProperty.Update();
}

/// Ԃ擾
double FrameParSecondFixation::GetDeltaTime() const
{
	// MEMO:ŒȂ̂ňꗥłB
	double spf = mSProperty.mMillSPF * 0.001;

	return spf;
}

/// FPSݒ
void FrameParSecondFixation::SetFPS(int fps)
{
	// FPSێ
	mSProperty.mFramerate = fps;

	// SPFێ
	double spf = 1.0f / fps;
	mSProperty.mMillSPF = spf * 1000;
}

/// \ȃt[ǂ擾
bool FrameParSecondFixation::IsAllowedFrame()
{
	return mSProperty.mIsAllowedFrame;
}

/// 
void FrameParSecondFixation::Initialize()
{
	// vpeB
	mSProperty.Initialize();
}


#ifdef _DEBUG
//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

/// `
void FrameParSecondFixation::DebugRender(int x, int y)
{
	// vpeB̏`
	mSProperty.DebugRender(x, y);
}
#endif // _DEBUG