#include "Blast/String/FormattingHelper.h"

using namespace Blast::Utility;
using namespace Blast::String;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// tH[}bgwqQ
const TCHAR* FormattingHelper::mStKFormatStrings[] =
{
	_T("d"),
	_T("u"),
	_T("f"),
	_T("lf"),
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// tH[}bgwq̕擾
const TCHAR* FormattingHelper::ToFormatString(EVariableType eVariableType)
{
	// ASSERT:CfbNX͈͊OȂ玀
	ASSERT(IsInFormatStringsSize(eVariableType));

	return mStKFormatStrings[eVariableType];
}

/// tH[}bgwq̕擾
template<>
const TCHAR* FormattingHelper::ToFormatString<int>()
{
	return ToFormatString(eVARIABLE_TYPE_INT);
}

/// tH[}bgwq̕擾
template<>
const TCHAR* FormattingHelper::ToFormatString<unsigned>()
{
	return ToFormatString(eVARIABLE_TYPE_UNSIGNED_INT);
}

/// tH[}bgwq̕擾
template<>
const TCHAR* FormattingHelper::ToFormatString<float>()
{
	return ToFormatString(eVARIABLE_TYPE_FLOAT);
}

/// tH[}bgwq̕擾
template<>
const TCHAR* FormattingHelper::ToFormatString<double>()
{
	return ToFormatString(eVARIABLE_TYPE_DOUBLE);
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// CfbNXtH[}bgwqQ̃TCYǂ擾
bool FormattingHelper::IsInFormatStringsSize(int index)
{
	// tH[}bgwq̐擾
	int stringsCount = sizeof(mStKFormatStrings) / sizeof(mStKFormatStrings[0]);

	// ͈͓ǂ
	bool isInSize = (index < stringsCount);

	return isInSize;
}