#include "Blast/String/Formatting.h"

#include "Blast/String/FormattingHelper.h"

using namespace Blast::String;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// tO̕Q
const TCHAR* Formatting::mStKPFlagStrings[] =
{
	_T("-"),
	_T("+"),
	_T(" "),
	_T("#"),
};

/// \L@̕Q
const TCHAR* Formatting::mStKPNotationStrings[] =
{
	_T("o"),
	_T("d"),
	_T("x"),
};


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* vpeB */

/// RXgN^
Formatting::SProperty::SProperty()
{
}

/// 
void Formatting::SProperty::Initialize()
{
	for (int i = 0; i < Formatting::eFLAG_COUNT; ++i)
	{
		mFlags[i] = false;
	}

	mIsZeroReading = false;
	mFieldSize = 0;
	mAccuracy = 0;
	mENotation = Formatting::eNOTATION_DECIMAL;
}

/// tO𗧂Ă
void Formatting::SProperty::FlagUp(EFlag eFlag)
{
	mFlags[eFlag] = true;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Formatting::Formatting() :
mSProperty()
{
	mSProperty.Initialize();
}

/// fXgN^
Formatting::~Formatting()
{
}

/// 
void Formatting::Initialize()
{
	mSProperty.Initialize();
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// tOɑΉ擾
tstring Formatting::GetFlagStr() const
{
	// tO
	tstring flagStr;
	flagStr.clear();

	// tO̐Ń[v
	for (int i = 0; i < eFLAG_COUNT; ++i)
	{
		// tOĂ邩ǂ擾
		bool isFlag = mSProperty.mFlags[i];

		// tOĂȂ
		if (isFlag)
		{
			// Ή擾
			const TCHAR* kPFlagString = mStKPFlagStrings[i];

			// 
			flagStr += kPFlagString;
		}
	}

	return flagStr;
}

/// [[fBÕtOɑΉ擾
const TCHAR* Formatting::GetZeroReadingChars() const
{
	// [߂Ȃ
	if (mSProperty.mIsZeroReading)
	{
		return _T("0");
	}

	return EMPTY_STRING;
}

/// tB[hTCY̐l𕶎ƂĎ擾
void Formatting::GetFieldSizeCharsPtr(TCHAR* pDst, int size) const
{
	// o͕ϐ
	ZeroMemory(pDst, size);

	// tB[hTCY擾
	int fieldSize = mSProperty.mFieldSize;

	// tB[hTCY0傫Ȃ
	if (0 < fieldSize)
	{
		// ɕϊ
		StringHelper::Format(pDst, size, _T("%d"), mSProperty.mFieldSize);
	}
	// tB[hTCY0ȉȂ
	else
	{
		pDst = EMPTY_STRING;
	}
}

/// x_݂̕ƂĂ擾
void Formatting::GetAccuracyWithPointCharsPtr(TCHAR* pDst, int size) const
{
	// o͕ϐ
	ZeroMemory(pDst, size);

	// x擾
	int accuracy = mSProperty.mAccuracy;
	
	// x0傫Ȃ
	if (0 < accuracy)
	{
		// MEMO:_t܂B
		StringHelper::Format(pDst, size, _T(".%d"), mSProperty.mAccuracy);
	}
	// x0ȉȂ
	else
	{
		pDst = EMPTY_STRING;
	}
}

/// tH[}bgwq\L@ɑΉĕϊ
tstring Formatting::ChangeFormatByNotation(const tstring& kRSrcStr) const
{
	tstring outStr;
	outStr.clear();

	// 񋓑̂ɉ\L@̕擾
	const TCHAR* kPNotation = mStKPNotationStrings[mSProperty.mENotation];

	// MEMO:wdxƁwuxΏۂɒus܂B

	// wdxΏۂɕϊ
	outStr = StringHelper::Replace(kRSrcStr, _T("d"), kPNotation);

	// wuxΏۂɕϊ
	outStr = StringHelper::Replace(outStr, _T("u"), kPNotation);

	return outStr;
}