#include "Blast/Graphic/DirectX9/FontDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// ̃tHg
const TCHAR* const FontDX9::stKPFontName = _T("lr SVbN");


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FontDX9::FontDX9()
{
}

/// fXgN^
FontDX9::~FontDX9()
{
}


/// `
void FontDX9::Render()
{
	GraphicsDeviceDX9* pGD = GraphicsDeviceDX9::GetInstance();

	// ]s쐬
	Matrix rotationMat;
	rotationMat.CreateRotationZXY(mRotation);

	// MEMO:LȂ̂͊gkƉ]̂悤łB
	// MEMO:_̓XN[̍̂悤łB
	// [hϊsݒ
	Matrix world;
	world *= rotationMat;

	D3DXMATRIX matWorld = MathHelperDX::ToD3DXMATRIX(world);
	pGD->GetSprite()->SetTransform(&matWorld);

	// `͈͂쐬
	RECT rect;
	rect.left = (s64)mPosition.mX;
	rect.top = (s64)mPosition.mY;

	// XvCg̕`BBeginAEnd͊OsB
	// MEMO:NbsO͕Kvł傤B
	// `
	mPFont->DrawText(
		pGD->GetSprite().GetInterface(),
		mTextStr.c_str(),
		-1,
		&rect,
		DT_LEFT | DT_NOCLIP,
		mColor.GetARGB()
		);
}


/// ̗̈̒擾
int FontDX9::MeasureString(const TCHAR* const kPString) const
{
	// `͈͂󂯎ϐp
	RECT rect;
	rect.left = (s64)mPosition.mX;
	rect.top = (s64)mPosition.mY;

	// ̗̈擾
	GraphicsDeviceDX9* pGD = GraphicsDeviceDX9::GetInstance();
	mPFont->DrawText(
		pGD->GetSprite().GetInterface(),
		kPString,
		-1,
		&rect,
		DT_LEFT | DT_NOCLIP | DT_CALCRECT,
		0xffffffff
		);

	// Zo
	int width = rect.right - rect.left;

	return width;
}


/// tHgf[^쐬
void FontDX9::CreateFontData(const TCHAR* const kPFontName, int size, int weight)
{
	// ϐɕێ
	mFaceNameStr = kPFontName;
	mPointSize = size;
	mWeight = weight;

	// tHg̏쐬
    D3DXFONT_DESC lf;
	ZeroMemory(&lf, sizeof(lf));

	lf.Height = size;
	lf.Width = 0;	//< MEMO:\Width0ݒ肷ƓK؂ȒlɕύX܂B
	lf.Weight = mWeight;
	lf.MipLevels = 1;
	lf.Italic = FALSE;
	lf.CharSet = SHIFTJIS_CHARSET;
	lf.OutputPrecision = OUT_TT_ONLY_PRECIS;
	lf.Quality = PROOF_QUALITY;
	lf.PitchAndFamily = (FIXED_PITCH | FF_MODERN);
	memcpy(lf.FaceName, mFaceNameStr.c_str(), sizeof(lf.FaceName));

	// ɉătHg쐬
	GraphicsDeviceDX9* pGraphicsDeviceDX9 = GraphicsDeviceDX9::GetInstance();
	LPDIRECT3DDEVICE9 pDevice = pGraphicsDeviceDX9->GetDevice();
	HRESULT hr = D3DXCreateFontIndirect(pDevice, &lf, mPFont.ToCreator());
	ASSERT_PRINTF(SUCCEEDED(hr), _T("tHg̍쐬Ɏs܂\n"));
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// tHg擾
const TCHAR* const FontDX9::GetFaceName() const { return mFaceNameStr.c_str(); }

/// |CgTCY擾
int FontDX9::GetPointSize() const { return mPointSize; }

/// EFCg擾
int FontDX9::GetWeight() const { return mWeight; }

/// `悷ʒu擾
const Vector3& FontDX9::GetPosition() const { return mPosition; }
/// `悷ʒuݒ
void FontDX9::SetPosition(const Vector3& kRPosition) { mPosition = kRPosition; }

/// ]l擾
const Vector3& FontDX9::GetRotation() const { return mRotation; }
/// ]lݒ
void FontDX9::SetRotation(const Vector3& kRRotation) { mRotation = kRRotation; }

/// F擾
const Color& FontDX9::GetColor() const { return mColor; }
/// Fݒ
void FontDX9::SetColor(const Color& kRColor) { mColor = kRColor; }

/// `悷镶擾
const TCHAR* const FontDX9::GetText() const { return mTextStr.c_str(); }
/// `悷镶ݒ
void FontDX9::SetText(const TCHAR* const kPText) { mTextStr = kPText; }