#include "Blast/Base/FPSCounter.h"

using namespace Blast::Base;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FPSCounter::FPSCounter(int samplingCount) :
mMillDeltaList(),
mTotalMillDelta(0),
mOldTime(0),
mFrequency(0),
mSamplingCount(0)
{
	// ÂԂƂĈUݎԂ擾
	mOldTime = GetCurrentTime();

	// NbNg擾
	mFrequency = GetFrequency();

	// TvOݒ
	SetSamplingCount(samplingCount);
}

/// fXgN^
FPSCounter::~FPSCounter()
{
}

/// FPS擾
double FPSCounter::GetFPS()
{
	// Ԃ擾
	double delta = GetMillDeltaTime();

	// XV
	double fps = UpdateDeltaList(delta);

	return fps;
}

/// TvOݒ
void FPSCounter::SetSamplingCount(int count)
{
	// ϐɕێ
	mSamplingCount = count;

	// MEMO:TCYύXƓɗvf̒l0ŃZbg܂B
	// ԃXg̃TCYύX
	mMillDeltaList.resize(mSamplingCount, 0);

	// vZbg
	mTotalMillDelta = 0;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// NbNg擾
double FPSCounter::GetFrequency() const
{
	LARGE_INTEGER sLI;
	BOOL isEnable = QueryPerformanceFrequency(&sLI);

	double value = static_cast<double>(sLI.QuadPart);

	return value;
}

/// ݂̎
u64 FPSCounter::GetCurrentTime() const
{
	LARGE_INTEGER sLI;
	BOOL isEnable = QueryPerformanceCounter(&sLI);

	u64 value = static_cast<u64>(sLI.QuadPart);

	return value;
}

/// Ot[Ƃ̍Ԃ擾
double FPSCounter::GetMillDeltaTime()
{
	// ݂̎擾
	u64 currentTime = GetCurrentTime();

	// 擾
	u64 sub = currentTime - mOldTime;

	// double^ɕϊ
	double delta = static_cast<double>(sub);

	// ~bŕ\߂1000{
	double millDelta = delta * 1000;

	// gŏZ
	millDelta /= mFrequency;

	// ̎ێ
	mOldTime = currentTime;

	return millDelta;
}

/// f^XgXV
double FPSCounter::UpdateDeltaList(double delta)
{
	// ŌẪf[^ZAO
	mTotalMillDelta -= *mMillDeltaList.begin();
	mMillDeltaList.pop_front();

	// ŐṼf[^Zǉ
	mTotalMillDelta += delta;
	mMillDeltaList.push_back(delta);

	// FPSZo
	double aveDef = mTotalMillDelta / mSamplingCount;

	// ASSERT:0Ȃ玀
	ASSERT_PRINTF(aveDef != 0, _T("FPS0łB"));

	// 0łȂȂ
	if (aveDef != 0)
	{
		// MEMO:Pʂ~bł邽߁A1000{Ă܂B
		// tZoFPS߂
		double fps = 1.0 * 1000.0 / aveDef;

		return fps;
	}

	return 0;
}
