#include "Blast/Storage/Directory.h"

#include <shlwapi.h>
#include "Blast/String/StringHelper.h"

#pragma comment(lib, "shlwapi.lib")

using namespace Blast::Storage;
using namespace Blast::String;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// ݂̃fBNg܂ł̃pX擾
tstring Directory::GetCurrentDirectoryAbsolutePath()
{
	// ݂̃fBNg܂ł̃pX擾
	TCHAR directoryName[mStKMaxDirectory];
	GetCurrentDirectory(mStKMaxDirectory, directoryName);

	return ReplaceYenToSlash(directoryName);
}


/// ݂̃fBNgύX
void Directory::SetCurrentDirectoryPath(const TCHAR* const kPPath)
{
	_tchdir(kPPath);
}

/// ݂̃fBNgZbg
void Directory::ResetCurrentDirectoryAbsolutePath()
{
	// st@C̐΃pX擾
	tstring exeAbsPath = GetExeAbsolutePath();

	// JgfBNgɐݒ
	SetCurrentDirectoryPath(exeAbsPath.c_str());
}


/// st@C̐΃pX擾
tstring Directory::GetExeAbsolutePath()
{
	// ΃tpX擾
	tstring absFullPath = GetExeAbsoluteFullPath();

	// fBNĝݎ擾
	tstring absPath = GetDirectoryPath(absFullPath.c_str());


#ifdef _DEBUG

	// MEMO:VisualStudioNꍇAʏ̐ݒł͊erhƂɃtH_A̒exet@C܂B
	// MEMO:pX̓vWFNgt@CJn邽߁AɕttH_폜܂B

	// ɁwDebug\\xȂ珜O

	// DebugrhɐfBNg
	const TCHAR* kPDebugDirectorySuffix = _T("Debug/");

	// fBNg̕擾
	const int kPDebugSuffixCount = _tcslen(kPDebugDirectorySuffix);

	// ɕtfBNĝݎ擾
	tstring suffix = absPath.substr(absPath.size() - kPDebugSuffixCount);

	// ̃fBNg"Debug/"Ȃ
	if (suffix == kPDebugDirectorySuffix)
	{
		// O
		absPath.erase(absPath.size() - kPDebugSuffixCount);
	}

#endif _DEBUG

	return ReplaceYenToSlash(absPath.c_str());
}


/// ΃pX΃pXɕϊ
tstring Directory::ToAbsolutePath(const TCHAR* const kPFullPath, TCHAR pOutAbsPath[mStKMaxPath])
{
	// o̓obt@
	TCHAR buffer[mStKMaxPath];
	unsigned bufferSize = sizeof(buffer);
	ZeroMemory(buffer, bufferSize);


	// ΃pX擾
	GetFullPathName(kPFullPath, mStKMaxPath, buffer, NULL);


	// o͕ϐLȂ
	if (pOutAbsPath)
	{
		// 
		unsigned size = sizeof(TCHAR) * mStKMaxPath;
		ZeroMemory(pOutAbsPath, size);
		memcpy(pOutAbsPath, buffer, size);
	}

	// pXf~^XbVɓ
	tstring bufferStr = ReplaceYenToSlash(buffer);


	return bufferStr;
}

/// pXfBNgpX݂̂擾
tstring Directory::GetDirectoryPath(const TCHAR* const kPPath, TCHAR pOutPath[mStKMaxPath])
{
	// hCu
	TCHAR drive[mStKMaxDrive];

	// fBNg
	TCHAR directory[mStKMaxDirectory];

	// pX𕪊擾
	_tsplitpath_s(
		kPPath,
		drive, mStKMaxDrive,
		directory, mStKMaxDirectory,
		NULL, 0,
		NULL, 0);


	// ʂ̃obt@
	TCHAR buffer[mStKMaxPath];

	// A
	_tmakepath_s(
		buffer,
		drive,
		directory,
		NULL,
		NULL);


	// o͕ϐLȂ
	if (pOutPath)
	{
		// 
		memcpy(pOutPath, buffer, mStKMaxPath);
	}


	return buffer;
}

/// tpXt@Ĉ݂擾
tstring Directory::GetFileName(const TCHAR* const kPFullPath, TCHAR pOutFileName[mStKMaxFileName])
{
	// i[ϐ
	TCHAR fileName[mStKMaxFileName];
	TCHAR extentionName[mStKMaxExtention];

	// pX𕪊擾
	_tsplitpath_s(
		kPFullPath,
		NULL, 0,
		NULL, 0,
		fileName, mStKMaxFileName,
		extentionName, mStKMaxExtention);


	// o͕ϐLȂ
	if (pOutFileName)
	{
		// 
		memcpy(pOutFileName, fileName, mStKMaxFileName);
	}


	return fileName;
}


/// tpXgq݂̂擾
tstring Directory::GetExtention(const TCHAR* const kPFullPath, TCHAR pOutExtention[mStKMaxExtention])
{
	// i[ϐ
	TCHAR extentionName[mStKMaxExtention];

	// 擾
	_tsplitpath_s(
		kPFullPath,
		NULL, 0,
		NULL, 0,
		NULL, 0,
		extentionName, mStKMaxExtention);


	// o͕ϐLȂ
	if (pOutExtention)
	{
		// 
		memcpy(pOutExtention, extentionName, mStKMaxExtention);
	}


	return extentionName;
}

/// tpXgqtt@C擾
tstring Directory::GetFileNameWithExtention(const TCHAR* const kPFullPath, TCHAR pOut[mStKMaxFileName + mStKMaxExtention])
{
	// t@C擾
	TCHAR fileName[mStKMaxFileName];
	GetFileName(kPFullPath, fileName);

	// gq擾
	TCHAR extentionName[mStKMaxExtention];
	GetExtention(kPFullPath, extentionName);


	// t@CɊgqA
	_tcscat_s(fileName, mStKMaxFileName, extentionName);


	// o͕ϐLȂ
	if (pOut)
	{
		// 
		memcpy(pOut, fileName, mStKMaxFileName);
	}

	return fileName;
}


/// fBNg̑St@C擾
bool Directory::GetFileNamesInDirectory(const TCHAR* kPFullPath, std::vector<tstring>* pOut)
{
	HANDLE hSearch;
	WIN32_FIND_DATA fd;


	// o͕ϐȂ
	if (!pOut)
	{
		return false;
	}

	// NA
	pOut->clear();


	// fBNgݒ
	SetCurrentDirectoryPath(kPFullPath);


	// 擾t@C̏ChJ[hŎw
	const TCHAR* kPWildCard = _T("*.*");
	hSearch = FindFirstFile(kPWildCard, &fd);

	// ŏ̃t@C擾łȂȂ
	if (hSearch == INVALID_HANDLE_VALUE)
	{
		return false;
	}

	// CAUTION:[v
	while (true)
	{
		// t@C擾
		const int kBufferSize = SIZE_OF_ARRAY(fd.cFileName);
		TCHAR buffer[kBufferSize];
		memcpy(buffer, fd.cFileName, kBufferSize);

		PFL(_T("t@C=%s"), buffer);


		// t@Cgq擾
		TCHAR extentionName[Directory::mStKMaxExtention];
		ZeroMemory(extentionName, sizeof(extentionName));

		Directory::GetExtention(buffer, extentionName);

		// MEMO:"."܂݂܂B
		// gqȂ
		const int kFileExtentionNameLength = 4;
		int extentionNameLength = _tcslen(extentionName);
		if (kFileExtentionNameLength  <= extentionNameLength)
		{
			// ǉ
			pOut->push_back(buffer);
		}


		// ̃t@C擾
		BOOL isSucceeded = FindNextFile(hSearch, &fd);

		// Ɏ擾łȂȂ
		if (!isSucceeded)
		{
			// ȏt@Cꍇ͐
			const DWORD kLastErrorNumber = GetLastError();
			if (kLastErrorNumber == ERROR_NO_MORE_FILES)
			{
				break;
			}
			else
			{
				HALT(_T("t@C̎擾Ɏs܂B\nLastError=%d"), kLastErrorNumber);

				break;
			}
		}
	}
	
	// nh
	FindClose( hSearch );


	// fBNg
	ResetCurrentDirectoryAbsolutePath();


	return true;
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Directory::Directory()
{
}

/// fXgN^
Directory::~Directory()
{
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// st@C̐΃tpX擾
tstring Directory::GetExeAbsoluteFullPath()
{
	TCHAR moduleFullPath[mStKMaxDirectory];

	// tpX擾
	GetModuleFileName(NULL, moduleFullPath, mStKMaxDirectory);

	return ReplaceYenToSlash(moduleFullPath);
}

/// ̃pXf~^'\''/'ɒu
tstring Directory::ReplaceYenToSlash(const TCHAR* kPText)
{
	// pXf~^
	const TCHAR* kPPathDelimiter = _T("\\");

	// XbV
	const TCHAR* kPSlash = _T("/");


	// u
	tstring outStr = StringHelper::Replace(kPText, kPPathDelimiter, kPSlash);


	return outStr;
}