#include "Blast/Graphic/DirectX9/DebugPrintDX9.h"

#include "Blast/Graphic/DirectX9/FontDX9.h"
#include "Blast/Graphic/TextRendererColorTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugPrintDX9::DebugPrintDX9()
{
	// tHg쐬
	mPFont.SetPointer(NEW FontDX9());
	mPFont->CreateFontData();
}

/// fXgN^
DebugPrintDX9::~DebugPrintDX9()
{
}


/// tHgTCY擾
int DebugPrintDX9::GetPointSize() const
{
	return mPFont->GetPointSize();
}

/// ʒuݒ
void DebugPrintDX9::SetPosition(const Vector3& kRPosition)
{
	mSSentence.mPosition = kRPosition;
}

/// Fݒ
void DebugPrintDX9::SetColor(const Color& kRColor)
{
	mSSentence.mColor = kRColor;
}


/// ݒ
void DebugPrintDX9::SetText(const TCHAR* pText)
{
	_tcscpy_s(mSSentence.mText, SIZE_OF_ARRAY(mSSentence.mText), pText);
}


/// `
void DebugPrintDX9::Render()
{
	// XgɒǉĂB
	// ۂ̕`Flush()ɂĈꊇōsB
	mSentenceList.push_back(mSSentence);
}

/// `ʂɔf
void DebugPrintDX9::Flush()
{
	// ̓Xgꊇ`
	GraphicsDeviceDX9* pGD = GraphicsDeviceDX9::GetInstance();
	pGD->BeginSprite();
	for (SentenceList::iterator it = mSentenceList.begin(); it != mSentenceList.end(); ++it)
	{
		mPFont->SetPosition( (*it).mPosition );
		mPFont->SetColor( (*it).mColor ) ;
		mPFont->SetText( (*it).mText );
		mPFont->Render();
	}
	pGD->EndSprite();

	mSentenceList.clear();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// tHg擾
const SP<FontDX9> DebugPrintDX9::GetFont() const
{
	return mPFont;
}

