#include "Blast/Base/DebugManager.h"

#include "Blast/Graphic/IDebugPrint.h"
#include "Blast/Graphic/DebugPrintFactory.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugManager::DebugManager()
{
	// DebugPrint쐬
	DebugPrintFactory debugPrintFactory;
	mPDebugPrint.SetPointer(debugPrintFactory.Create());
}

/// fXgN^
DebugManager::~DebugManager()
{
}

/// 
void DebugManager::HandleInput(float delta)
{
}

/// XV
void DebugManager::Update(float delta)
{
}

/// `
void DebugManager::Render()
{
	// `挋ʂ𔽉f
	mPDebugPrint->Flush();
}


/// \
void DebugManager::DebugPrint(int x, int y, unsigned argbColor, const TCHAR* pSrc, ...)
{
	ASSERT_PRINTF(GetInstance(), _T("CX^X܂"));
	ASSERT_PRINTF(mPDebugPrint, _T("DebugPrint܂"));

	// ψztH[}bgwqɉĕϊ
	TCHAR dsts[FORMAT_STR_SIZE_INIT];
	ZeroMemory(dsts, FORMAT_STR_SIZE_INIT);

	va_list	argp;
	va_start(argp, pSrc);
	{
		_vstprintf_s(dsts, FORMAT_STR_SIZE_INIT, pSrc, argp);
	}
	va_end(argp);

	// ݒ
	Vector3 pos((float)x, (float)y, 0);
	mPDebugPrint->SetPosition(pos);
	mPDebugPrint->SetColor(argbColor);
	mPDebugPrint->SetText(dsts);

	mPDebugPrint->Render();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// DebugPrint擾
SP<Blast::Graphic::IDebugPrint> DebugManager::GetDebugPrint()
{
	return mPDebugPrint;
}