#include "Blast/Application/DirectX9/DX9ApplicationBase.h"

#include "Blast/Application/DirectX9/DX9WindowBase.h"
#include "Blast/Base/DirectX9/DirectX9.h"
#include "Blast/Base/DirectX9/GraphicsDeviceDX9.h"

using namespace Blast::Application;
using namespace Blast::Base;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DX9ApplicationBase::DX9ApplicationBase() :
mGameBases()
{
}

/// fXgN^
DX9ApplicationBase::~DX9ApplicationBase()
{
}

/// EBhE̍쐬
bool DX9ApplicationBase::CreateMainWindow()
{
	// EBhE쐬
	DX9WindowBase::SProperty sProperty;
	sProperty.Initialize(GetHInstance(), GetWindowClassEx().lpszClassName);

	// X}[g|C^ŕێ
	SP<WindowBase> pWB(new DX9WindowBase());
	bool isOk = pWB->Create(sProperty);

	// 쐬̌ʂsȂ
	if (!isOk)
	{
		OutputDebugString(_T("EBhE̍쐬Ɏs܂\n"));

		return false;
	}

	// EBhEzɒǉ
	mWindowBases.push_back(pWB);

	// EBhETCYNCAgTCYƂăTCY
	ChangeToCliantSize(pWB->GetWindowHandleRef(), sProperty.mWidth, sProperty.mHeight);

	return true;
}

/// 
bool DX9ApplicationBase::Initialize()
{
	// DirectX9̃A_v^쐬
	bool isDX9 = CreateDX9();
	if (!isDX9)
	{
		return false;
	}

	// DirectX9̃foCX쐬
	bool isDX9Device = CreateDX9Device();
	if (!isDX9Device)
	{
		return false;
	}

	return true;
}

/// bZ[W[v̎s
int DX9ApplicationBase::Loop()
{
	// Q[x[XNXȂI
	if (mGameBases.empty())
	{
		HALT(_T("Q[NXݒ肳Ă܂"));

		return 0;
	}

	// Q[x[XNX̐擾
	int gameBaseCount = mGameBases.size();

	// Q[x[XNX
	for (int i = 0; i < gameBaseCount; ++i)
	{
		mGameBases.at(i)->Initialize();
	}

	// bZ[W
	MSG msg; 
	ZeroMemory(&msg, sizeof(msg));

	// IbZ[W󂯎܂Ń[v
	while (msg.message != WM_QUIT)
	{
		// bZ[WĎ
		if (PeekMessage(&msg, NULL, 0U, 0U, PM_REMOVE))
		{
			// IbZ[WȂA[v𔲂ďI
			if (msg.message == WM_QUIT) { break; }

			// bZ[WϊAB
			TranslateMessage(&msg);
			DispatchMessage(&msg);

			continue;
		}

		// foCX擾
		LPDIRECT3DDEVICE9 pDeviceDX9 = GraphicsDeviceDX9::GetInstance()->GetDevice();

		// ʂNA
		unsigned clearBufferFlag = D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER | D3DCLEAR_STENCIL;
		HRESULT hr = pDeviceDX9->Clear(0, NULL, clearBufferFlag, D3DCOLOR_XRGB(0, 128, 192), 1.0f, 0);
		ASSERT_PRINTF(SUCCEEDED(hr), _T("ʂ̃NAɎs܂Bhr=0x%x"), hr);

		// V[Jn
        hr = pDeviceDX9->BeginScene();
		ASSERT_PRINTF(SUCCEEDED(hr), _T("V[̊JnɎs܂B"));
		if (SUCCEEDED(hr))
		{
			// Q[x[X̐Ń[v
			gameBaseCount = mGameBases.size();
			for (int i = 0; i < gameBaseCount; ++i)
			{
				// XebvBe͔hNXɔC܂
				mGameBases.at(i)->Step();
			}
		}
		// V[I
        hr = pDeviceDX9->EndScene();
		ASSERT_PRINTF(SUCCEEDED(hr), _T("V[̏IɎs܂B"));

		// obNobt@tbvtbv
        pDeviceDX9->Present(NULL, NULL, NULL, NULL);
	}

	// Q[x[XNX
	gameBaseCount = mGameBases.size();
	for (int i = 0; i < gameBaseCount; ++i)
	{
		mGameBases.at(i)->Release();
	}

	// Q[x[XNXNA
	mGameBases.clear();

	return static_cast<int>(msg.wParam);
}

/// 
void DX9ApplicationBase::Release()
{
	// _[foCX
	GraphicsDeviceDX9::DestroyInstance();

	// A_v^
	DirectX9::DestroyInstance();
}

/// DirectX9̃A_v^쐬
bool DX9ApplicationBase::CreateDX9()
{
    // Direct3D̏
    LPDIRECT3D9 lpDirect3D9;
	lpDirect3D9 = Direct3DCreate9(D3D_SDK_VERSION);

	// Direct3D̏ɎsȂ
	if (!lpDirect3D9)
	{
		PFL(_T("LPDIRECT3D9̍쐬Ɏs܂"));

		return false;
	}

	// A_v^쐬
	DirectX9* pDX9 = DirectX9::CreateInstance();
	pDX9->SetFramework(lpDirect3D9);

	return true;
}

/// DirectX9̃foCX쐬
bool DX9ApplicationBase::CreateDX9Device()
{
	DirectX9* pDX9 = DirectX9::GetInstance();
	LPDIRECT3D9 lpd3d9 = pDX9->GetFramework();

	// Direct3DDevicȅ
    D3DPRESENT_PARAMETERS d3dpp;
	d3dpp.BackBufferWidth				= GetWindowBasesRef().front()->GetWindowPropertyRef().mWidth;
	d3dpp.BackBufferHeight				= GetWindowBasesRef().front()->GetWindowPropertyRef().mHeight;
	d3dpp.BackBufferCount				= 1;
	d3dpp.BackBufferFormat				= D3DFMT_UNKNOWN;	//< ɐݒ肷Kv炵H
	d3dpp.MultiSampleType				= D3DMULTISAMPLE_NONE;
	d3dpp.MultiSampleQuality			= 0;
	d3dpp.SwapEffect					= D3DSWAPEFFECT_DISCARD;
	d3dpp.hDeviceWindow					= GetWindowBasesRef().front()->GetWindowHandleRef();
	d3dpp.Windowed						= TRUE;
	d3dpp.EnableAutoDepthStencil		= TRUE;	//< FALSEɂȂAD3DCLEAR_ZBUFFERD3DCLEAR_STENCIL͎gpȂ悤ɂB
	d3dpp.AutoDepthStencilFormat		= D3DFMT_D24S8;
	d3dpp.Flags							= 0;
	d3dpp.FullScreen_RefreshRateInHz	= D3DPRESENT_RATE_DEFAULT;
	d3dpp.PresentationInterval			= D3DPRESENT_INTERVAL_DEFAULT;

	UINT adapterToUse = D3DADAPTER_DEFAULT; 
	D3DDEVTYPE deviceType = D3DDEVTYPE_HAL;

#if _DEBUG // PerfHUDp
	// NVIDIA PerfHUD A_v^TA΃A_v^
	const unsigned kAdapterCount = lpd3d9->GetAdapterCount();
	for (unsigned adapter = 0; adapter < kAdapterCount; adapter++)
	{ 
		// A_v^擾
		D3DADAPTER_IDENTIFIER9 identifier;
		HRESULT result = lpd3d9->GetAdapterIdentifier(adapter, 0, &identifier);

		// A_v^̎擾ɎsȂ玀
		ASSERT_PF(SUCCEEDED(result), _T("A_v^̎擾Ɏs܂B"));
		
		// MEMO:TCHARł͂ȂACHARłB
		// uPerfHUDvn܂Ȃ
		if (strstr(identifier.Description, "PerfHUD") != 0)
		{ 
			adapterToUse = adapter; 
			deviceType = D3DDEVTYPE_REF; 

			break; 
		}
	} 
#endif // _DEBUG

    LPDIRECT3DDEVICE9 lpDirect3DDevice9 = NULL;
	HRESULT hrD3DDevice9 = lpd3d9->CreateDevice(
		adapterToUse,
		deviceType,
		mGameBases.front()->GetWindowHandle(),	//< Ƃ肠擪
		D3DCREATE_HARDWARE_VERTEXPROCESSING,
		&d3dpp,
		&lpDirect3DDevice9
		);

	// Direct3DDevice̍쐬ɎsȂ
    if(FAILED(hrD3DDevice9))
	{
		PFL(_T("LPDIRECT3DDEVICE9̍쐬Ɏs܂"));

        //lpDirect3D9->Release();
		DirectX9::DestroyInstance();

        return false;
    }

	// OtBbNXfoCX쐬
	GraphicsDeviceDX9* pDevice = GraphicsDeviceDX9::CreateInstance();
	pDevice->SetDevice(lpDirect3DDevice9);

	// XvCg쐬
	CSP<ID3DXSprite> pSprite;
	HRESULT hr = D3DXCreateSprite(lpDirect3DDevice9, pSprite.ToCreator());
	ASSERT_PRINTF(SUCCEEDED(hr), _T("XvCg̍쐬Ɏs܂B"));
	pDevice->SetSprite(pSprite);

	return true;
}

/// Q[x[XƂȂNXǉ
void DX9ApplicationBase::AddGameBase(SPDX9Gamebase& rSpGameBases)
{
	mGameBases.push_back(rSpGameBases);
}