#include "Blast/Graphic/DirectX9/CrosshairMeshDX9.h"

#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/VertexStreamType.h"

#include "Blast/String/StringHelper.h"

using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::Math;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CrosshairMeshDX9::CrosshairMeshDX9()
	: mPrimitiveCount(-1)
{
}

/// fXgN^
CrosshairMeshDX9::~CrosshairMeshDX9()
{
}


/// 쐬
void CrosshairMeshDX9::Create(float length)
{
	std::vector<Vector3> vertices;
	std::vector<unsigned> colors;

	// ʒuW쐬
	const float kHalfLength = length * 0.5f;
	vertices.push_back( Vector3::UnitX() * -kHalfLength );
	vertices.push_back( Vector3::UnitX() * kHalfLength );
	vertices.push_back( Vector3::UnitY() * -kHalfLength );
	vertices.push_back( Vector3::UnitY() * kHalfLength );
	vertices.push_back( Vector3::UnitZ() * -kHalfLength );
	vertices.push_back( Vector3::UnitZ() * kHalfLength );

	SP<VertexBufferDX9> pPositionBuffer(NEW VertexBufferDX9());
	pPositionBuffer->SetVertices(&vertices.front(), vertices.size(), sizeof(Vector3) * vertices.size());
	mPVertexBuffers[eVB_POSITION] = pPositionBuffer;

	// F쐬
	unsigned red = ColorCode::ToCode(ColorCode::eCOLOR_RED);
	unsigned green = ColorCode::ToCode(ColorCode::eCOLOR_GREEN);
	unsigned bluc = ColorCode::ToCode(ColorCode::eCOLOR_BLUE);
	colors.push_back(red);
	colors.push_back(red);
	colors.push_back(green);
	colors.push_back(green);
	colors.push_back(bluc);
	colors.push_back(bluc);

	SP<VertexBufferDX9> pColorBuffer(NEW VertexBufferDX9());
	pColorBuffer->SetVertices(&colors.front(), colors.size(), sizeof(unsigned) * colors.size());
	mPVertexBuffers[eVB_COLOR] = pColorBuffer;


	// _`쐬
	VertexElementFactoryDX9 vef;
	const D3DVERTEXELEMENT9 elements[] =
	{
		vef.CreateElement(VertexElementType::eELEMENT_POSITION),
		vef.CreateElement(VertexElementType::eELEMENT_COLOR),
		vef.CreateElement(VertexElementType::eELEMENT_END),
	};
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	mPVertexDeclaration->CreateDeclaration(elements);


	// CfbNX쐬
	int kVertexCount = vertices.size();
	SP<int> pIndices(NEW int[kVertexCount], true);
	for (int i = 0; i < kVertexCount; ++i)
	{
		pIndices[i] = i;
	}
	mPIndexBuffer.SetPointer(NEW IndexBufferDX9());
	mPIndexBuffer->SetIndices(pIndices.GetSource(), kVertexCount);	


	// v~eBu2_ňȂ̂ŁA_2
	mPrimitiveCount = vertices.size() / 2;
}


/// `
void CrosshairMeshDX9::Render()
{
	// foCX擾
	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();


	// o[ebNX̃Xg[ݒ
	SP<VertexBufferDX9> pPositionBuffer = mPVertexBuffers[eVB_POSITION];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_POSITION, mPVertexBuffers[eVB_POSITION]->GetBuffer(), 0, mPVertexBuffers[eVB_POSITION]->GetStride());

	SP<VertexBufferDX9> pColorBuffer = mPVertexBuffers[eVB_COLOR];
	pDevice->SetStreamSource(VertexStreamType::eSTREAM_COLOR, mPVertexBuffers[eVB_COLOR]->GetBuffer(), 0, mPVertexBuffers[eVB_COLOR]->GetStride());

	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());

	// CfbNXobt@ݒ
	pDevice->SetIndices(mPIndexBuffer->GetBuffer());

	// _擾
	const int kVertexCount = mPVertexBuffers[eVB_POSITION]->GetVertexCount();

	// `
	HRESULT hr = pDevice->DrawIndexedPrimitive(
		D3DPT_LINELIST,
		0,
		0,
		kVertexCount,
		0,
		mPrimitiveCount
		);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("`Ɏs܂B"));
}