#include "Blast/Graphic/DirectX9/CrosshairDX9.h"

#include "Blast/Base/ResourceManager.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CrosshairDX9::CrosshairDX9()
	: mPMesh(NEW CrosshairMeshDX9())
	, mPShader(NEW ShaderEffectDX9())
	, mPosition(0)
{
	// pVF[_[Ȃ̂ŊO킸ɎōĂ܂
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_CROSSHAIR));
}

/// fXgN^
CrosshairDX9::~CrosshairDX9()
{
}

/// 쐬
void CrosshairDX9::Create(float length)
{
	// bV쐬
	mPMesh->Create(length);
}

/// XV
void CrosshairDX9::Update(float delta)
{
}

/// `
void CrosshairDX9::Render()
{
	// bV`
	if (!mPMesh)
	{
		return;
	}
	
	// [hsݒ
	Matrix world;
	world.CreateTranslate(mPosition);
	mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &world);

	// r[sݒ
	ASSERT_PF(mPCamera, _T("Jݒ肳Ă܂B"));
	mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &mPCamera->GetViewMatrixRef());

	// ˉesݒ
	mPShader->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &mPCamera->GetProjectionMatrixRef());


	// `Jn
	unsigned passCount = 0;
	mPShader->Begin(&passCount);
	{
		for (int i = 0; i < static_cast<int>(passCount); ++i)
		{
			mPShader->BeginPass(i);
			{
				mPMesh->Render();
			}
			mPShader->EndPass();
		}
	}
	mPShader->End();
}