#include "Blast/IO/CSVRecord.h"

#include <algorithm>

using namespace Blast::IO;


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/* SField */

/// ftHgRXgN^
CSVRecord::SField::SField()
{
}

/// RXgN^
CSVRecord::SField::SField(const TCHAR* kPName, const TCHAR* kPValue) :
mColumnNameStr(kPName),
mValue(kPValue)
{
}

/// fXgN^
CSVRecord::SField::~SField()
{
}


/// O擾
const TCHAR* CSVRecord::SField::GetColumnName() const
{
	return mColumnNameStr.c_str();
}

/// Oݒ
void CSVRecord::SField::SetColumnName(const TCHAR* kPName)
{
	mColumnNameStr = kPName;
}


/// l擾
const CSVVariant& CSVRecord::SField::GetValueRef() const
{
	return mValue;
}

/// lݒ
void CSVRecord::SField::SetValue(const CSVVariant& kRValue)
{
	mValue = kRValue;
}

/// lݒ
void CSVRecord::SField::SetValue(const TCHAR* kPValue)
{
	mValue = kPValue;
}


#if _DEBUG

/// DEBUG:_v
void CSVRecord::SField::Dump() const
{
	PFL(_T("mColumnNameStr=%s"), mColumnNameStr.c_str());
	PFL(_T("mValue=%s"), mValue.GetValueStrRef().c_str());
}

#endif // _DEBUG


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CSVRecord::CSVRecord()
{
}

/// fXgN^
CSVRecord::~CSVRecord()
{
}


/// ڂNA
void CSVRecord::ClearItems()
{
	mItemList.clear();
}


/// ڂǉ
int CSVRecord::InsertItem(const SField& rSField)
{
	// }
	mItemList.push_back(rSField);


	// ݂̗vfԂ
	return mItemList.size();
}

/// ڐ擾
int CSVRecord::GetItemCount() const
{
	return mItemList.size();
}


/// ڏ擾
const CSVRecord::SField* CSVRecord::GetItem(int index) const
{
	// ڐ擾
	const int kCount = mItemList.size();


	// CfbNX͈͓ǂ
	const bool kIsWithin = (0 <= index && index < kCount);
	
	// ASSERT:CfbNX͈͊OȂ玀
	ASSERT_PF(kIsWithin, _T("CfbNX͈͊OłBindex=%d"), index);

	// ͈͊OȂ
	if (!kIsWithin)
	{
		return NULL;
	}


	// Ce[^[𑀍
	Items::const_iterator kIt = mItemList.begin();
	std::advance(kIt, index);

	return &(*kIt);
}

/// ڏ𖼑OwŎ擾
const CSVRecord::SField* CSVRecord::GetItem(const TCHAR* const pName) const
{
	// tB[h擾
	Items::const_iterator kIt = mItemList.begin();
	while (kIt != mItemList.end())
	{
		bool isMatch = (_tcscmp(pName, (*kIt).GetColumnName()) == 0);
		if (isMatch)
		{
			break;
		}

		++kIt;
	}

	// ASSERT:擾łȂȂ玀
	ASSERT_PF(kIt != mItemList.end(), _T("擾ł܂łBO=%s"), pName);

	// 擾łȂȂ
	if (kIt == mItemList.end())
	{
		return NULL;
	}


	return &(*kIt);
}


//====================================================================================================
// Overload
//----------------------------------------------------------------------------------------------------

/// z񉉎ZqŃANZX\ɂ
const CSVRecord::SField* CSVRecord::operator[] (int index) const
{
	return GetItem(index);
}

/// z񉉎Zqɗ񖼂邱ƂŃANZX\ɂ
const CSVRecord::SField* CSVRecord::operator[] (const TCHAR* const kPHeaderName) const
{
	return GetItem(kPHeaderName);
}


#if _DEBUG

//====================================================================================================
// Debug
//----------------------------------------------------------------------------------------------------

// DEBUG:_v
void CSVRecord::Dump() const
{
	PFL(_T("CSVRecord --------------------------------------------------"));
	const int kCount = mItemList.size();
	for (int i = 0; i < kCount; ++i)
	{
		Items::const_iterator kIt = mItemList.begin();
		std::advance(kIt, i);

		PFL(_T("CSVRecord[%d]"), i);
		(*kIt).Dump();
		PFL(_T(""));
	}
}

#endif // _DEBUG
