#include "Blast/IO/CSVFile.h"

#include <sstream>
#include "Blast/IO/CSVTable.h"
#include "Blast/IO/CSVRecord.h"
#include "Blast/IO/CSVVariant.h"
#include "Blast/Storage/Directory.h"
#include "Blast/String/StringHelper.h"

using namespace Blast::IO;
using namespace Blast::Storage;
using namespace Blast::String;


/// wb_[ǂݎۂɃ_v邩ǂ
#define DUMP_HEADER 0

/// PǂݎxɃ_v邩ǂ
#define DUMP_WORD 0

/// R[h쐬xɃ_v邩ǂ
#define DUMP_RECORD 0


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CSVFile::CSVFile(const TCHAR* kPDirectoryPath, const TCHAR* kPFileName) :
mFileNameStr(kPFileName),
mDirectoryPathStr(kPDirectoryPath),
mDataColumnCount(-1),
mDataRowCount(-1),
mPDataTable(NULL)
{
}

/// RXgN^
CSVFile::CSVFile(const TCHAR* kPFullPath)
{
	// fBNgpX擾
	TCHAR dirPath[Directory::mStKMaxDirectory];
	ZeroMemory(dirPath, sizeof(dirPath));

	Directory::GetDirectoryPath(kPFullPath, dirPath);

	mDirectoryPathStr = dirPath;


	// t@C擾
	TCHAR fileName[Directory::mStKMaxFileName];
	ZeroMemory(fileName, sizeof(fileName));

	Directory::GetFileNameWithExtention(kPFullPath, fileName);

	mFileNameStr = fileName;
}

/// fXgN^
CSVFile::~CSVFile()
{
}


/// f[^e[u\z
bool CSVFile::Create()
{
	// tpX\z
	TCHAR fullPath[Directory::mStKMaxPath];
	ZeroMemory(fullPath, sizeof(fullPath));

	_tcscat_s(fullPath, mDirectoryPathStr.c_str());
	_tcscat_s(fullPath, mFileNameStr.c_str());


	// CSVt@CWJ
	mPFile.SetPointer(NEW File());
	bool isSucceededOpen = mPFile->Open(fullPath);

	// ǂݍ݂ɎsȂ
	if (!isSucceededOpen)
	{
		// t@C
		mPFile->Close();

		return false;
	}


	// MEMO:sA񐔂̏Ŋi[܂B
	// sA񐔂擾
	mPFile->ReadFormat(_T("%d,"), &mDataRowCount);
	mPFile->ReadFormat(_T("%d,"), &mDataColumnCount);


	// o̖O擾
	std::vector<tstring> headerNames;
	headerNames.reserve(mDataColumnCount);

	for (int i = 0; i < mDataColumnCount; ++i)
	{
		// obt@p
		const int kBufferSize = StringHelper::mStKDefaultBufferSize;
		TCHAR buffer[kBufferSize];
		ZeroMemory(buffer, sizeof(buffer));

		// MEMO:J}؂̐K\ł
		// J}Pʂ̕擾
		const TCHAR* kPRegular = _T("%[^,],");
		mPFile->ReadFormat(kPRegular, buffer, &kBufferSize);

#if DUMP_HEADER
		PFL(_T("[%d]%s"), i, buffer);
#endif // DUMP_HEADER


		// oǉ
		headerNames.push_back(buffer);
	}


	// e[up
	mPDataTable.SetPointer(NEW CSVTable());


	// sŃ[v
	for (int i = 0; i < mDataRowCount; ++i)
	{
		// R[hp
		SP<CSVRecord> pRecord(NEW CSVRecord());


		// 񐔂Ń[v
		for (int j = 0; j < mDataColumnCount; ++j)
		{
			// obt@p
			const int kBufferSize = StringHelper::mStKDefaultBufferSize;
			TCHAR buffer[kBufferSize];
			ZeroMemory(buffer, sizeof(buffer));

			// MEMO:J}؂̐K\ł
			// J}Pʂ̕擾
			const TCHAR* kPRegular = _T("%[^,],");
			mPFile->ReadFormat(kPRegular, buffer, &kBufferSize);

#if DUMP_WORD
			PFL(_T("[%d,%d]\t%s"), i, j, buffer);
#endif // DUMP_WORD


			// ڂp
			CSVRecord::SField sField;


			// Oݒ
			sField.SetColumnName(headerNames.at(j).c_str());

			// lݒ
			sField.SetValue(buffer);


			// R[hɒǉ
			pRecord->InsertItem(sField);
		}

#if DUMP_RECORD
		pRecord->Dump();
#endif // DUMP_RECORD

		// e[uɃR[hǉ
		mPDataTable->AddRecord(pRecord);
	}


	// t@C
	mPFile->Close();


	return true;
}

/// f[^e[u
void CSVFile::Release()
{
	mPDataTable.SetPointer(NULL);
}


/// t@C擾
SP<File> CSVFile::GetFile()
{
	return mPFile;
}


/// t@C擾
const tstring& CSVFile::GetFileNameRef() const
{
	return mFileNameStr;
}

/// t@Cݒ
void CSVFile::SetFileName(const TCHAR* kPFileName)
{
	mFileNameStr = kPFileName;
}


/// t@C̃fBNgpX擾
const tstring& CSVFile::GetDirectoryPathRef() const
{
	return mDirectoryPathStr;
}

/// t@C̃fBNgpXݒ
void CSVFile::SetDirectoryPath(const TCHAR* kPDirectoryPath)
{
	mDirectoryPathStr = kPDirectoryPath;
}


/// f[^̗񐔂擾
int CSVFile::GetColumnCount() const
{
	return mDataColumnCount;
}

/// f[^̍s擾
int CSVFile::GetRowCount() const
{
	return mDataRowCount;
}


/// f[^e[u擾
const SP<CSVTable> CSVFile::GetDataTable() const
{
	return mPDataTable;
}