#include "Blast/Audio/AudioOggResourceMemory.h"

#include "Blast/String/StringHelper.h"

using namespace Blast::Audio;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
AudioOggResourceMemory::AudioOggResourceMemory()
{
}

/// fXgN^
AudioOggResourceMemory::~AudioOggResourceMemory()
{
	Clear();
}


/// Oggt@Cǂݍ
bool AudioOggResourceMemory::Load(const TCHAR* kPFileName)
{
	// UNA
	Clear();


	// t@Cݒ
	mFileNameStr = kPFileName;


	// t@CWJ
	FILE* pFile = NULL;
	const TCHAR* kPFileMode = _T("rb");
	_tfopen_s(&pFile, kPFileName, kPFileMode);

	// ASSERT:t@C̓WJɎsȂ玀B
	ASSERT_PF(pFile, _T("t@C̓WJɎs܂B\nt@C=%s"), kPFileName);

	// t@C̓WJɎsȂ
	if (!pFile)
	{
		return false;
	}
	

	// TCY擾
	fseek(pFile, 0, SEEK_END);
	mBufferSize = ftell(pFile);
	fseek(pFile, 0, SEEK_SET);


	// MEMO:gɉÃIuWFNg̃AhXi[邽߃|C^܂߂܂B
	// obt@쐬
	CHAR* pBuffer = NEW CHAR[mBufferSize];
	mPBuffer.SetPointer(pBuffer, true);


	// t@Cǂݎ
	unsigned readSize = fread(pBuffer, mBufferSize, 1, pFile);

	// t@C
	fclose(pFile);

	// G[NȂ
	if (readSize != 1)
	{
		// NA
		Clear();

		// HALT:B
		HALT(_T("t@CǂݎۂɃG[܂B"));

		return false;
	}

   
	// R[obN֐o^
   ov_callbacks oggCallbacks =
   {
	   &AudioOggResourceMemory::Read,
	   &AudioOggResourceMemory::Seek,
	   &AudioOggResourceMemory::Close,
	   &AudioOggResourceMemory::Tell
   };


   // MEMO:̃IuWFNg̃|C^n܂B
   // Oggt@CWJ
   int openCode = ov_open_callbacks(this, &mOggVorbisFile, NULL, 0, oggCallbacks);
   
   // Oggt@C̓WJɎsȂ
   if (openCode != 0)
   {
	   // NA
	   Clear();

	   // HALT:B
	   HALT(_T("Oggt@C̓WJɎs܂B"));
	   
	   return false;
   }

   // Ogg{擾
   vorbis_info* pInfo = ov_info(&mOggVorbisFile, -1);

   // ASSERT:̎擾ɎsȂ玀B
   ASSERT_PF(pInfo, _T("Oggt@C̏̎擾Ɏs܂B"));

   // ̎擾ɎsȂ
   if (!pInfo)
   {
	   return false;
   }


   // `lݒ
   mChannelCount = pInfo->channels;

   // rbg[gݒ
   static const int kBitRate = 16;
   mBitRate = kBitRate;

   // TvO[gݒ
   mSamplingRate = pInfo->rate;


   // tO𗧂Ă
   mIsReadyOk = true;
   	
   return true;
}


/// NA
void AudioOggResourceMemory::Clear()
{
	// eϐ
	mPBuffer.SetPointer(NULL);
	mBufferSize = 0;
	mCurrentPosition = 0;

	// ̃\bhR[
	AudioOggResource::Clear();
}


/// N[쐬
SP<IAudioResource> AudioOggResourceMemory::Clone()
{
	// ĂȂȂ
	if (!mIsReadyOk)
	{
		// NULL̃|C^Ԃ
		return SP<AudioOggResourceMemory>();
	}


	// N[pCX^X쐬
	AudioOggResourceMemory* pClone = NEW AudioOggResourceMemory();

	// MEMO:V[NOggVorbist@CĂ܂̂ŁAč쐬܂B
	// n[hRs[
	*pClone = *this;


	// V[N̈ʒu
	pClone->mCurrentPosition = 0;

	// OggVorbist@Cč쐬
	memset(&pClone->mOggVorbisFile, 0, sizeof(pClone->mOggVorbisFile));

	ov_callbacks oggCallbacks =
	{
		AudioOggResourceMemory::Read,
		AudioOggResourceMemory::Seek,
		AudioOggResourceMemory::Close,
		AudioOggResourceMemory::Tell
	};

	// MEMO:N[IuWFNg̃|C^̂ݓn܂B
	int openCode = ov_open_callbacks(pClone, &pClone->mOggVorbisFile, NULL, 0, oggCallbacks);
	if (openCode != 0)
	{
		// NA
		pClone->Clear();

		// HALT:B
		HALT(_T("OggVorbist@C̓WJɎs܂B"));

		return SP<AudioOggResourceMemory>(pClone);
	}


	// t@Cݒ
	pClone->mFileNameStr = mFileNameStr.c_str();

	// tO𗧂Ă
	pClone->mIsReadyOk = true;


	return SP<AudioOggResourceMemory>(pClone);
}


//====================================================================================================
// Private Static Operation
//----------------------------------------------------------------------------------------------------

/// Xg[obt@IuWFNg̃|C^擾
AudioOggResourceMemory* AudioOggResourceMemory::GetPtr(void* pStream)
{
	return reinterpret_cast<AudioOggResourceMemory*>(pStream);
}


/// ǂݍ
unsigned AudioOggResourceMemory::Read(void* pBuffer, unsigned size, unsigned maxCount, void* pStream)
{
	// ASSERT:obt@Ȃ玀B
	ASSERT_PF(pBuffer, _T("obt@łB"));

	// obt@Ȃ
	if (!pBuffer)
	{
		return 0;
	}


	// ASSERT:Xg[Ȃ玀B
	ASSERT_PF(pStream, _T("Xg[łB"));

	// Xg[Ȃ
	if (!pStream)
	{
		return 0;
	}


	// IuWFNg̃|C^擾
	AudioOggResourceMemory* pPtr = GetPtr(pStream);


	// 擾\񐔂Zo
	int restSize = pPtr->mBufferSize - pPtr->mCurrentPosition;
	unsigned restCount = restSize / size;

	// ő擾񐔂ĂȂ
	if (maxCount < restCount)
	{
		// ő擾񐔂ɑ
		restCount = maxCount;
	}

	// MEMO:|C^݂̂ݒ肵܂B
	memcpy(pBuffer, pPtr->mPBuffer.GetSource() + pPtr->mCurrentPosition, size * restCount);

	// |C^ʒuړ
	pPtr->mCurrentPosition += size * restCount;

	return restCount;
}

/// V[N
int AudioOggResourceMemory::Seek(void* pStream, ogg_int64_t offset, int flag)
{
	// IuWFNg̃|C^擾
	AudioOggResourceMemory* pPtr = GetPtr(pStream);


	// ItZbglLXg
	const long kOffsetLong = static_cast<long>(offset);

	// tOŕ
	switch (flag)
	{
		case SEEK_CUR:		pPtr->mCurrentPosition += kOffsetLong;						break;
		case SEEK_END:		pPtr->mCurrentPosition = pPtr->mBufferSize + kOffsetLong;	break;
		case SEEK_SET:		pPtr->mCurrentPosition = kOffsetLong;						break;
		default:			return -1;
	}


	// obt@I[o[ĂȂ
	if (pPtr->mBufferSize < pPtr->mCurrentPosition)
	{
		// HALT:B
		HALT(_T("݈ʒuobt@I[o[܂B"));

		pPtr->mCurrentPosition = pPtr->mBufferSize;

		return -1;
	}
	// obt@A_[ĂȂ
	else if (pPtr->mCurrentPosition < 0)
	{
		// HALT:B
		HALT(_T("݈ʒuobt@A_[܂B"));

		pPtr->mCurrentPosition = 0;

		return -1;
	}

	return 0;
}

/// N[Y
int AudioOggResourceMemory::Close(void* pStream)
{
	// MEMO:IuWFNg̏łƂƂɃobt@͎Rɏ邽߁Ał͍폜܂BĂ܂ƃG[ɂȂ܂B
	return 0;
}

/// ʒum
long AudioOggResourceMemory::Tell(void* pStream)
{
	// IuWFNg̃|C^擾
	AudioOggResourceMemory* pPtr = AudioOggResourceMemory::GetPtr(pStream);

	return pPtr->mCurrentPosition;
}