#include "Blast/Audio/AudioOggResourceFile.h"

#include "Blast/String/StringHelper.h"

using namespace Blast::Audio;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
AudioOggResourceFile::AudioOggResourceFile()
{
}

/// fXgN^
AudioOggResourceFile::~AudioOggResourceFile()
{
	Clear();
}


/// Oggt@Cǂݍ
bool AudioOggResourceFile::Load(const TCHAR* kPFileName)
{
	// UNA
	Clear();


	// t@Cݒ
	mFileNameStr = kPFileName;


	// G[R[h
	int errorCode = 0;

#if UNICODE
	// ChZbg}`oCgZbgւ̕ϊ
	CHAR mbcFileName[StringHelper::mStKDefaultBufferSize];
	StringHelper::ToMultiByteChar(mbcFileName, sizeof(mbcFileName), kPFileName);
	
	// t@CWJ
	errorCode = ov_fopen((CHAR*)mbcFileName, &mOggVorbisFile);
#else
	// t@CWJ
	errorCode = ov_fopen((CHAR*)kPFileName, &mOggVorbisFile);
#endif

	// G[Ȃ
	if (errorCode != 0)
	{
		// G[R[hŕ
		switch (errorCode)
		{
			// fBA̓ǂݎG[
			case OV_EREAD:
				HALT(_T("Ogg`̃fBA̓ǂݎɎs܂B"));
				break;

			// rbgXg[Vorbis̃f[^܂܂ĂȂ
			case OV_ENOTVORBIS:
				HALT(_T("rbgXg[Vorbisf[^܂܂Ă܂B"));
				break;

			// Vorbis̃o[W̕sv
			case OV_EVERSION:
			{
				TCHAR wVorbisVersion[StringHelper::mStKDefaultBufferSize];
				StringHelper::ToWideChar(wVorbisVersion, sizeof(wVorbisVersion), vorbis_version_string());

				HALT(_T("Vorbis̃o[WvĂ܂B\nVorbiso[W=%s"), wVorbisVersion);

				break;
			}

			// Vorbis̃rbgXg[̃wb_
			case OV_EBADHEADER:
				HALT(_T("Vorbis̃rbgXg[̃wb_łB"));
				break;

			// WbN̏QAoOq[v^X^bN̔j
			case OV_EFAULT:
				HALT(_T("WbN̏QAoOq[v/X^bN̔jĂ܂B"));
				break;

			default:
				break;
		}

		return false;
	}

	
	// Ogg{擾
	const int kLinkFlag = -1;
	vorbis_info *pInfo = ov_info(&mOggVorbisFile, kLinkFlag);

	// ASSERT:̎擾ɎsȂ玀B
	ASSERT_PF(pInfo, _T("Oggt@C̏̎擾Ɏs܂B"));

	// ̎擾ɎsȂ
	if (!pInfo)
	{
		return false;
	}


	// `lݒ
	mChannelCount = pInfo->channels;

	// rbg[gݒ
	static const int kBitRate = 16;
	mBitRate = kBitRate;

	// TvO[gݒ
	mSamplingRate = pInfo->rate;


	// 
	mIsReadyOk = true;


	return true;
}