#include "Blast/Audio/AudioOggResource.h"

#include "Blast/String/StringHelper.h"

using namespace Blast::Audio;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
AudioOggResource::AudioOggResource() :
mIsReadyOk(false),
mFileNameStr(_T("")),
mChannelCount(0),
mSamplingRate(0),
mBitRate(0)
{
}

/// fXgN^
AudioOggResource::~AudioOggResource()
{
	Clear();
}


/// V[Nʒu擪ɐݒ
void AudioOggResource::SeekStart()
{
	// łĂȂ
	if (mIsReadyOk)
	{
		// 擪փV[N
		ov_time_seek(&mOggVorbisFile, 0.0);
	}
}

/// NA
void AudioOggResource::Clear()
{
	// ĂȂ
	if (mIsReadyOk)
	{
		// NA
		ov_clear(&mOggVorbisFile);

		mIsReadyOk = false;
	}

	// OggVorbist@C
	ZeroMemory(&mOggVorbisFile, sizeof(mOggVorbisFile));

	// eϐ
	mIsReadyOk = false;
	mFileNameStr.clear();
	mChannelCount = 0;
	mSamplingRate = 0;
	mBitRate = 0;
}


/// ǂ擾
bool AudioOggResource::IsReadyOk() const
{
	return mIsReadyOk;
}


/// t@C擾
const TCHAR* AudioOggResource::GetFileName() const
{
	return mFileNameStr.c_str();
}

/// `l擾
unsigned AudioOggResource::GetChannelCount() const
{
	return mChannelCount;
}

/// TvO[g擾
unsigned AudioOggResource::GetSamplingRate() const
{
	return mSamplingRate;
}

/// rbg[g擾
unsigned AudioOggResource::GetBitRate() const
{
	return mBitRate;
}


/// N[쐬
SP<IAudioResource> AudioOggResource::Clone()
{
	AudioOggResource* pClone = NEW AudioOggResource();
	*pClone = *this;

	return SP<IAudioResource>(pClone);
}


/// OggVorbist@C擾
const OggVorbis_File& AudioOggResource::GetOggVorbisFileRef() const
{
	return mOggVorbisFile;
}

/// OggVorbist@C擾
OggVorbis_File& AudioOggResource::GetOggVorbisFileRef()
{
	return mOggVorbisFile;
}