#ifndef BLAST_UTILITY_WARNING_H
#define BLAST_UTILITY_WARNING_H

#include <stdio.h>
#include <tchar.h>
#include <assert.h>
#include <windows.h>


namespace Blast
{
	namespace Utility
	{
		/// WARNINGSNX
		class Warning
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// tH[}bg
			static const TCHAR* mStKPFormat;

			/// \镶̃obt@TCY
			static const int mStKStringsBufferSize = 1024;

			/// MEMO:x\݂̂łB
			/// Warnings
			template < class T >
			static void Execute(T value, const TCHAR* kPFullPath, int line, const TCHAR* kPFormat, ...)
			{
				// lLłȂȂ
				if (!value)
				{
					// ψztH[}bgwqɉĕϊ
					TCHAR pszBuffer[mStKStringsBufferSize];
					ZeroMemory(pszBuffer, mStKStringsBufferSize);

					va_list	argp;

					va_start(argp, kPFormat);
					_vstprintf_s(pszBuffer, kPFormat, argp);
					va_end(argp);

					// o͕ɕϊ
					TCHAR text[mStKStringsBufferSize];
					ZeroMemory(text, mStKStringsBufferSize);

					_stprintf_s(text, mStKPFormat, kPFullPath, line, pszBuffer);

					// o
					OutputDebugString(text);
				}
			}

		private:
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
			/// RXgN^֎~
			Warning();

			/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
			/// Rs[RXgN^֎~
			Warning(const Warning&);

			/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
			/// ֎~
			void operator= (const Warning&);
		};

	} // namespace Utility
} // namespace Blast

#endif // BLAST_UTILITY_WARNING_H