#ifndef BLAST_UTILITY_PRINTFMACRO_H
#define BLAST_UTILITY_PRINTFMACRO_H

#if _DEBUG

	/// PRINTF}N
	#ifndef PRINTF

		#define PRINTF(format, ...)			Blast::Utility::Printf::Execute(format, __VA_ARGS__);

	#endif // PRINTF

	/// ̌^PF}N
	#ifndef PF

		#define PF(format, ...)				PRINTF(format, __VA_ARGS__);

	#endif // PF

	/// PRINTF_LINE}N
	#ifndef PRINTF_LINE

		#define PRINTF_LINE(format, ...)	PRINTF(format, __VA_ARGS__); \
											Blast::Utility::Printf::Execute(_T("\n"));

	#endif // PRINTF_LINE

	/// ̌^PFL}N
	#ifndef PFL

		#define PFL(format, ...)			PRINTF_LINE(format, __VA_ARGS__);

	#endif // PFL

#else

	// MEMO:œKƏȂȂ̂ŁAptH[}Xɉe^ȂȂ܂

	/// PRINTF}N
	#ifndef PRINTF

		#define PRINTF(format, ...)

	#endif // PRINTF

	/// ̌^PF}N
	#ifndef PF

		#define PF(format, ...)

	#endif // PF

	/// PRINTF_LINE}N
	#ifndef PRINTF_LINE

		#define PRINTF_LINE(format, ...)

	#endif // PRINTF_LINE

	/// ̌^PFL}N
	#ifndef PFL

		#define PFL(format, ...)

	#endif // PFL

#endif // _DEBUG

#endif // BLAST_UTILITY_PRINTFMACRO_H