#ifndef BLAST_UTILITY_ASSERT_H
#define BLAST_UTILITY_ASSERT_H

#include <stdio.h>
#include <tchar.h>
#include <assert.h>
#include <windows.h>
#include <CRTDBG.h>


namespace Blast
{
	namespace Utility
	{
		/// ASSERTSNX
		class Assert
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// G[oۂ̃bZ[W{bNXɕ\^Cg
			static const TCHAR* stKPTitleOnAssert;

			/// G[oۂ̃bZ[W{bNXɕ\镶
			static const TCHAR* stKPTextOnAssert;

			/// tH[}bg
			static const TCHAR* stKPFormat;

			/// \镶̃obt@TCY
			static const int stKStringsBufferSize = 1024;

			/// MEMO:l^A|C^ɑΉ邽߁Aev[gŒlRs[܂B
			/// int^ɂȂŔANX̌^̃|C^nȂłB
			/// ܂AQƂɂȂŔAꎞϐ̏ꍇɃG[o邩łB

			/// asserts
			template < class T >
			static void Execute(T value, const TCHAR* kPFullPath, int line, const TCHAR* kPFormat, ...)
			{
				// lLłȂȂ
				if (!value)
				{
					// ψztH[}bgwqɉĕϊ
					TCHAR pszBuffer[stKStringsBufferSize];
					ZeroMemory(pszBuffer, stKStringsBufferSize);

					va_list	argp;

					va_start(argp, kPFormat);
					_vstprintf_s(pszBuffer, kPFormat, argp);
					va_end(argp);

					// o͕ɕϊ
					TCHAR text[stKStringsBufferSize];
					ZeroMemory(text, stKStringsBufferSize);

					_stprintf_s(text, stKPFormat, kPFullPath, line, pszBuffer);

					// o
					OutputDebugString(text);

					// bZ[W{bNX\AIʂ󂯎
					bool isYes = (MessageBox(NULL, stKPTextOnAssert, stKPTitleOnAssert, MB_YESNO | MB_ICONERROR) == IDYES);

					// YesȂ
					if (isYes)
					{
						// Iɏꎞ~܂
 						_CrtDbgBreak();

						// S~
						exit(EXIT_FAILURE);
					}
				}
			}

		private:
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
			/// RXgN^֎~
			Assert();

			/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
			/// Rs[RXgN^֎~
			Assert(const Assert&);

			/// MEMO:rhiKŃG[o߁A錾݂̂Œ`͂܂B
			/// ֎~
			void operator= (const Assert&);
		};

	} // namespace Utility
} // namespace Blast

#endif // BLAST_UTILITY_ASSERT_H