#ifndef BLAST_TYPE_UINT64_H
#define BLAST_TYPE_UINT64_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// unsigned long long^NX
		class UInt64 : public Blast::Type::TypeBase<unsigned long long>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static unsigned long long GetMax()
			{
				return 0xffffffffffffffffui64;
			}

			/// ŏl擾
			static unsigned long long GetMin()
			{
				return 0;
			}

			
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			UInt64(unsigned long long value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (short a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_UINT64_H