#ifndef BLAST_TYPE_UINT32_H
#define BLAST_TYPE_UINT32_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// unsigned^NX
		class UInt32 : public Blast::Type::TypeBase<unsigned>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static int GetMax()
			{
				return 0xffffffff;
			}

			/// ŏl擾
			static int GetMin()
			{
				return 0;
			}

			
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			UInt32(unsigned value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (unsigned a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_UINT32_H