#ifndef BLAST_TYPE_UINT16_H
#define BLAST_TYPE_UINT16_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// unsigned short^NX
		class UInt16 : public Blast::Type::TypeBase<unsigned short>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static unsigned short GetMax()
			{
				return 0xffff;
			}

			/// ŏl擾
			static unsigned short GetMin()
			{
				return 0;
			}
			

			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			UInt16(short value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (short a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_UINT16_H