#ifndef BLAST_TYPE_INT8_H
#define BLAST_TYPE_INT8_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// char^NX
		class Int8 : public Blast::Type::TypeBase<char>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static char GetMax()
			{
				return 127;
			}

			/// ŏl擾
			static char GetMin()
			{
				return -127 - 1;
			}

			
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Int8(int value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (char a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_INT8_H