#ifndef BLAST_TYPE_INT64_H
#define BLAST_TYPE_INT64_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// long long^NX
		class Int64 : public Blast::Type::TypeBase<long long>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static long long GetMax()
			{
				return 9223372036854775807i64;
			}

			/// ŏl擾
			static long long GetMin()
			{
				return -9223372036854775807i64 - 1;
			}


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Int64(long long value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (long long a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_INT64_H