#ifndef BLAST_TYPE_INT32_H
#define BLAST_TYPE_INT32_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// int^NX
		class Int32 : public Blast::Type::TypeBase<int>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static int GetMax()
			{
				return 2147483647;
			}

			/// ŏl擾
			static int GetMin()
			{
				return -2147483647 - 1;
			}

			/// TCY擾
			static int GetSize()
			{
				return sizeof(int);
			}


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Int32(int value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (int a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_INT32_H