#ifndef BLAST_TYPE_INT16_H
#define BLAST_TYPE_INT16_H

#include "Blast/Type/TypeBase.h"


namespace Blast
{
	namespace Type
	{
		/// short^NX
		class Int16 : public Blast::Type::TypeBase<short>
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ől擾
			static short GetMax()
			{
				return 32767;
			}

			/// ŏl擾
			static short GetMin()
			{
				return -32767 - 1;
			}

			
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Int16(short value)
			{
				mValue = value;
			}

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// Zq
			void operator= (short a)
			{
				mValue = a;
			}
		};

	} // namespace Type
} // namespace Blast

#endif // BLAST_TYPE_INT16_H