#ifndef BLAST_STRING_STRINGHELPER_H
#define BLAST_STRING_STRINGHELPER_H

#include <vector>


namespace Blast
{
	namespace String
	{
		/// ֘Ȁs
		class StringHelper
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// 񕪊̃f~^̏̎
			enum EDelimiter
			{
				/// ܂܂Ȃ
				eDELIMITER_EXCLUDE,

				/// ړɕt
				eDELIMITER_PREFIX,

				/// ڔɕt
				eDELIMITER_SUFFIX,


				/// 񋓗vf̐
				eDELIMITER_COUNT,
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// ftHg̃obt@TCY
			static const int mStKDefaultBufferSize = 1024;

			/// P[
			static const TCHAR* const mStKPLocaleName;


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// tH[}bgϊs
			static void Format(TCHAR* pDst, int count, const TCHAR* pSrc, ...); 

			/// tH[}bgϊs
			static tstring Format(const TCHAR* const pSrc, ...); 


			/// Ov
			static bool IsMatchHead(const TCHAR* kPSrc, const TCHAR* kPSearch);


			/// u
			static tstring Replace(const tstring& kRSrcStr, const tstring& kRSearchStr, const tstring& kRReplaceStr);


			/// 
			static void Split(std::vector<tstring>* pOut, const tstring& kRSrcStr, const TCHAR* kPDelimiter, EDelimiter = eDELIMITER_EXCLUDE);

			// MEMO:̕ɂe܂B
			/// 
			static int Split(TCHAR* pSrc, const TCHAR* delimiters, TCHAR* pOutResults[], int* pOutCount = NULL);


			/// A
			static tstring Concat(TCHAR* pDest, int bufferSize, const TCHAR* kPSrc);


			/// }`oCgChɕϊ
			static void ToWideChar(u32* pResultSize, WCHAR* pDest, u32 bufferSize, const CHAR* pSrc, u32 maxCount = _TRUNCATE);

			/// }`oCgChɕϊ
			static void ToWideChar(WCHAR* pDest, u32 bufferSize, const CHAR* pSrc);

			/// }`oCgChɕϊ
			static wstring ToWideChar(const CHAR* pSrc);


			/// Ch}`oCgɕϊ
			static void ToMultiByteChar(u32* pResultSize, CHAR* pDest, u32 bufferSize, const WCHAR* pSrc, u32 maxCount = _TRUNCATE);

			/// Ch}`oCgɕϊ
			static void ToMultiByteChar(CHAR* pDest, u32 bufferSize, const WCHAR* pSrc);

			/// Ch}`oCgɕϊ
			static std::string ToMultiByteChar(const WCHAR* pSrc);


			/// MEMO:ʃNXɂׂł傤B
			/// P[ݒ
			static void SetLocale(const TCHAR*, int category = LC_ALL, TCHAR* pOut = NULL);

			/// P[{ɐݒ
			static void SetLocaleJapan();

		private:
		};

	} // namespace String
} // namespace Blast

#endif // BLAST_STRING_STRINGHELPER_H
