#ifndef BLAST_STRING_FORMATTING_H
#define BLAST_STRING_FORMATTING_H

#include "Blast/String/FormattingHelper.h"


namespace Blast
{
	namespace String
	{
		/// tH[}bgwq̏SNX
		class Formatting
		{
		public:
			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// tH[}bgwq̃tO
			enum EFlag
			{
				/// }CiX
				eFLAG_MINUS,

				/// vX
				eFLAG_PLUS,

				/// 
				eFLAG_SPACE,

				/// V[v
				eFLAG_SHARP,


				/// 񋓗vf̐
				eFLAG_COUNT,
			};

			/// \L@
			enum ENotation
			{
				/// 8i
				eNOTATION_OCTAL,

				/// 10i
				eNOTATION_DECIMAL,

				/// 16i
				eNOTATION_HEXADECIMAL,


				/// 񋓗vf̐
				eNOTATION_COUNT,
			};


			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// MEMF͗񋓑̂Ɉˑ܂B
			/// tO̕Q
			static const TCHAR* mStKPFlagStrings[];

			/// MEMF͗񋓑̂Ɉˑ܂B
			/// \L@̕Q
			static const TCHAR* mStKPNotationStrings[];


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// vpeB
			struct SProperty
			{
			public:
				//====================================================================================================
				// Operation
				//----------------------------------------------------------------------------------------------------

				/// RXgN^
				SProperty();

				/// 
				void Initialize();

				/// MEMO:v̂ŉ͗pӂĂ܂B
				/// tO𗧂Ă
				void FlagUp(EFlag);

				/// MEMO:tO͂܂Ƃ߂ĊǗłIuWFNgƗǂ܂ˁBz񂶂ȂāB

				/// tH[}bgwq̃tO
				bool mFlags[eFLAG_COUNT];

				/// 0Ŗ߂邩ǂ
				bool mIsZeroReading;

				/// tB[hTCY
				int mFieldSize;

				/// x
				int mAccuracy;

				/// \L@
				ENotation mENotation;
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Formatting();

			/// fXgN^
			~Formatting();

			/// 
			void Initialize();

			/// ݒɊÂtH[}bgwq擾
			template <class T>
			tstring GetFormatSpecifierStr() const
			{
				// o͕ϐ
				tstring outStr;
				outStr.clear();

				// "%"
				outStr += _T('%');

				// tO
				outStr += GetFlagStr();

				// [[fBO
				outStr += GetZeroReadingChars();

				// tB[hTCY
				TCHAR fieldSizeChars[FORMAT_STR_SIZE_INIT];
				GetFieldSizeCharsPtr(fieldSizeChars, FORMAT_STR_SIZE_INIT);

				outStr += fieldSizeChars;

				// _Ɛx
				TCHAR accuracyChars[FORMAT_STR_SIZE_INIT];
				GetAccuracyWithPointCharsPtr(accuracyChars, FORMAT_STR_SIZE_INIT);

				outStr += accuracyChars;

				// ^
				outStr += FormattingHelper::ToFormatString<T>();

				// \L@ŕϊ
				outStr = ChangeFormatByNotation(outStr);

				return outStr;
			}

			
			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// 擾
			SProperty& GetPropertyRef()
			{
				return mSProperty;
			}

			/// 擾BconsttB
			const SProperty& GetPropertyRef() const
			{
				return mSProperty;
			}

			/// ݒ
			void SetProperty(const SProperty& kRSProperty)
			{
				mSProperty = kRSProperty;
			}

		private:
			/// 
			SProperty mSProperty;

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// tOɑΉ擾
			tstring GetFlagStr() const;

			/// [[fBÕtOɑΉ擾
			const TCHAR* GetZeroReadingChars() const;

			/// tB[hTCY̐l𕶎ƂĎ擾
			void GetFieldSizeCharsPtr(TCHAR* pDst, int size) const;

			/// x_݂̕ƂĂ擾
			void GetAccuracyWithPointCharsPtr(TCHAR* pDst, int size) const;

			/// tH[}bgwq\L@ɑΉĕϊ
			tstring ChangeFormatByNotation(const tstring&) const;
		};

	};
} // namespace Blast

#endif // BLAST_STRING_FORMATTING_H