#ifndef BLAST_STORAGE_DIRECTORY_H
#define BLAST_STORAGE_DIRECTORY_H

#include <vector>


namespace Blast
{
	namespace Storage
	{
		/// fBNg̏SNX
		class Directory
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// hCupX̍ő啶
			static const int mStKMaxDrive = _MAX_DRIVE;

			/// fBNg̍ő啶
			static const int mStKMaxDirectory = _MAX_DIR;

			/// t@C̍ő啶
			static const int mStKMaxFileName = _MAX_FNAME;

			/// gq̍ő啶
			static const int mStKMaxExtention = _MAX_EXT;

			/// pX̍ő啶
			static const int mStKMaxPath = _MAX_PATH;

		public:
			/// MEMO:݂̃fBNg̏ĺAexêtH_ƈv܂B
			/// MEMO:OƂāAVisualStudioNꍇ́AvWFNgt@CtH_ɂȂ܂B
			/// ݂̃fBNg܂ł̐΃pX擾
			static tstring GetCurrentDirectoryAbsolutePath();

			/// ݂̃fBNgύX
			static void SetCurrentDirectoryPath(const TCHAR* const);

			/// ݂̃fBNgZbg
			static void ResetCurrentDirectoryAbsolutePath();


			/// MEMO:Debugrh̏ꍇAɕtwDebug/x͏O܂B
			/// st@C̐΃pX擾
			static tstring GetExeAbsolutePath();


			/// ΃pX΃pXɕϊ
			static tstring ToAbsolutePath(const TCHAR* const kPFullPath, TCHAR pOutAbsPath[mStKMaxPath] = NULL);


			/// pXfBNgpX݂̂擾
			static tstring GetDirectoryPath(const TCHAR* const, TCHAR pOutPath[mStKMaxPath] = NULL);


			/// tpXt@Ĉ݂擾
			static tstring GetFileName(const TCHAR* const kPFullPath, TCHAR pOutFileName[mStKMaxFileName] = NULL);

			/// tpXgq݂̂擾
			static tstring GetExtention(const TCHAR* const kPFullPath, TCHAR pOutExtention[mStKMaxExtention] = NULL); 

			/// tpXgqtt@C擾
			static tstring GetFileNameWithExtention(const TCHAR* const kPFullPath, TCHAR pOut[mStKMaxFileName + mStKMaxExtention] = NULL);


			/// fBNg̑St@C擾
			static bool GetFileNamesInDirectory(const TCHAR* kPFullPath, std::vector<tstring>* pOut);


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Directory();

			/// fXgN^
			~Directory();

		private:
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// st@C̐΃tpX擾
			static tstring GetExeAbsoluteFullPath();

			/// ̃pXf~^'\''/'ɒu
			static tstring ReplaceYenToSlash(const TCHAR*);
		};

	} // namespace Storage
} // namespace Blast


#endif // BLAST_STORAGE_DIRECTORY_H