#ifndef BLAST_MATH_VECTOR3
#define BLAST_MATH_VECTOR3

namespace Blast
{
	namespace Math
	{
		/// Matrix̃vg^Cv
		class Matrix;


		/// 3̃xNgNX
		class Vector3
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// (0, 0, 0)擾
			static const Vector3& Zero();

			/// (1, 0, 0)擾
			static const Vector3& UnitX();

			/// (0, 1, 0)擾
			static const Vector3& UnitY();

			/// (0, 0, 1)擾
			static const Vector3& UnitZ();

			/// (1, 1, 1)擾
			static const Vector3& One();


			/// 擾
			static float Length(const Vector3&);

			/// 擾
			static float Distance(const Vector3&, const Vector3&);

			/// Pʉ
			static Vector3 Normalize(const Vector3&);

			/// 
			static float Dot(const Vector3&, const Vector3&);

			/// O
			static Vector3 Cross(const Vector3&, const Vector3&);

			
			//====================================================================================================
			// Union
			//----------------------------------------------------------------------------------------------------

			/// MEMO:pɂɈ̂publicɒuĂ܂B
			union
			{
				struct
				{
					/// Xl
					float mX;

					/// Yl
					float mY;

					/// Zl
					float mZ;
				};

				/// XYZ̔z
				float m[3];
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// ftHgRXgN^
			Vector3();

			/// RXgN^
			Vector3(float value);

			/// RXgN^
			Vector3(float a, float b, float c);

			/// fXgN^
			~Vector3();


			/// eZ
			void Add(float, float, float);

			/// eZ
			void Add(const Vector3&);


			/// eZ
			void Subtract(float, float, float);

			/// eZ
			void Subtract(const Vector3&);


			/// eZ
			void Multiply(float, float, float);

			/// eZ
			void Multiply(float);

			/// eZ
			void Multiply(volatile const Vector3&);
			
			/// sƏZ
			void Multiply(const Matrix&);



			/// eZ
			void Divide(float, float, float);

			/// eZ
			void Divide(float);

			/// eZ
			void Divide(const Vector3&);


			/// 擾
			float Length() const;


			/// 擾
			float Distance(const Vector3&) const;


			/// Pʉ
			Vector3 Normalize() const;


			/// ςZo
			float Dot(const Vector3&) const;

			/// OςZo
			Vector3 Cross(const Vector3&) const;


			/// z擾
			float* GetArray();

			/// z擾
			const float* GetArray() const;


			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------

			/// +Zqł̉Z\
			Vector3 operator+ (const Vector3&) const;

			/// -Zqł̌Z\
			Vector3 operator- (const Vector3&) const;

			/// *Zqł̏Z\
			Vector3 operator* (volatile const Vector3&) const;


			/// /Zqł̏Z\
			Vector3 operator/ (const Vector3&) const;

			/// /Zqł̏Z\
			Vector3 operator/ (float) const;


			/// +=Zqł̉Z\
			void operator+= (const Vector3&);

			/// -=Zqł̌Z\
			void operator-= (const Vector3&);

			/// *=Zqł̏Z\
			void operator*= (const Vector3&);

			/// /=Zqł̏Z\
			void operator/= (const Vector3&);


			/// YZq[]ł̒l擾\
			float& operator[] (int);


			// MEMO[131129]ǂfriend֐KvȂ̂vo܂ł́AĂ܂̂ŃRgAEgB

			///// -Zqł̌Z\
			//friend Vector3 operator- (const Vector3& kRVa, const Vector3& kRVb)
			//{
			//	Vector3 v = kRVa;

			//	v.Subtract(kRVb);

			//	return v;
			//}

			///// *Zqł̏Z\
			//friend Vector3 operator* (const Vector3& a, float n)
			//{
			//	Vector3 v = a;

			//	v.Multiply(n);

			//	return v;
			//}

			///// /Zqł̏Z\
			//friend Vector3 operator/ (const Vector3& kRV, float n)
			//{
			//	Vector3 v = kRV;

			//	v.Divide(n);

			//	return v;
			//}


#ifdef _DEBUG

			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// o
			void DebugOutput() const;

			/// `
			void DebugRender(int x, int y) const;

#endif // _DEBUG

		private:
			//====================================================================================================
			// PrivateStatic
			//----------------------------------------------------------------------------------------------------

			/// (0, 0, 0)
			static const Vector3 mStKZero;

			/// (1, 0, 0)
			static const Vector3 mStKUnitX;

			/// (0, 1, 0)
			static const Vector3 mStKUnitY;

			/// (0, 0, 1)
			static const Vector3 mStKUnitZ;

			/// (1, 1, 1)
			static const Vector3 mStKOne;
		};

	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_VECTOR3