#ifndef BLAST_MATH_RECTANGLE_H
#define BLAST_MATH_RECTANGLE_H

#include "Blast/String/FormattingHelper.h"


namespace Blast
{
	namespace Math
	{
		/// `̏ێNX
		template <class T = int>
		class Rectangle
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Rectangle() :
				mTopX(0),
				mTopY(0),
				mBottomX(0),
				mBottomY(0)
			{
			}

			/// RXgN^
			Rectangle(T topX, T topY, T bottomX, T bottomY) :
				mTopX(topX),
				mTopY(topY),
				mBottomX(bottomX),
				mBottomY(bottomY)
			{
			}

			/// fXgN^
			~Rectangle()
			{
			}

			
			/// 
			void Initialize()
			{
				mTopX = 0;
				mTopY = 0;
				mBottomX = 0;
				mBottomY = 0;
			}


			/// ŜXւ炷
			void ShiftX(T shiftX)
			{
				mTopX += shiftX;
				mBottomX += shiftX;
			}

			/// ŜYւ炷
			void ShiftY(T shiftY)
			{
				mTopY += shiftY;
				mBottomY += shiftY;
			}

			/// Ŝ炷
			void ShiftXY(T shiftX, T shiftY)
			{
				ShiftX(shiftX);
				ShiftY(shiftY);
			}


			/// ϓ
			void ShiftWidth(T shiftWidth)
			{
				mBottomX += shiftWidth;
			}

			/// cϓ
			void ShiftHeight(T shiftHeight)
			{
				mBottomY += shiftHeight;
			}

			/// Əcϓ
			void ShiftWidthHeight(T shiftWidth, T shiftHeight)
			{
				ShiftWidth(shiftWidth);
				ShiftHeight(shiftHeight);
			}


			/// L΂
			void StretchWidth(T stretchWidth)
			{
				mTopX -= stretchWidth;
				mBottomX += stretchWidth;
			}

			/// cL΂
			void StretchHeight(T)
			{
				mTopY -= stretchHeight;
				mBottomY += stretchHeight;
			}

			/// ŜL΂
			void StretchWidthHeight(T stretchWidth, T stretchHeight)
			{
				StretchWidth(stretchWidth);
				StretchHeight(stretchHeight);
			}


			/// 擾
			T GetWidth() const
			{
				T width = mBottomX - mTopX;

				return width;
			}

			/// ݒ
			void SetWidth(T width)
			{
				mBottomX = mTopX + width;
			}


			/// c擾
			T GetHeight() const
			{
				T height = mBottomY - mTopY;

				return height;
			}

			/// cݒ
			void SetHeight(T height)
			{
				mBottomY = mTopY + height;
			}


#if _DEBUG

			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// o
			void DebugOutput() const
			{
				// ^ɍo͎wq擾
				const TCHAR* kPFormat = Blast::String::FormattingHelper::ToFormatString<T>();

				// XWo
				tstring textStr = _T("XW:%");
				textStr += kPFormat;

				PFL(textStr.c_str(), mTopX);
				
				// YWo
				textStr = _T("YW:%");
				textStr += kPFormat;

				PFL(textStr.c_str(), mTopY);
				
				// EXWo
				textStr = _T("EXW:%");
				textStr += kPFormat;

				PFL(textStr.c_str(), mBottomX);
				
				// EYW
				textStr = _T("EXW:%");
				textStr += kPFormat;

				PFL(textStr.c_str(), mBottomY);
			}

#endif // _DEBUG

 
			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// XW
			T mTopX;

			/// YW
			T mTopY;

			/// EXW
			T mBottomX;

			/// EYW
			T mBottomY;

		private:
		};

	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_RECTANGLE_H