#ifndef BLAST_MATH_POINT_H
#define BLAST_MATH_POINT_H

namespace Blast
{
	namespace Math
	{
		/// 2W̐l̏SNX
		class Point
		{
		public:
			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Point();

			/// RXgN^
			Point(int);

			/// RXgN^
			Point(int, int);

			/// fXgN^
			~Point();


			/// e̘̓a擾
			int SquareLength() const;


			/// =
			void operator= (const Point&);

			/// +
			Point operator+ (const Point&) const;

			/// -
			Point operator- (const Point&) const;


			/// ==
			bool operator== (const Point&) const;

			/// +=
			void operator+= (const Point&);

			/// -=
			void operator-= (const Point&);


			/// []
			int& operator[] (int index);


			//====================================================================================================
			// Field
			//----------------------------------------------------------------------------------------------------

			/// Xl
			int mX;

			/// Yl
			int mY;

		private:
			//====================================================================================================
			// PrivateStatic
			//----------------------------------------------------------------------------------------------------

			/// (0, 0)
			static const Point stKZero;

			/// (1, 0)
			static const Point stKUnitX;

			/// (0, 1)
			static const Point stKUnitY;

			/// (1, 1)
			static const Point stKOne;
		};
	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_POINT_H