#ifndef BLAST_MATH_MATRIX_H
#define BLAST_MATH_MATRIX_H

namespace Blast
{
	namespace Math
	{
		/// Vector3̃vg^Cv
		class Vector3;


		/// }gbNX̏ێNX
		class Matrix
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// s̐
			static const int mStKRowCount = 4;

			/// ̐
			static const int mStKColumnCount = 4;


			/// Pʉ
			static void Identity(Matrix* pOut);

			
			/// gks쐬
			static Matrix CreateScale(float, float, float, Matrix* pOut);

			/// gks쐬
			static Matrix CreateScale(const Vector3&, Matrix* pOut);


			/// X]s쐬
			static Matrix CreateRotationX(float radian, Matrix* pOut);

			/// Y]s쐬
			static Matrix CreateRotationY(float radian, Matrix* pOut);

			/// Z]s쐬
			static Matrix CreateRotationZ(float radian, Matrix* pOut);
			
			/// ]s쐬
			static Matrix CreateRotationZXY(float, float, float, Matrix* pOut);

			/// ]s쐬
			static Matrix CreateRotationZXY(const Vector3&, Matrix* pOut);

			/// Cӎ]s쐬
			static Matrix CreateRotationAxis(const Vector3& kRAxis, float radian, Matrix* pOut);


			/// UV̉]s쐬
			static Matrix CreateRotationUV(float, Matrix*);

			
			/// ړs쐬
			static Matrix CreateTranslate(float, float, float, Matrix*);

			/// ړs쐬
			static Matrix CreateTranslate(const Vector3&, Matrix*);


			/// s]u
			static Matrix Transpose(const Matrix&, Matrix*);


			/// ts
			static Matrix Inverse(const Matrix&, Matrix*);


			//====================================================================================================
			// Union
			//----------------------------------------------------------------------------------------------------

			/// MEMO:Bȕ@̂B
			/// s̋p
			union 
			{
				/// \
				struct
				{
					float m11, m12, m13, m14;
					float m21, m22, m23, m24;
					float m31, m32, m33, m34;
					float m41, m42, m43, m44;
				};

				/// l̔z
				float m[mStKRowCount][mStKColumnCount];
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			Matrix();

			/// fXgN^
			~Matrix();


			/// Pʉ
			void Identity();


			/// gks쐬
			void CreateScale(float, float, float);

			/// gks쐬
			void CreateScale(const Vector3&);

			/// UV̊gks쐬
			void CreateScaleUV(float, float);

			/// UV̊gks쐬
			void CreateScaleUV(const Vector2&);


			/// X]s쐬
			void CreateRotationX(float);

			/// Y]s쐬
			void CreateRotationY(float);

			/// Z]s쐬
			void CreateRotationZ(float);
			
			/// ]s쐬
			void CreateRotationZXY(float, float, float);

			/// ]s쐬
			void CreateRotationZXY(const Vector3&);

			/// Cӎ]s쐬
			void CreateRotationAxis(const Vector3& kRAxis, float radian);


			/// UV̉]s쐬
			void CreateRotationUV(float);


			/// X]s
			void RotateX(float);

			/// Y]s
			void RotateY(float);

			/// Z]s
			void RotateZ(float);


			/// ړs쐬
			void CreateTranslate(float, float, float);

			/// ړs쐬
			void CreateTranslate(const Vector3&);

			/// MEMO:UVł͂ȂVector2ƂĔėpɂǂł傤B
			/// UV̈ړs쐬
			void CreateTranslateUV(float, float);

			/// UV̈ړs쐬
			void CreateTranslateUV(const Vector2&);


			/// ړs
			void Translate(float, float, float);

			/// ړs
			void Translate(const Vector3&);


			///s]u
			void Transpose();


			/// ts
			void Inverse();


			/// Wñr[s쐬
			void CreateViewLH(const Vector3& eyePosition, const Vector3& targetPosition, const Vector3& upUnit);


			/// Wn̓ϊs쐬
			void CreateParsepectiveFovLH(float fovy, float aspectRatio, float zNear, float zFar);

			/// Wn̐ˉes쐬
			void CreateOrthoGraphicLH(float width, float height, float zNear, float zFar);

			/// WñJX^}CYˉes쐬
			void CreateOrthoGraphicOffCenterLH(float l, float r, float b, float t, float zn, float zf);


			/// r[|[gϊs쐬
			void CreateViewport(float width, float height);

			
			//====================================================================================================
			// Overload
			//----------------------------------------------------------------------------------------------------
			
			/// *ɂs񉉎Z\
			Matrix operator* (const Matrix&) const;

			/// *=ɂs񉉎Z\
			void operator*= (const Matrix&);


			/// /ɂ鏜Z\
			Matrix operator/ (float) const;

			/// /~ɂ鏜Z\
			void operator/= (float);

#if _DEBUG

			//====================================================================================================
			// Debug
			//----------------------------------------------------------------------------------------------------

			/// \
			void DebugRender(int x, int y) const;

#endif // _DEBUG


		private:
			//====================================================================================================
			// PrivateStatic
			//----------------------------------------------------------------------------------------------------

			/// sincos̒l擾
			static void GetSinAndCos(float* pOutSin, float* pOutCos, float radian);

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// sƈ̏ZvZ
			float CalculateMultiplyRowColumn(const Matrix&, int rowNumber, int columnNumber) const;
		};

	} // namespace Math
} // namespace Blast

#endif // BLAST_MATH_MATRIX_H