#ifndef BLAST_INPUT_MOUSEDX8_H
#define BLAST_INPUT_MOUSEDX8_H

#include "Blast/Input/IMouse.h"


namespace Blast
{
	namespace Input
	{
		/// }EXpDirectX8̃foCX
		class MouseDeviceDX8;

		/// DirectX8InputDevice}EXNX
		class MouseDX8 : public Blast::Input::IMouse
		{
		public:
			//====================================================================================================
			// Static
			//----------------------------------------------------------------------------------------------------

			/// MEMO:DIMOUSESTATE2Œ`Ă鐔ƓlłB
			/// }EX̃{^̍ő吔
			static const int stKMouseButtonCount = 8;

			/// zC[̓͂sꂽƂ݂Ȃ΍Œl
			static const l32 stKWheelBorderValue = 100;


			//====================================================================================================
			// Enumerate
			//----------------------------------------------------------------------------------------------------

			/// }EXԂ̗񋓑
			enum EMouseState
			{
				/// Ȍ
				eMOUSE_STATE_OLD,

				/// ̏
				eMOUSE_STATE_CURRENT,

				/// 񋓗vf̐
				eMOUSE_STATE_COUNT,
			};


			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// {^̏
			struct SButtonState
			{
			public:
				/// Ԃ̍ől
				static const float stKMaxTime;

				/// RXgN^
				SButtonState();

				/// LȏԂ̍XV
				void UpdateEnable(const float&);

				/// ȏԂ̍XV
				void UpdateDisable(const float&);

				/// ĂԂ̎
				f32 mDownDurationTime;

				/// Ăx͌oߎ
				f32 mDownDelayTime;

				/// ĂԂ̎
				f32 mUpDurationTime;

				/// Ăx͌oߎ
				f32 mUpDelayTime;

			private:
				/// Nvs
				void UpdateClamp();
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			MouseDX8();

			/// fXgN^
			~MouseDX8();

			/// foCX쐬
			virtual bool Create(HWND, LPDIRECTINPUT8);

			/// XV
			virtual void Update(const float& kRDelta);

			/// {^Ă邩擾
			virtual bool IsDown(Buttons::EButton) const;

			/// {^ꂽuԂ擾
			virtual bool IsJustDown(Buttons::EButton) const;

			/// {^Ă邩擾
			virtual bool IsUp(Buttons::EButton) const;

			/// {^ꂽuԂ擾
			virtual bool IsJustUp(Buttons::EButton) const;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidDown(Buttons::EButton, const float& kRInterval);

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidUp(Buttons::EButton, const float& kRInterval);

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDown(Buttons::EButton, const float& kRInterval, const float& kRDelay);

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUp(Buttons::EButton, const float& kRInterval, const float& kRDelay);

			/// J[\XW擾
			virtual int GetPositionX() const;
			
			/// J[\YW擾
			virtual int GetPositionY() const;

			/// J[\XẄړʂ擾
			virtual int GetDeltaPositionX() const;

			/// J[\YẄړʂ擾
			virtual int GetDeltaPositionY() const;

			/// zC[̑ʂ擾
			virtual long GetWheel() const;

			/// zC[̏]sꂽǂ擾
			virtual bool IsWheelUp() const;

			/// zC[̉]sꂽǂ擾
			virtual bool IsWheelDown() const;

		private:
			/// }EXfoCX
			MouseDeviceDX8* mPDevice;

			/// }EX̏
			DIMOUSESTATE2 mMouseStatus[eMOUSE_STATE_COUNT];

			/// {^̏
			SButtonState mMouseButtonStatus[stKMouseButtonCount];

			/// J[\̈ʒuX
			long mPositionX;

			/// J[\̈ʒuY
			long mPositionY;

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// ԂLǂ
			bool IsEnable(const c8&) const;

			/// Ԃǂ
			bool IsDisable(const c8&) const;

			/// {^̍XV
			void UpdateMouseStates(const float&);
		};

	} // namespace Input
} // namespace Blast

#endif // BLAST_INPUT_MOUSEDX8_H