#ifndef BLAST_INPUT_KEYBOARDDX8_H
#define BLAST_INPUT_KEYBOARDDX8_H

#include "Blast/Input/IKeyboard.h"
#include <vector>


namespace Blast
{
	namespace Input
	{
		/// L[{[hpDirectX8̓̓foCX
		class KeyboardDeviceDX8;

		/// DirectX8InputDeviceL[{[hNX
		class KeyboardDX8 : public Blast::Input::IKeyboard
		{
		public:
			//====================================================================================================
			// Struct
			//----------------------------------------------------------------------------------------------------

			/// L[̏
			struct SKeyState
			{
			public:
				/// Ԃ̍ől
				static const float stKMaxTime;

				/// RXgN^
				SKeyState();

				/// LȏԂ̍XV
				void UpdateEnable(const float&);

				/// ȏԂ̍XV
				void UpdateDisable(const float&);

				/// Ȍ
				u8 mOldState;

				/// ĂԂ̎
				f32 mDownDurationTime;

				/// Ăx͌oߎ
				f32 mDownDelayTime;

				/// ĂԂ̎
				f32 mUpDurationTime;

				/// Ăx͌oߎ
				f32 mUpDelayTime;

			private:
				/// Nvs
				void UpdateClamp();
			};


			//====================================================================================================
			// Operation
			//----------------------------------------------------------------------------------------------------

			/// RXgN^
			KeyboardDX8();

			/// fXgN^
			~KeyboardDX8();

			/// foCX쐬
			virtual bool Create(HWND, LPDIRECTINPUT8);

			/// XV
			virtual void Update(const float& kRDelta);
			
			/// {^Ă邩擾
			virtual bool IsDown(Keys::EKey) const;

			/// {^ꂽuԂ擾
			virtual bool IsJustDown(Keys::EKey) const;

			/// ̃{^ꂽuԂ擾
			virtual bool IsJustDownAny() const;

			/// {^Ă邩擾
			virtual bool IsUp(Keys::EKey) const;

			/// {^ꂽuԂ擾
			virtual bool IsJustUp(Keys::EKey) const;

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidDown(Keys::EKey, const float& kRInterval);

			/// {^Ă邩ԊuŎ擾
			virtual bool IsRapidUp(Keys::EKey, const float& kRInterval);

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidDown(Keys::EKey, const float& kRInterval, const float& kRDelay);

			/// {^Ă邩莞ԌォԊuŎ擾
			virtual bool IsDelayRapidUp(Keys::EKey, const float& kRInterval, const float& kRDelay);

			/// ĂL[擾
			virtual void GetDownKeys(std::vector<Keys::EKey>* pOut) const;
			

			//====================================================================================================
			// Property
			//----------------------------------------------------------------------------------------------------

			/// L[̏Ԃ擾
			const u8* GetCurrentKeyStates() const
			{
				return mCurrentKeyStates;
			}

			/// L[擾
			const SKeyState* GetKeyStates() const
			{
				return mSKeyStates;
			}

		private:
			/// L[{[hfoCX
			KeyboardDeviceDX8* mPDevice;

			/// MEMO:\bhɓn߁A256oCg̔złȂƂȂdlł
			/// L[̏
			u8 mCurrentKeyStates[DIK_DATA_PACKET_SIZE];

			/// L[
			SKeyState mSKeyStates[DIK_DATA_PACKET_SIZE];

			
			//====================================================================================================
			// PrivateOperation
			//----------------------------------------------------------------------------------------------------

			/// ԂLǂ
			bool IsEnable(const u8&) const;

			/// Ԃǂ
			bool IsDisable(const u8&) const;

			/// L[̍XV
			void UpdateKeyStates(const float&);
		};

	} // namespace Input
} // namespace Blast

#endif // BLAST_INPUT_KEYBOARDDX8_H